/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.INbtWritable;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.network.IStreamable;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.EscritoireGameToken;
import forestry.core.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public class EscritoireGameBoard
implements INbtWritable,
IStreamable {
    private static final RandomSource rand = RandomSource.m_216327_();
    private static final int TOKEN_COUNT_MAX = 22;
    private static final int TOKEN_COUNT_MIN = 6;
    private final List<EscritoireGameToken> gameTokens = new ArrayList<EscritoireGameToken>(22);
    private int tokenCount;

    public EscritoireGameBoard() {
    }

    public EscritoireGameBoard(CompoundTag nbt) {
        this.tokenCount = nbt.m_128451_("TokenCount");
        if (this.tokenCount > 0) {
            EscritoireGameToken[] tokens = new EscritoireGameToken[this.tokenCount];
            ListTag nbttaglist = nbt.m_128437_("GameTokens", 9);
            for (int j = 0; j < nbttaglist.size(); ++j) {
                CompoundTag CompoundNBT2 = nbttaglist.m_128728_(j);
                byte index = CompoundNBT2.m_128445_("Slot");
                tokens[index] = new EscritoireGameToken(CompoundNBT2);
            }
            Collections.addAll(this.gameTokens, tokens);
        }
    }

    public boolean initialize(ItemStack specimen) {
        IIndividual individual = IIndividualHandlerItem.getIndividual(specimen);
        if (individual != null) {
            ISpeciesType<?, ?> type = individual.getType();
            this.tokenCount = EscritoireGameBoard.getTokenCount(individual);
            for (int i = 0; i < this.tokenCount / 2; ++i) {
                Object randomSpecies = type.getRandomSpecies(rand);
                this.gameTokens.add(new EscritoireGameToken((ISpecies<?>)randomSpecies));
                this.gameTokens.add(new EscritoireGameToken((ISpecies<?>)randomSpecies));
            }
            Collections.shuffle(this.gameTokens);
            return true;
        }
        return false;
    }

    @Nullable
    public EscritoireGameToken getToken(int index) {
        if (index >= this.tokenCount || index >= this.gameTokens.size()) {
            return null;
        }
        return this.gameTokens.get(index);
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public void hideProbedTokens() {
        for (EscritoireGameToken token : this.gameTokens) {
            if (!token.isProbed()) continue;
            token.setProbed(false);
        }
    }

    private List<EscritoireGameToken> getUnrevealedTokens() {
        ArrayList<EscritoireGameToken> unrevealed = new ArrayList<EscritoireGameToken>();
        for (EscritoireGameToken token : this.gameTokens) {
            if (token.isVisible()) continue;
            unrevealed.add(token);
        }
        return unrevealed;
    }

    @Nullable
    private EscritoireGameToken getSelected() {
        for (EscritoireGameToken token : this.gameTokens) {
            if (!token.isSelected()) continue;
            return token;
        }
        return null;
    }

    private boolean isBoardCleared() {
        for (EscritoireGameToken token : this.gameTokens) {
            if (token.isMatched()) continue;
            return false;
        }
        return true;
    }

    public void probe() {
        List<EscritoireGameToken> tokens = this.getUnrevealedTokens();
        int index = rand.m_188503_(tokens.size());
        EscritoireGameToken token = tokens.get(index);
        token.setProbed(true);
    }

    public EscritoireGame.Status choose(EscritoireGameToken token) {
        EscritoireGame.Status status = EscritoireGame.Status.PLAYING;
        if (token.isMatched() || token.isSelected()) {
            return status;
        }
        EscritoireGameToken selected = this.getSelected();
        if (selected == null) {
            token.setSelected();
            this.hideProbedTokens();
        } else if (token.matches(selected)) {
            selected.setMatched();
            token.setMatched();
            if (this.isBoardCleared()) {
                status = EscritoireGame.Status.SUCCESS;
            }
            this.hideProbedTokens();
        } else {
            token.setFailed();
            selected.setFailed();
            status = EscritoireGame.Status.FAILURE;
        }
        return status;
    }

    public void reset() {
        this.gameTokens.clear();
        this.tokenCount = 0;
    }

    private static int getTokenCount(IIndividual individual) {
        ISpecies<?> species1 = individual.getSpecies();
        ISpecies<?> species2 = individual.getInactiveSpecies();
        int tokenCount = species1.getComplexity() + species2.getComplexity();
        if (tokenCount % 2 != 0) {
            tokenCount = Math.round((float)tokenCount / 2.0f) * 2;
        }
        if (tokenCount > 22) {
            tokenCount = 22;
        } else if (tokenCount < 6) {
            tokenCount = 6;
        }
        return tokenCount;
    }

    @Override
    public CompoundTag write(CompoundTag compoundNBT) {
        if (this.tokenCount > 0) {
            compoundNBT.m_128405_("TokenCount", this.tokenCount);
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.tokenCount; ++i) {
                EscritoireGameToken token = this.gameTokens.get(i);
                if (token == null) continue;
                CompoundTag compoundNBT2 = new CompoundTag();
                compoundNBT2.m_128344_("Slot", (byte)i);
                token.write(compoundNBT2);
                nbttaglist.add((Object)compoundNBT2);
            }
            compoundNBT.m_128365_("GameTokens", (Tag)nbttaglist);
        } else {
            compoundNBT.m_128405_("TokenCount", 0);
        }
        return compoundNBT;
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        data.m_130130_(this.tokenCount);
        NetworkUtil.writeStreamables(data, this.gameTokens);
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        this.tokenCount = data.m_130242_();
        NetworkUtil.readStreamables(data, this.gameTokens, EscritoireGameToken::new);
    }
}

