/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import forestry.core.tiles.EscritoireGame;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;

public class EscritoireTextSource {
    private static final ListMultimap<Notes, Component> researchNotes;
    private static final Random random;
    @Nullable
    private Component researchNote;
    @Nullable
    private Notes lastNoteLevel;

    public Component getText(EscritoireGame escritoireGame) {
        Notes noteLevel = EscritoireTextSource.getNoteLevel(escritoireGame);
        if (this.lastNoteLevel != noteLevel || this.researchNote == null) {
            this.researchNote = EscritoireTextSource.getRandomNote(noteLevel);
            this.lastNoteLevel = noteLevel;
        }
        return this.researchNote;
    }

    private static Component getRandomNote(Notes level) {
        List candidates = researchNotes.get((Object)level);
        int index = random.nextInt(candidates.size());
        return (Component)candidates.get(index);
    }

    private static Notes getNoteLevel(EscritoireGame game) {
        EscritoireGame.Status status = game.getStatus();
        switch (status) {
            case PLAYING: {
                int bounty = game.getBountyLevel();
                if (bounty >= 16) {
                    return Notes.level1;
                }
                if (bounty > 8) {
                    return Notes.level2;
                }
                if (bounty > 4) {
                    return Notes.level3;
                }
                return Notes.level4;
            }
            case FAILURE: {
                return Notes.failure;
            }
            case SUCCESS: {
                return Notes.success;
            }
            case EMPTY: {
                return Notes.empty;
            }
        }
        return null;
    }

    static {
        random = new Random();
        researchNotes = ArrayListMultimap.create();
        EnumSet<Notes[]> multipleTranslationNoteLevels = EnumSet.of(Notes.level1, new Notes[]{Notes.level2, Notes.level3, Notes.level4, Notes.success, Notes.failure});
        for (Notes notes : multipleTranslationNoteLevels) {
            for (int i = 1; i <= 10; ++i) {
                String key = "for.gui.escritoire.notes." + notes + "." + i;
                if (!Language.m_128107_().m_6722_(key)) continue;
                researchNotes.put((Object)notes, (Object)Component.m_237115_((String)key));
            }
        }
        researchNotes.put((Object)Notes.empty, (Object)Component.m_237115_((String)"for.gui.escritoire.instructions"));
    }

    private static enum Notes {
        level1,
        level2,
        level3,
        level4,
        success,
        failure,
        empty;

    }
}

