/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.genetics.ISpeciesType;
import forestry.core.gui.ContainerNaturalistInventory;
import forestry.core.gui.IPagedInventory;
import forestry.core.inventory.InventoryNaturalistChest;
import forestry.core.tiles.TileBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public abstract class TileNaturalistChest
extends TileBase
implements IPagedInventory {
    private static final float lidAngleVariationPerTick = 0.1f;
    public static final VoxelShape CHEST_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private final ISpeciesType<?, ?> speciesType;
    public float lidAngle;
    public float prevLidAngle;
    private int numPlayersUsing;

    public TileNaturalistChest(BlockEntityType type, BlockPos pos, BlockState state, ISpeciesType<?, ?> speciesType) {
        super(type, pos, state);
        this.speciesType = speciesType;
        this.setInternalInventory(new InventoryNaturalistChest(this, speciesType));
    }

    public void increaseNumPlayersUsing() {
        if (this.numPlayersUsing == 0) {
            this.playLidSound(this.f_58857_, SoundEvents.f_11749_);
        }
        ++this.numPlayersUsing;
        this.sendNetworkUpdate();
    }

    public void decreaseNumPlayersUsing() {
        --this.numPlayersUsing;
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        if (this.numPlayersUsing == 0) {
            this.playLidSound(this.f_58857_, SoundEvents.f_11747_);
        }
        this.sendNetworkUpdate();
    }

    @Override
    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            this.lidAngle = Math.max(Math.min(this.lidAngle, 1.0f), 0.0f);
        }
    }

    private void playLidSound(Level level, SoundEvent sound) {
        level.m_5594_(null, this.m_58899_(), sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    @Override
    public void flipPage(ServerPlayer player, short page) {
        this.openMenu(player, page, true);
    }

    @Override
    public void openGui(ServerPlayer player, InteractionHand hand, BlockPos pos) {
        this.openMenu(player, 0, false);
    }

    private void openMenu(ServerPlayer player, int page, boolean isFlipPage) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new PagedMenuProvider(page, isFlipPage), p -> {
            p.m_130064_(this.f_58858_);
            p.m_130130_(page);
            p.writeBoolean(isFlipPage);
        });
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        data.writeInt(this.numPlayersUsing);
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        this.numPlayersUsing = data.readInt();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerNaturalistInventory(windowId, inv, this, 0, false);
    }

    public ISpeciesType<?, ?> getSpeciesType() {
        return this.speciesType;
    }

    private class PagedMenuProvider
    implements MenuProvider {
        private final int page;
        private final boolean isFlipPage;

        private PagedMenuProvider(int page, boolean isFlipPage) {
            this.page = page;
            this.isFlipPage = isFlipPage;
        }

        public Component m_5446_() {
            return TileNaturalistChest.this.m_5446_();
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
            return new ContainerNaturalistInventory(windowId, playerInv, TileNaturalistChest.this, this.page, this.isFlipPage);
        }
    }
}

