/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.IProduct;
import it.unimi.dsi.fastutil.Hash;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public abstract class ItemStackUtil {
    public static final Hash.Strategy<ItemStack> ITEM_STACK_STRATEGY = new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            if (o.m_41619_()) {
                return 0;
            }
            int result = 1;
            result = 31 * result + o.m_41613_();
            result = 31 * result + o.m_41720_().hashCode();
            if (o.m_41782_()) {
                result = 31 * result + o.m_41783_().hashCode();
            }
            return result;
        }

        public boolean equals(ItemStack a, ItemStack b) {
            if (a == null || b == null) {
                return a == b;
            }
            return ItemStack.m_41728_((ItemStack)a, (ItemStack)b);
        }
    };
    private static final int[] EMPTY_CONSUME = new int[0];

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        return ItemStack.m_150942_((ItemStack)lhs, (ItemStack)rhs);
    }

    public static void mergeStacks(ItemStack giver, ItemStack receptor) {
        int maxInsert = receptor.m_41741_() - receptor.m_41613_();
        int maxExtract = giver.m_41613_();
        int canTransfer = Math.min(maxInsert, maxExtract);
        giver.m_41774_(canTransfer);
        receptor.m_41769_(canTransfer);
    }

    public static Map<ItemStack, Integer> condensedStackCounts(List<ItemStack> stacks) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            boolean found = false;
            for (Map.Entry entry : map.entrySet()) {
                if (!ItemStackUtil.isIdenticalItem((ItemStack)entry.getKey(), copy)) continue;
                map.put((ItemStack)entry.getKey(), (Integer)map.get(entry.getKey()) + stack.m_41613_());
                found = true;
                break;
            }
            if (found) continue;
            map.put(copy, stack.m_41613_());
        }
        return map;
    }

    public static List<ItemStack> realizeStacks(Map<ItemStack, Integer> map) {
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>(map.size());
        for (Map.Entry<ItemStack, Integer> entry : map.entrySet()) {
            int transfer;
            ItemStack stack = entry.getKey();
            for (int count = entry.getValue().intValue(); count > 0; count -= transfer) {
                transfer = Math.min(count, stack.m_41741_());
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(transfer);
                condensed.add(copy);
            }
        }
        return condensed;
    }

    public static List<ItemStack> condenseStacks(List<ItemStack> stacks) {
        return ItemStackUtil.realizeStacks(ItemStackUtil.condensedStackCounts(stacks));
    }

    public static boolean containsItemStack(Iterable<ItemStack> list, ItemStack itemStack) {
        for (ItemStack listStack : list) {
            if (!ItemStackUtil.isIdenticalItem(listStack, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static int[] createConsume(List<Ingredient> set, Container inventory, boolean craftingTools) {
        return ItemStackUtil.createConsume(set, inventory.m_6643_(), arg_0 -> ((Container)inventory).m_8020_(arg_0), craftingTools);
    }

    public static int[] createConsume(List<Ingredient> set, int stockCount, IntFunction<ItemStack> stock, boolean craftingTools) {
        int[] reqAmounts = new int[stockCount];
        int found = 0;
        block0: for (Ingredient ing : set) {
            if (ing.m_43947_()) {
                ++found;
                continue;
            }
            for (int i = 0; i < reqAmounts.length; ++i) {
                ItemStack offer = stock.apply(i);
                if (offer.m_41613_() <= reqAmounts[i] || !ing.test(offer)) continue;
                reqAmounts[i] = reqAmounts[i] + 1;
                ++found;
                continue block0;
            }
        }
        if (found < set.size()) {
            return EMPTY_CONSUME;
        }
        return reqAmounts;
    }

    public static int containsSets(List<ItemStack> set, List<ItemStack> stock) {
        return ItemStackUtil.containsSets(set, stock, false);
    }

    public static int containsSets(List<ItemStack> set, List<ItemStack> stock, boolean craftingTools) {
        int totalSets = 0;
        Map<ItemStack, Integer> condensedRequired = ItemStackUtil.condensedStackCounts(set);
        Map<ItemStack, Integer> condensedOffered = ItemStackUtil.condensedStackCounts(stock);
        for (Map.Entry<ItemStack, Integer> req : condensedRequired.entrySet()) {
            if (req.getValue() <= 0) continue;
            int offerCount = 0;
            for (Map.Entry<ItemStack, Integer> offer : condensedOffered.entrySet()) {
                if (!ItemStackUtil.isCraftingEquivalent(req.getKey(), offer.getKey(), craftingTools)) continue;
                offerCount += offer.getValue().intValue();
            }
            int reqCount = offerCount / req.getValue();
            if (reqCount == 0) {
                return 0;
            }
            if (totalSets == 0) {
                totalSets = reqCount;
                continue;
            }
            if (totalSets <= reqCount) continue;
            totalSets = reqCount;
        }
        return totalSets;
    }

    public static boolean equalSets(NonNullList<ItemStack> set1, NonNullList<ItemStack> set2) {
        if (set1 == set2) {
            return true;
        }
        int count = set1.size();
        if (count != set2.size()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (ItemStackUtil.isIdenticalItem((ItemStack)set1.get(i), (ItemStack)set2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison) {
        if (base.m_41619_() || comparison.m_41619_()) {
            return false;
        }
        if (base.m_41720_() != comparison.m_41720_()) {
            return false;
        }
        if (base.m_41783_() == null || base.m_41783_().m_128456_()) {
            return true;
        }
        return base.m_41783_().equals((Object)comparison.m_41783_());
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean craftingTools) {
        if (base.m_41619_() || comparison.m_41619_()) {
            return false;
        }
        if (craftingTools && ItemStackUtil.isCraftingToolEquivalent(base, comparison)) {
            return true;
        }
        return ItemStackUtil.isCraftingEquivalent(base, comparison);
    }

    public static boolean isCraftingToolEquivalent(ItemStack base, ItemStack comparison) {
        if (base.m_41619_() || comparison.m_41619_()) {
            return false;
        }
        Item baseItem = base.m_41720_();
        if (baseItem != comparison.m_41720_()) {
            return false;
        }
        return base.m_41783_() == null || base.m_41783_().m_128456_();
    }

    public static void dropItemStackAsEntity(ItemStack items, Level world, double x, double y, double z) {
        ItemStackUtil.dropItemStackAsEntity(items, world, x, y, z, 10);
    }

    public static void dropItemStackAsEntity(ItemStack items, Level world, BlockPos pos) {
        ItemStackUtil.dropItemStackAsEntity(items, world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 10);
    }

    public static void dropItemStackAsEntity(ItemStack items, Level world, double x, double y, double z, int delayForPickup) {
        if (items.m_41619_() || world.f_46443_) {
            return;
        }
        float f1 = 0.4f;
        double d = (double)(world.f_46441_.m_188501_() * f1 + (1.0f - f1)) * 0.5;
        double d1 = (double)(world.f_46441_.m_188501_() * f1 + (1.0f - f1)) * 0.5;
        double d2 = (double)(world.f_46441_.m_188501_() * f1 + (1.0f - f1)) * 0.5;
        ItemEntity entityitem = new ItemEntity(world, x + d, y + d1, z + d2, items);
        entityitem.m_32010_(delayForPickup);
        world.m_7967_((Entity)entityitem);
    }

    public static ItemStack copyWithRandomSize(IProduct template, int max, RandomSource rand) {
        int size = max <= 0 ? 1 : rand.m_188503_(max);
        ItemStack copy = template.createRandomStack(rand);
        copy.m_41764_(Math.min(size, copy.m_41741_()));
        return copy;
    }

    public static boolean areItemStacksEqualIgnoreCount(ItemStack a, ItemStack b) {
        int countB = b.m_41613_();
        b.m_41764_(a.m_41613_());
        boolean equals = a.equals(b, false);
        b.m_41764_(countB);
        return equals;
    }
}

