/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.base.Preconditions;
import forestry.api.IForestryApi;
import forestry.api.climate.ClimateState;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.modules.IForestryPacketClient;
import forestry.api.modules.IForestryPacketServer;
import forestry.core.network.IStreamable;
import forestry.core.network.NetworkHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMap;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class NetworkUtil {
    public static void sendNetworkPacket(IForestryPacketClient packet, BlockPos pos, Level level) {
        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)packet);
    }

    public static void sendToPlayer(IForestryPacketClient packet, ServerPlayer player) {
        NetworkHandler.CHANNEL.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAllPlayers(IForestryPacketClient packet) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
        }
    }

    public static void writePayloadBuffer(FriendlyByteBuf buffer, Consumer<FriendlyByteBuf> dataWriter) {
        int dataBytesIndex = buffer.writerIndex();
        buffer.writeInt(0);
        dataWriter.accept(buffer);
        int numDataBytes = buffer.writerIndex() - dataBytesIndex - 4;
        buffer.setInt(dataBytesIndex, numDataBytes);
    }

    public static FriendlyByteBuf readPayloadBuffer(FriendlyByteBuf buffer) {
        return new FriendlyByteBuf(buffer.readBytes(buffer.readInt()));
    }

    public static void sendToServer(IForestryPacketServer packet) {
        NetworkHandler.CHANNEL.sendToServer((Object)packet);
    }

    public static void writeItemStacks(FriendlyByteBuf buffer, List<ItemStack> itemStacks) {
        buffer.m_130130_(itemStacks.size());
        for (ItemStack stack : itemStacks) {
            buffer.m_130055_(stack);
        }
    }

    public static NonNullList<ItemStack> readItemStacks(FriendlyByteBuf buffer) {
        int stackCount = buffer.m_130242_();
        NonNullList itemStacks = NonNullList.m_122779_();
        for (int i = 0; i < stackCount; ++i) {
            itemStacks.add((Object)buffer.m_130267_());
        }
        return itemStacks;
    }

    public static void writeInventory(FriendlyByteBuf buffer, Container inventory) {
        int size = inventory.m_6643_();
        buffer.m_130130_(size);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            buffer.m_130055_(stack);
        }
    }

    public static void readInventory(FriendlyByteBuf buffer, Container inventory) {
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = buffer.m_130267_();
            inventory.m_6836_(i, stack);
        }
    }

    public static <T extends Enum<T>> void writeEnum(FriendlyByteBuf buffer, T enumValue) {
        buffer.writeByte(enumValue.ordinal());
    }

    public static <T extends Enum<T>> T readEnum(FriendlyByteBuf buffer, T[] enumValues) {
        Preconditions.checkArgument((enumValues.length < 127 ? 1 : 0) != 0);
        return enumValues[buffer.readByte()];
    }

    public static void writeStreamable(FriendlyByteBuf buffer, @Nullable IStreamable streamable) {
        if (streamable != null) {
            buffer.writeBoolean(true);
            streamable.writeData(buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Nullable
    public static <T extends IStreamable> T readStreamable(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> factory) {
        if (buffer.readBoolean()) {
            return (T)((IStreamable)factory.apply(buffer));
        }
        return null;
    }

    public static <T extends IStreamable> void writeStreamables(FriendlyByteBuf buffer, @Nullable List<T> streamables) {
        if (streamables == null) {
            buffer.m_130130_(0);
        } else {
            buffer.m_130130_(streamables.size());
            for (IStreamable streamable : streamables) {
                NetworkUtil.writeStreamable(buffer, streamable);
            }
        }
    }

    public static <T extends IStreamable> void readStreamables(FriendlyByteBuf buffer, List<T> outputList, Function<FriendlyByteBuf, T> factory) {
        outputList.clear();
        int length = buffer.m_130242_();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                T streamable = NetworkUtil.readStreamable(buffer, factory);
                outputList.add(streamable);
            }
        }
    }

    public static void writeClimateState(FriendlyByteBuf buffer, @Nullable IClimateProvider climateState) {
        if (climateState != null) {
            buffer.writeBoolean(true);
            buffer.writeByte(climateState.temperature().ordinal());
            buffer.writeByte(climateState.humidity().ordinal());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static void writeClimateState(FriendlyByteBuf buffer, TemperatureType temperature, HumidityType humidity) {
        buffer.writeBoolean(true);
        buffer.writeByte(temperature.ordinal());
        buffer.writeByte(humidity.ordinal());
    }

    public static IClimateProvider readClimateState(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new ClimateState(TemperatureType.VALUES.get(buffer.readByte()), HumidityType.VALUES.get(buffer.readByte()));
        }
        return IForestryApi.INSTANCE.getClimateManager().createDummyClimateProvider();
    }

    public static void writeBlockState(FriendlyByteBuf buffer, BlockState state) {
        buffer.m_236818_((IdMap)Block.f_49791_, (Object)state);
    }

    public static BlockState readBlockState(FriendlyByteBuf buffer) {
        return (BlockState)buffer.m_236816_((IdMap)Block.f_49791_);
    }

    public static void writeDirection(FriendlyByteBuf buffer, Direction direction) {
        buffer.writeByte(direction.ordinal());
    }

    public static Direction readDirection(FriendlyByteBuf buffer) {
        byte ordinal = buffer.readByte();
        if (ordinal > 5 || ordinal < 0) {
            throw new IllegalArgumentException("Tried to deserialize Direction enum from network, but got invalid ordinal: " + ordinal);
        }
        return Direction.f_122346_[ordinal];
    }

    public static void writeShortArray(FriendlyByteBuf buffer, short[] array) {
        buffer.m_130130_(array.length);
        for (short value : array) {
            buffer.writeShort((int)value);
        }
    }

    public static short[] readShortArray(FriendlyByteBuf buffer) {
        short[] array = new short[buffer.m_130242_()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buffer.readShort();
        }
        return array;
    }
}

