/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import forestry.Forestry;
import forestry.api.IForestryApi;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.climate.IClimateProvider;
import forestry.api.genetics.ForestrySpeciesTypes;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.alleles.IRegistryAllele;
import forestry.api.genetics.alleles.IRegistryChromosome;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.api.plugin.IGenomeBuilder;
import forestry.core.config.ForestryConfig;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.common.util.Lazy;
import org.apache.logging.log4j.Logger;

public class SpeciesUtil {
    public static final Lazy<IBeeSpeciesType> BEE_TYPE = Lazy.of(() -> IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(ForestrySpeciesTypes.BEE, IBeeSpeciesType.class));
    public static final Lazy<ITreeSpeciesType> TREE_TYPE = Lazy.of(() -> IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(ForestrySpeciesTypes.TREE, ITreeSpeciesType.class));
    public static final Lazy<IButterflySpeciesType> BUTTERFLY_TYPE = Lazy.of(() -> IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(ForestrySpeciesTypes.BUTTERFLY, IButterflySpeciesType.class));

    public static ITreeSpecies getTreeSpecies(ResourceLocation id) {
        return (ITreeSpecies)((ITreeSpeciesType)TREE_TYPE.get()).getSpecies(id);
    }

    public static List<ITreeSpecies> getAllTreeSpecies() {
        return ((ITreeSpeciesType)TREE_TYPE.get()).getAllSpecies();
    }

    public static IBeeSpecies getBeeSpecies(ResourceLocation id) {
        return (IBeeSpecies)((IBeeSpeciesType)BEE_TYPE.get()).getSpecies(id);
    }

    public static List<IBeeSpecies> getAllBeeSpecies() {
        return ((IBeeSpeciesType)BEE_TYPE.get()).getAllSpecies();
    }

    public static IButterflySpecies getButterflySpecies(ResourceLocation id) {
        return (IButterflySpecies)((IButterflySpeciesType)BUTTERFLY_TYPE.get()).getSpecies(id);
    }

    public static List<IButterflySpecies> getAllButterflySpecies() {
        return ((IButterflySpeciesType)BUTTERFLY_TYPE.get()).getAllSpecies();
    }

    @Nullable
    public static ISpecies<?> getAnySpecies(ResourceLocation id) {
        IRegistryAllele allele = (IRegistryAllele)ForestryAlleles.REGISTRY.getAllele(id);
        return allele == null ? null : (ISpecies)allele.value();
    }

    public static void addTypeToCreativeTab(CreativeModeTab.Output items, ResourceLocation speciesTypeId) {
        ISpeciesType<?, ?> speciesType = IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(speciesTypeId);
        for (ILifeStage stage : speciesType.getLifeStages()) {
            for (ISpecies species : speciesType.getAllSpecies()) {
                items.m_246342_(species.createStack(stage));
            }
        }
    }

    @Nullable
    public static <I extends IIndividual> Tag serializeIndividual(I individual) {
        Codec<?> individualCodec = individual.getType().getIndividualCodec();
        return individualCodec.encodeStart((DynamicOps)NbtOps.f_128958_, individual).result().orElse(null);
    }

    public static <I extends IIndividual> I deserializeIndividual(ISpeciesType<?, I> type, Tag nbt) {
        return (I)((IIndividual)type.getIndividualCodec().decode((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)Forestry.LOGGER).error(arg_0)).orElseGet(() -> Pair.of(type.getDefaultSpecies().createIndividual().cast(), (Object)nbt)).getFirst());
    }

    @Nullable
    public static <S extends ISpecies<?>> ImmutableList<AllelePair<?>> mutateSpecies(Level level, BlockPos pos, @Nullable GameProfile profile, IGenome parent1, IGenome parent2, IRegistryChromosome<S> speciesChromosome, IMutationChanceGetter<S> chanceGetter) {
        IGenome secondGenome;
        IGenome firstGenome;
        ISpecies secondParent;
        ISpecies firstParent;
        if (level.f_46441_.m_188499_()) {
            firstParent = (ISpecies)parent1.getActiveValue(speciesChromosome);
            secondParent = (ISpecies)parent2.getInactiveValue(speciesChromosome);
            firstGenome = parent1;
            secondGenome = parent2;
        } else {
            firstParent = (ISpecies)parent2.getActiveValue(speciesChromosome);
            secondParent = (ISpecies)parent1.getInactiveValue(speciesChromosome);
            firstGenome = parent2;
            secondGenome = parent1;
        }
        Object speciesType = parent1.getActiveSpecies().getType().cast();
        IBreedingTracker tracker = profile == null ? null : speciesType.getBreedingTracker((LevelAccessor)level, profile);
        IClimateProvider climate = IForestryApi.INSTANCE.getClimateManager().createClimateProvider((LevelReader)level, pos);
        for (IMutation<ISpecies> mutation : speciesType.getMutations().getCombinationsShuffled(firstParent, secondParent, level.f_46441_)) {
            float chance = chanceGetter.getChance(mutation, level, pos, firstGenome, secondGenome, climate);
            if (chance <= 0.0f) continue;
            if (tracker != null && tracker.isResearched(mutation)) {
                float mutationBoost = chance * (((Double)ForestryConfig.SERVER.researchMutationBoostMultiplier.get()).floatValue() - 1.0f);
                mutationBoost = Math.min(((Double)ForestryConfig.SERVER.maxResearchMutationBoostPercent.get()).floatValue(), mutationBoost);
                chance += mutationBoost;
            }
            if (!(chance > level.f_46441_.m_188501_())) continue;
            if (tracker != null) {
                tracker.registerMutation(mutation);
            }
            return mutation.getResultAlleles();
        }
        return null;
    }

    public static <I extends IIndividual> I createOffspring(RandomSource rand, IGenome self, IGenome mate, ISpeciesMutator mutator, Function<IGenome, I> individualFactory, boolean makeHaploid) {
        IKaryotype karyotype = self.getKaryotype();
        IGenomeBuilder genome = karyotype.createGenomeBuilder();
        ImmutableList<AllelePair<?>> parent1 = self.getAllelePairs();
        ImmutableList<AllelePair<?>> parent2 = mate.getAllelePairs();
        boolean didMutate1 = false;
        boolean didMutate2 = false;
        if (!makeHaploid) {
            ImmutableList<AllelePair<?>> mutated2;
            ImmutableList<AllelePair<?>> mutated1 = mutator.mutateSpecies(self, mate);
            if (mutated1 != null) {
                parent1 = mutated1;
                didMutate1 = true;
            }
            if ((mutated2 = mutator.mutateSpecies(mate, self)) != null) {
                parent2 = mutated2;
                didMutate2 = true;
            }
        }
        ImmutableList<IChromosome<?>> chromosomes = karyotype.getChromosomes();
        for (int i = 0; i < chromosomes.size(); ++i) {
            IChromosome chromosome = (IChromosome)chromosomes.get(i);
            AllelePair allele1 = (AllelePair)parent1.get(i);
            AllelePair allele2 = (AllelePair)parent2.get(i);
            Object defaultAllele = karyotype.getDefaultAllele(chromosome);
            if (!makeHaploid && karyotype.isWeaklyInherited(chromosome)) {
                if (didMutate1 && allele1.active() == defaultAllele) {
                    allele1 = self.getAllelePair(chromosome);
                }
                if (didMutate2 && allele2.active() == defaultAllele) {
                    allele2 = mate.getAllelePair(chromosome);
                }
            }
            genome.setUnchecked(chromosome, makeHaploid ? allele1.inheritHaploid(rand) : allele1.inheritOther(rand, allele2));
        }
        return (I)((IIndividual)individualFactory.apply(genome.build()));
    }

    public static <I extends IIndividual> I createOffspring(RandomSource rand, IGenome self, IGenome mate, ISpeciesMutator mutator, Function<IGenome, I> individualFactory) {
        return SpeciesUtil.createOffspring(rand, self, mate, mutator, individualFactory, false);
    }

    @FunctionalInterface
    public static interface IMutationChanceGetter<S extends ISpecies<?>> {
        public float getChance(IMutation<S> var1, Level var2, BlockPos var3, IGenome var4, IGenome var5, IClimateProvider var6);
    }

    @FunctionalInterface
    public static interface ISpeciesMutator {
        @Nullable
        public ImmutableList<AllelePair<?>> mutateSpecies(IGenome var1, IGenome var2);
    }
}

