/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.utils.RecipeUtils;
import forestry.core.utils.SlotUtil;
import forestry.factory.tiles.TileFabricator;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;

public class InventoryFabricator
extends InventoryAdapterTile<TileFabricator> {
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_INVENTORY_1 = 3;
    public static final short SLOT_INVENTORY_COUNT = 18;
    public static final short SLOT_COUNT = 21;

    public InventoryFabricator(TileFabricator fabricator) {
        super(fabricator, 21, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        RecipeManager recipeManager = ((TileFabricator)this.tile).m_58904_().m_7465_();
        if (slotIndex == 0) {
            return RecipeUtils.getFabricatorMeltingRecipe(recipeManager, stack) != null;
        }
        if (slotIndex == 1) {
            return RecipeUtils.isFabricatorPlan(recipeManager, stack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 3, 18)) {
            if (RecipeUtils.isFabricatorPlan(recipeManager, stack)) {
                return false;
            }
            if (RecipeUtils.getFabricatorMeltingRecipe(recipeManager, stack) != null) {
                return false;
            }
        }
        return SlotUtil.isSlotInRange(slotIndex, 3, 18);
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack stack, Direction side) {
        return slotIndex == 2;
    }
}

