/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.RecipeUtils;
import forestry.factory.tiles.TileSqueezer;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class InventorySqueezer
extends InventoryAdapterTile<TileSqueezer> {
    public static final short SLOT_RESOURCE_1 = 0;
    public static final short SLOTS_RESOURCE_COUNT = 9;
    public static final short SLOT_REMNANT = 9;
    public static final short SLOT_REMNANT_COUNT = 1;
    public static final short SLOT_CAN_INPUT = 10;
    public static final short SLOT_CAN_OUTPUT = 11;

    public InventorySqueezer(TileSqueezer squeezer) {
        super(squeezer, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (slotIndex == 10) {
            return FluidHelper.isFillableEmptyContainer(stack);
        }
        if (slotIndex >= 0 && slotIndex < 9) {
            if (FluidHelper.isFillableEmptyContainer(stack)) {
                return false;
            }
            RecipeManager recipeManager = ((TileSqueezer)this.tile).m_58904_().m_7465_();
            return RecipeUtils.isSqueezerIngredient(recipeManager, stack) || RecipeUtils.getSqueezerContainerRecipe(recipeManager, stack) != null;
        }
        return false;
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack itemstack, Direction side) {
        return slotIndex == 9 || slotIndex == 11;
    }

    public boolean hasResources() {
        return !InventoryUtil.isEmpty((Container)this, 0, 9);
    }

    public List<ItemStack> getResources() {
        return InventoryUtil.getStacks((Container)this, 0, 9);
    }

    public boolean removeResources(List<Ingredient> stacks) {
        InventoryMapper inventory = new InventoryMapper((Container)this, 0, 9);
        return InventoryUtil.consumeIngredients(inventory, stacks, null, false, false, true);
    }

    public boolean addRemnant(ItemStack remnant, boolean doAdd) {
        return InventoryUtil.tryAddStack((Container)this, remnant, 9, 1, true, doAdd);
    }

    public void fillContainers(FluidStack fluidStack, TankManager tankManager) {
        if (this.m_8020_(10).m_41619_()) {
            return;
        }
        FluidHelper.fillContainers(tankManager, (Container)this, 10, 11, fluidStack.getFluid(), true);
    }
}

