/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class RecipeSerializers {
    static <E> void write(FriendlyByteBuf buffer, List<E> list, BiConsumer<FriendlyByteBuf, E> consumer) {
        buffer.m_130130_(list.size());
        for (E e : list) {
            consumer.accept(buffer, e);
        }
    }

    static <E> List<E> read(FriendlyByteBuf buffer, Function<FriendlyByteBuf, E> reader) {
        int size = buffer.m_130242_();
        ArrayList<E> list = new ArrayList<E>(size);
        for (int i = 0; i < size; ++i) {
            list.add(reader.apply(buffer));
        }
        return list;
    }

    public static FluidStack deserializeFluid(JsonObject object) {
        return FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NbtOps.f_128958_, (Object)object)));
    }

    public static JsonObject serializeFluid(FluidStack fluid) {
        return (JsonObject)Dynamic.convert((DynamicOps)NbtOps.f_128958_, (DynamicOps)JsonOps.INSTANCE, (Object)fluid.writeToNBT(new CompoundTag()));
    }

    public static ItemStack item(JsonObject object) {
        return ItemStack.m_41712_((CompoundTag)((CompoundTag)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NbtOps.f_128958_, (Object)object)));
    }

    public static JsonObject item(ItemStack stack) {
        return (JsonObject)Dynamic.convert((DynamicOps)NbtOps.f_128958_, (DynamicOps)JsonOps.INSTANCE, (Object)stack.serializeNBT());
    }

    public static Ingredient deserialize(JsonElement resource) {
        if (resource.isJsonArray() && resource.getAsJsonArray().size() == 0) {
            return Ingredient.f_43901_;
        }
        return Ingredient.m_43917_((JsonElement)resource);
    }
}

