/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.IForestryApi;
import forestry.api.circuits.ForestryCircuitSocketTypes;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.circuits.ISocketable;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.RecipeUtils;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerCentrifuge;
import forestry.factory.inventory.InventoryCentrifuge;
import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCentrifuge
extends TilePowered
implements ISocketable,
WorldlyContainer,
IItemStackDisplay {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 3200;
    private static final int ENERGY_PER_RECIPE_TIME = 160;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final ResultContainer craftPreviewInventory;
    @Nullable
    private ICentrifugeRecipe currentRecipe;
    private final ArrayDeque<ItemStack> pendingProducts = new ArrayDeque();

    public TileCentrifuge(BlockPos pos, BlockState state) {
        super(FactoryTiles.CENTRIFUGE.tileType(), pos, state, 800, 40000);
        this.setInternalInventory(new InventoryCentrifuge(this));
        this.craftPreviewInventory = new ResultContainer();
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.sockets.write(compound);
        ListTag nbttaglist = new ListTag();
        ItemStack[] offspring = this.pendingProducts.toArray(new ItemStack[0]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            CompoundTag products = new CompoundTag();
            products.m_128344_("Slot", (byte)i);
            offspring[i].m_41739_(products);
            nbttaglist.add((Object)products);
        }
        compound.m_128365_("PendingProducts", (Tag)nbttaglist);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        ICircuitBoard chipset;
        super.m_142466_(compound);
        ListTag nbttaglist = compound.m_128437_("PendingProducts", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag CompoundNBT1 = nbttaglist.m_128728_(i);
            this.pendingProducts.add(ItemStack.m_41712_((CompoundTag)CompoundNBT1));
        }
        this.sockets.read(compound);
        ItemStack chip = this.sockets.m_8020_(0);
        if (!chip.m_41619_() && (chipset = IForestryApi.INSTANCE.getCircuitManager().getCircuitBoard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        super.writeGuiData(data);
        this.sockets.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(FriendlyByteBuf data) {
        super.readGuiData(data);
        this.sockets.readData(data);
    }

    @Override
    public boolean workCycle() {
        if (this.tryAddPending()) {
            return true;
        }
        if (!this.pendingProducts.isEmpty()) {
            this.craftPreviewInventory.m_6836_(0, ItemStack.f_41583_);
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        List<ItemStack> products = this.currentRecipe.getProducts(this.f_58857_.f_46441_);
        this.pendingProducts.addAll(products);
        ItemStack previewStack = this.getInternalInventory().m_8020_(0).m_41777_();
        previewStack.m_41764_(1);
        this.craftPreviewInventory.m_6836_(0, previewStack);
        this.getInternalInventory().m_7407_(0, 1);
        return true;
    }

    private void checkRecipe() {
        ItemStack resource = this.m_8020_(0);
        ICentrifugeRecipe matchingRecipe = RecipeUtils.getCentrifugeRecipe(this.m_58904_().m_7465_(), resource);
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.getProcessingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 160);
            }
        }
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProducts.peekFirst();
        boolean added = InventoryUtil.tryAddStack((Container)this, next, 1, 9, true);
        if (added) {
            this.pendingProducts.removeFirst();
            if (this.pendingProducts.isEmpty()) {
                this.craftPreviewInventory.m_6836_(0, ItemStack.f_41583_);
            }
        }
        this.getErrorLogic().setCondition(!added, ForestryError.NO_SPACE_INVENTORY);
        return added;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.m_8020_(0).m_41619_()) {
            return false;
        }
        return (float)inventory.m_8020_(0).m_41613_() / (float)inventory.m_8020_(0).m_41741_() > percentage;
    }

    @Override
    public boolean hasWork() {
        if (!this.pendingProducts.isEmpty()) {
            return true;
        }
        this.checkRecipe();
        boolean hasResource = !this.m_8020_(0).m_41619_();
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasResource, ForestryError.NO_RESOURCE);
        return hasResource;
    }

    @Override
    public int getSocketCount() {
        return this.sockets.m_6643_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.m_8020_(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (!stack.m_41619_() && !IForestryApi.INSTANCE.getCircuitManager().isCircuitBoard(stack)) {
            return;
        }
        if (!this.sockets.m_8020_(slot).m_41619_() && IForestryApi.INSTANCE.getCircuitManager().isCircuitBoard(this.sockets.m_8020_(slot)) && (chipset = IForestryApi.INSTANCE.getCircuitManager().getCircuitBoard(this.sockets.m_8020_(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.m_6836_(slot, stack);
        if (stack.m_41619_()) {
            return;
        }
        chipset = IForestryApi.INSTANCE.getCircuitManager().getCircuitBoard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public ResourceLocation getSocketType() {
        return ForestryCircuitSocketTypes.MACHINE;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerCentrifuge(windowId, player.m_150109_(), this);
    }

    public Container getCraftPreviewInventory() {
        return this.craftPreviewInventory;
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        this.craftPreviewInventory.m_6836_(0, itemStack);
    }
}

