/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.api.farming.Soil;
import forestry.core.utils.VecUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class FarmLogic
implements IFarmLogic {
    private final EntitySelectorFarm entitySelectorFarm;
    protected final IFarmType type;
    protected final boolean isManual;

    public FarmLogic(IFarmType type, boolean isManual) {
        this.type = type;
        this.isManual = isManual;
        this.entitySelectorFarm = new EntitySelectorFarm(type);
    }

    protected Collection<IFarmable> getFarmables() {
        return this.type.getFarmables();
    }

    protected Collection<Soil> getSoils() {
        return this.type.getSoils();
    }

    @Override
    public IFarmType getType() {
        return this.type;
    }

    @Override
    public boolean isManual() {
        return this.isManual;
    }

    @Override
    public Collection<ICrop> harvest(Level level, IFarmHousing housing, Direction direction, int extent, BlockPos pos) {
        ArrayDeque<ICrop> crops = new ArrayDeque<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.m_7494_(), direction, i);
            ICrop crop = this.getCrop(level, position);
            if (crop == null) continue;
            crops.addFirst(crop);
        }
        return crops;
    }

    @Nullable
    protected ICrop getCrop(Level world, BlockPos position) {
        if (!world.m_46805_(position) || world.m_46859_(position)) {
            return null;
        }
        BlockState blockState = world.m_8055_(position);
        for (IFarmable seed : this.getFarmables()) {
            ICrop crop = seed.getCropAt(world, position, blockState);
            if (crop == null) continue;
            return crop;
        }
        return null;
    }

    protected final boolean isWaterSourceBlock(Level world, BlockPos position) {
        if (!world.m_46805_(position)) {
            return false;
        }
        BlockState blockState = world.m_8055_(position);
        Block block = blockState.m_60734_();
        return block == Blocks.f_49990_;
    }

    protected final boolean isIceBlock(Level world, BlockPos position) {
        if (!world.m_46805_(position)) {
            return false;
        }
        BlockState blockState = world.m_8055_(position);
        Block block = blockState.m_60734_();
        return block == Blocks.f_50126_;
    }

    protected final BlockPos translateWithOffset(BlockPos pos, Direction farmDirection, int step) {
        return VecUtil.scale(farmDirection.m_122436_(), step).m_121955_((Vec3i)pos);
    }

    private static AABB getHarvestBox(Level world, IFarmHousing farmHousing, boolean toWorldHeight) {
        BlockPos coords = farmHousing.getCoords();
        Vec3i area = farmHousing.getArea();
        Vec3i offset = farmHousing.getOffset();
        BlockPos min = coords.m_121955_(offset);
        BlockPos max = min.m_121955_(area);
        int maxY = max.m_123342_();
        if (toWorldHeight) {
            maxY = world.m_151558_();
        }
        return new AABB((double)min.m_123341_(), (double)min.m_123342_(), (double)min.m_123343_(), (double)max.m_123341_(), (double)maxY, (double)max.m_123343_());
    }

    protected List<ItemStack> collectEntityItems(Level world, IFarmHousing farmHousing, boolean toWorldHeight) {
        AABB harvestBox = FarmLogic.getHarvestBox(world, farmHousing, toWorldHeight);
        List entityItems = world.m_6443_(ItemEntity.class, harvestBox, (Predicate)((Object)this.entitySelectorFarm));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemEntity entity : entityItems) {
            ItemStack contained = entity.m_32055_();
            stacks.add(contained.m_41777_());
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return stacks;
    }

    public String toString() {
        return this.type.getTranslationKey();
    }

    private static class EntitySelectorFarm
    implements com.google.common.base.Predicate<ItemEntity> {
        private static final String MAGNET_PREVENT_NBT = "PreventRemoteMovement";
        private final IFarmType properties;

        public EntitySelectorFarm(IFarmType properties) {
            this.properties = properties;
        }

        public boolean apply(@Nullable ItemEntity entity) {
            if (entity == null || !entity.m_6084_()) {
                return false;
            }
            if (entity.getPersistentData().m_128471_(MAGNET_PREVENT_NBT)) {
                return false;
            }
            ItemStack contained = entity.m_32055_();
            return this.properties.isAcceptedSeedling(contained) || this.properties.isAcceptedWindfall(contained);
        }
    }
}

