/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.core.HumidityType;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.api.core.TemperatureType;
import forestry.core.network.IStreamable;
import forestry.cultivation.IFarmHousingInternal;
import forestry.farming.gui.IFarmLedgerDelegate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class FarmHydrationManager
implements IFarmLedgerDelegate,
INbtWritable,
INbtReadable,
IStreamable {
    private static final int DELAY_HYDRATION = 100;
    private static final float RAINFALL_MODIFIER_MAX = 15.0f;
    private static final float RAINFALL_MODIFIER_MIN = 0.5f;
    private final IFarmHousingInternal housing;
    private int hydrationDelay = 0;
    private int ticksSinceRainfall = 0;

    public FarmHydrationManager(IFarmHousingInternal housing) {
        this.housing = housing;
    }

    public void updateServer() {
        BlockPos coordinates;
        Level world = this.housing.getWorldObj();
        if (world.m_46758_((coordinates = this.housing.getTopCoord()).m_7494_())) {
            if (this.hydrationDelay > 0) {
                --this.hydrationDelay;
            } else {
                this.ticksSinceRainfall = 0;
            }
        } else {
            this.hydrationDelay = 100;
            if (this.ticksSinceRainfall < Integer.MAX_VALUE) {
                ++this.ticksSinceRainfall;
            }
        }
    }

    @Override
    public float getHydrationModifier() {
        return this.getHydrationTempModifier() * this.getHydrationHumidModifier() * this.getHydrationRainfallModifier();
    }

    @Override
    public float getHydrationTempModifier() {
        return switch (this.temperature()) {
            case TemperatureType.NORMAL -> 1.0f;
            case TemperatureType.WARM -> 1.5f;
            case TemperatureType.HOT, TemperatureType.HELLISH -> 2.0f;
            default -> 0.8f;
        };
    }

    @Override
    public float getHydrationHumidModifier() {
        return switch (this.humidity()) {
            default -> throw new IncompatibleClassChangeError();
            case HumidityType.ARID -> 2.0f;
            case HumidityType.NORMAL -> 1.5f;
            case HumidityType.DAMP -> 1.0f;
        };
    }

    @Override
    public TemperatureType temperature() {
        return this.housing.temperature();
    }

    @Override
    public HumidityType humidity() {
        return this.housing.humidity();
    }

    @Override
    public float getHydrationRainfallModifier() {
        return Mth.m_14036_((float)((float)this.ticksSinceRainfall / 24000.0f), (float)0.5f, (float)15.0f);
    }

    @Override
    public double getDrought() {
        return (double)Math.round((double)this.ticksSinceRainfall / 24000.0 * 10.0) / 10.0;
    }

    @Override
    public CompoundTag write(CompoundTag compoundNBT) {
        compoundNBT.m_128405_("HydrationDelay", this.hydrationDelay);
        compoundNBT.m_128405_("TicksSinceRainfall", this.ticksSinceRainfall);
        return compoundNBT;
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        data.m_130130_(this.hydrationDelay);
        data.m_130130_(this.ticksSinceRainfall);
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        this.hydrationDelay = data.m_130242_();
        this.ticksSinceRainfall = data.m_130242_();
    }

    @Override
    public void read(CompoundTag nbt) {
        this.hydrationDelay = nbt.m_128451_("HydrationDelay");
        this.ticksSinceRainfall = nbt.m_128451_("TicksSinceRainfall");
    }
}

