/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.multiblock.IFarmComponent;
import forestry.energy.EnergyHelper;
import forestry.energy.ForestryEnergyStorage;
import forestry.farming.features.FarmingTiles;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileFarmGearbox
extends TileFarm
implements IFarmComponent.Active {
    private static final int WORK_CYCLES = 4;
    private static final int ENERGY_PER_OPERATION = 200;
    private final ForestryEnergyStorage energyStorage = new ForestryEnergyStorage(200, 10000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energyStorage);
    private int activationDelay = 0;
    private int previousDelays = 0;
    private int workCounter;

    public TileFarmGearbox(BlockPos pos, BlockState state) {
        super(FarmingTiles.GEARBOX.tileType(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.energyStorage.read(compoundNBT);
        this.activationDelay = compoundNBT.m_128451_("ActivationDelay");
        this.previousDelays = compoundNBT.m_128451_("PrevDelays");
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.energyStorage.write(compoundNBT);
        compoundNBT.m_128405_("ActivationDelay", this.activationDelay);
        compoundNBT.m_128405_("PrevDelays", this.previousDelays);
    }

    @Override
    public void updateServer(int tickCount) {
        if (this.energyStorage.getEnergyStored() <= 0) {
            return;
        }
        if (this.activationDelay > 0) {
            --this.activationDelay;
            return;
        }
        if (this.workCounter < 4 && EnergyHelper.consumeEnergyToDoWork(this.energyStorage, 4, 200)) {
            ++this.workCounter;
        }
        if (this.workCounter >= 4 && tickCount % 5 == 0) {
            IFarmControllerInternal farmController = ((MultiblockLogicFarm)this.getMultiblockLogic()).getController();
            if (farmController.doWork()) {
                this.workCounter = 0;
                this.previousDelays = 0;
            } else {
                this.activationDelay = Math.min(10 * this.previousDelays, 120);
                ++this.previousDelays;
            }
        }
    }

    @Override
    public void updateClient(int tickCount) {
    }

    public ForestryEnergyStorage getEnergyManager() {
        return this.energyStorage;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction facing) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCap.invalidate();
    }
}

