/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.EnumTradeStationState;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.ITradeStationInfo;
import forestry.core.gui.IGuiSelectable;
import forestry.core.utils.NetworkUtil;
import forestry.mail.carriers.trading.TradeStationRegistry;
import forestry.mail.features.MailMenuTypes;
import forestry.mail.gui.ILetterInfoReceiver;
import forestry.mail.network.packets.PacketLetterInfoResponseTrader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;

public class ContainerCatalogue
extends AbstractContainerMenu
implements IGuiSelectable,
ILetterInfoReceiver {
    private final Player player;
    private final List<ITradeStation> stations = new ArrayList<ITradeStation>();
    @Nullable
    private ITradeStationInfo currentTrade = null;
    private final DataSlot stationIndex = DataSlot.m_39401_();
    private final DataSlot stationCount = DataSlot.m_39401_();
    private boolean needsSync = true;
    private final DataSlot currentFilter = DataSlot.m_39401_();
    private static final String[] FILTER_NAMES = new String[]{"all", "online", "offline"};
    private static final List<Set<IPostalState>> FILTERS = new ArrayList<Set<IPostalState>>();

    public static ContainerCatalogue fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerCatalogue(windowId, inv);
    }

    public ContainerCatalogue(int windowId, Inventory inv) {
        super(MailMenuTypes.CATALOGUE.menuType(), windowId);
        this.player = inv.f_35978_;
        this.m_38895_(this.stationIndex);
        this.m_38895_(this.stationCount);
        this.m_38895_(this.currentFilter);
        this.stationIndex.m_6422_(0);
        this.stationCount.m_6422_(0);
        this.currentFilter.m_6422_(1);
        this.rebuildStationsList();
    }

    public int getPageCount() {
        return Math.max(this.stationCount.m_6501_(), 1);
    }

    public int getPageNumber() {
        return this.stationIndex.m_6501_() + 1;
    }

    public String getFilterIdent() {
        return FILTER_NAMES[this.currentFilter.m_6501_()];
    }

    private void rebuildStationsList() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        this.stations.clear();
        Map<IMailAddress, ITradeStation> tradeStations = TradeStationRegistry.getOrCreate((ServerLevel)this.player.m_9236_()).getActiveTradeStations();
        for (ITradeStation station : tradeStations.values()) {
            ITradeStationInfo info = station.getTradeInfo();
            if (!FILTERS.get(this.currentFilter.m_6501_()).contains(info.state())) continue;
            this.stations.add(station);
        }
        this.stationIndex.m_6422_(0);
        this.stationCount.m_6422_(this.stations.size());
        this.updateTradeInfo();
    }

    public void nextPage() {
        if (!this.stations.isEmpty()) {
            this.stationIndex.m_6422_((this.stationIndex.m_6501_() + 1) % this.stations.size());
            this.updateTradeInfo();
        }
    }

    public void previousPage() {
        if (!this.stations.isEmpty()) {
            this.stationIndex.m_6422_((this.stationIndex.m_6501_() - 1 + this.stations.size()) % this.stations.size());
            this.updateTradeInfo();
        }
    }

    public void cycleFilter() {
        this.currentFilter.m_6422_((this.currentFilter.m_6501_() + 1) % FILTERS.size());
        this.rebuildStationsList();
    }

    private void updateTradeInfo() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        if (!this.stations.isEmpty()) {
            ITradeStation station = this.stations.get(this.stationIndex.m_6501_());
            this.setTradeInfo(station.getTradeInfo());
        } else {
            this.setTradeInfo(null);
        }
        this.needsSync = true;
    }

    @Override
    public void handleLetterInfoUpdate(IPostalCarrier carrier, @Nullable IMailAddress address, @Nullable ITradeStationInfo tradeInfo) {
        this.setTradeInfo(tradeInfo);
    }

    @Nullable
    public ITradeStationInfo getTradeInfo() {
        return this.currentTrade;
    }

    private void setTradeInfo(@Nullable ITradeStationInfo info) {
        this.currentTrade = info;
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.needsSync) {
            NetworkUtil.sendToPlayer(new PacketLetterInfoResponseTrader(this.currentTrade), (ServerPlayer)this.player);
            this.needsSync = false;
        }
    }

    public boolean m_6875_(Player p_75145_1_) {
        return true;
    }

    @Override
    public void handleSelectionRequest(ServerPlayer player, int primary, int secondary) {
        switch (primary) {
            case 0: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
                break;
            }
            case 2: {
                this.cycleFilter();
            }
        }
        this.needsSync = true;
    }

    public ItemStack m_7648_(Player player, int slot) {
        return ItemStack.f_41583_;
    }

    static {
        EnumSet<EnumTradeStationState> all = EnumSet.allOf(EnumTradeStationState.class);
        EnumSet<EnumTradeStationState> online = EnumSet.of(EnumTradeStationState.OK);
        EnumSet<EnumTradeStationState> offline = EnumSet.copyOf(all);
        offline.removeAll(online);
        FILTERS.add(Collections.unmodifiableSet(all));
        FILTERS.add(Collections.unmodifiableSet(online));
        FILTERS.add(Collections.unmodifiableSet(offline));
    }
}

