/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import forestry.api.core.IErrorSource;
import forestry.api.mail.ILetter;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemWithGui;
import forestry.core.utils.SlotUtil;
import forestry.mail.Letter;
import forestry.mail.LetterProperties;
import forestry.mail.items.ItemStamp;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemInventoryLetter
extends ItemInventory
implements IErrorSource {
    private final ILetter letter;

    public ItemInventoryLetter(Player player, ItemStack itemstack) {
        super(player, 0, itemstack);
        CompoundTag tagCompound = itemstack.m_41783_();
        Preconditions.checkNotNull((Object)tagCompound);
        this.letter = new Letter(tagCompound);
    }

    public ILetter getLetter() {
        return this.letter;
    }

    public void onLetterClosed() {
        ItemStack parent = this.getParent();
        this.setParent(LetterProperties.closeLetter(parent, this.letter));
    }

    public void onLetterOpened() {
        ItemStack parent = this.getParent();
        this.setParent(LetterProperties.openLetter(parent));
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        ItemStack result = this.letter.m_7407_(index, count);
        CompoundTag tagCompound = this.getParent().m_41783_();
        Preconditions.checkNotNull((Object)tagCompound);
        this.letter.write(tagCompound);
        return result;
    }

    @Override
    public void m_6836_(int index, ItemStack itemstack) {
        this.letter.m_6836_(index, itemstack);
        CompoundTag tagCompound = this.getParent().m_41783_();
        Preconditions.checkNotNull((Object)tagCompound);
        this.letter.write(tagCompound);
    }

    @Override
    public ItemStack m_8020_(int i) {
        return this.letter.m_8020_(i);
    }

    @Override
    public int m_6643_() {
        return this.letter.m_6643_();
    }

    @Override
    public int m_6893_() {
        return this.letter.m_6893_();
    }

    @Override
    public boolean m_6542_(Player player) {
        return this.letter.m_6542_(player);
    }

    @Override
    public ItemStack m_8016_(int slot) {
        return this.letter.m_8016_(slot);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (this.letter.isProcessed()) {
            return false;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 18, 4)) {
            Item item = stack.m_41720_();
            return item instanceof ItemStamp;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 0, 18)) {
            return !(stack.m_41720_() instanceof ItemWithGui);
        }
        return false;
    }

    public ImmutableSet<IError> getErrors() {
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (!this.letter.hasRecipient()) {
            errorStates.add((Object)ForestryError.NO_RECIPIENT);
        }
        if (!this.letter.isProcessed() && !this.letter.isPostPaid()) {
            errorStates.add((Object)ForestryError.NOT_POST_PAID);
        }
        return errorStates.build();
    }
}

