/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.modules.features.IBlockFeature;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeature;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.RegistryObject;

public class FeatureBlock<B extends Block, I extends BlockItem>
extends ModFeature
implements IBlockFeature<B, I> {
    private final RegistryObject<B> blockObject;
    @Nullable
    private final RegistryObject<I> itemObject;

    public FeatureBlock(IFeatureRegistry features, ResourceLocation moduleId, String identifier, Supplier<B> constructorBlock, @Nullable Function<B, I> constructorItem) {
        super(moduleId, identifier);
        this.blockObject = features.getRegistry(Registries.f_256747_).register(identifier, constructorBlock);
        this.itemObject = constructorItem == null ? null : features.getRegistry(Registries.f_256913_).register(identifier, () -> (BlockItem)constructorItem.apply((Block)this.blockObject.get()));
    }

    public String getTranslationKey() {
        return this.blockObject.map(Block::m_7705_).orElseGet(() -> "block.forestry." + this.name.replace('/', '.'));
    }

    @Override
    public BlockState defaultState() {
        return this.block().m_49966_();
    }

    @Override
    public <V extends Comparable<V>> BlockState setValue(Property<V> property, V value) {
        return (BlockState)this.defaultState().m_61124_(property, value);
    }

    @Override
    public B block() {
        return (B)((Block)this.blockObject.get());
    }

    @Override
    public I item() {
        return (I)((BlockItem)Objects.requireNonNull(this.itemObject, () -> "Missing item for block: " + this.name).get());
    }

    @Override
    public ResourceLocation id() {
        return this.itemObject.getId();
    }

    @Override
    public ResourceKey<? extends Registry<?>> getRegistry() {
        return Registries.f_256747_;
    }
}

