/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui.widgets;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.IForestryApi;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SoundUtil;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.widgets.SelectionWidget;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class SpeciesWidget
extends Widget
implements ISelectableProvider<ISpecies<?>> {
    private static final IdentityHashMap<ISpecies<?>, ItemStack> ITEMS = SpeciesWidget.createEntries();
    private final ImmutableSet<ISpecies<?>> entries;
    private final Direction facing;
    private final int index;
    private final boolean active;
    private final GuiGeneticFilter gui;

    public SpeciesWidget(WidgetManager manager, int xPos, int yPos, Direction facing, int index, boolean active, GuiGeneticFilter gui) {
        super(manager, xPos, yPos);
        this.facing = facing;
        this.index = index;
        this.active = active;
        this.gui = gui;
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (ISpeciesType<?, ?> type : IForestryApi.INSTANCE.getGeneticManager().getSpeciesTypes()) {
            IBreedingTracker tracker = type.getBreedingTracker((LevelAccessor)manager.minecraft.f_91073_, manager.minecraft.f_91074_.m_36316_());
            for (ResourceLocation id : tracker.getDiscoveredSpecies()) {
                Object species = type.getSpeciesSafe(id);
                if (species == null) continue;
                entries.add(species);
            }
        }
        this.entries = entries.build();
    }

    @Override
    public void draw(GuiGraphics graphics, int startX, int startY) {
        int x = this.xPos + startX;
        int y = this.yPos + startY;
        IFilterLogic logic = this.gui.getLogic();
        ISpecies<?> allele = logic.getGenomeFilter(this.facing, this.index, this.active);
        if (allele != null) {
            GuiUtil.drawItemStack(graphics, this.manager.gui, ITEMS.getOrDefault(allele, ItemStack.f_41583_), x, y);
        }
        if (this.gui.selection.isSame(this)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SelectionWidget.TEXTURE);
            graphics.m_280218_(SelectionWidget.TEXTURE, x - 1, y - 1, 212, 0, 18, 18);
        }
    }

    @Override
    public ImmutableSet<ISpecies<?>> getEntries() {
        return this.entries;
    }

    @Override
    public void onSelect(@Nullable ISpecies<?> selectable) {
        IFilterLogic logic = this.gui.getLogic();
        if (logic.setGenomeFilter(this.facing, this.index, this.active, selectable)) {
            logic.sendToServer(this.facing, (short)this.index, this.active, selectable);
        }
        if (this.gui.selection.isSame(this)) {
            this.gui.onModuleClick(this);
        }
        SoundUtil.playButtonClick();
    }

    @Override
    public void draw(GuiForestry<?> gui, ISpecies<?> selectable, GuiGraphics graphics, int y, int x) {
        GuiUtil.drawItemStack(graphics, gui, ITEMS.getOrDefault(selectable, ItemStack.f_41583_), x, y);
    }

    @Override
    public Component getName(ISpecies<?> selectable) {
        return selectable.getDisplayName();
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFilterLogic logic = this.gui.getLogic();
        ISpecies<?> allele = logic.getGenomeFilter(this.facing, this.index, this.active);
        if (allele == null) {
            return null;
        }
        ToolTip tooltip = new ToolTip();
        tooltip.add(this.getName(allele));
        return tooltip;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        IIndividual individual;
        ItemStack stack = this.gui.getMinecraft().f_91074_.f_36095_.m_142621_();
        if (!stack.m_41619_() && (individual = IIndividualHandlerItem.getIndividual(stack)) != null) {
            this.onSelect(mouseButton == 0 ? individual.getSpecies() : individual.getInactiveSpecies());
            return;
        }
        if (mouseButton == 1) {
            this.onSelect(null);
        } else {
            SoundUtil.playButtonClick();
            this.gui.onModuleClick(this);
        }
    }

    private static IdentityHashMap<ISpecies<?>, ItemStack> createEntries() {
        IdentityHashMap entries = new IdentityHashMap();
        for (ISpeciesType<?, ?> type : IForestryApi.INSTANCE.getGeneticManager().getSpeciesTypes()) {
            GeneticsUtil.getIconStacks(entries, type.getDefaultStage(), type);
        }
        return entries;
    }
}

