/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import com.google.common.base.Preconditions;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.IBackpackInterface;
import forestry.storage.BackpackFilterNaturalist;
import forestry.storage.items.ItemBackpack;
import forestry.storage.items.ItemBackpackNaturalist;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackInterface
implements IBackpackInterface {
    @Override
    public Item createBackpack(IBackpackDefinition definition, EnumBackpackType type) {
        Preconditions.checkNotNull((Object)definition, (Object)"definition must not be null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type must not be null");
        Preconditions.checkArgument((type != EnumBackpackType.NATURALIST ? 1 : 0) != 0, (Object)"type must not be NATURALIST. Use createNaturalistBackpack instead.");
        return new ItemBackpack(definition, type);
    }

    @Override
    public Item createNaturalistBackpack(IBackpackDefinition definition, ResourceLocation speciesTypeId, CreativeModeTab tab) {
        Preconditions.checkNotNull((Object)definition, (Object)"definition must not be null");
        Preconditions.checkNotNull((Object)speciesTypeId, (Object)"rootUid must not be null");
        return new ItemBackpackNaturalist(speciesTypeId, definition, tab);
    }

    @Override
    public Predicate<ItemStack> createNaturalistBackpackFilter(ResourceLocation speciesRootUid) {
        return new BackpackFilterNaturalist(speciesRootUid);
    }
}

