/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.ForestryTags;
import forestry.api.client.IClientModuleHandler;
import forestry.api.genetics.ForestrySpeciesTypes;
import forestry.api.modules.ForestryModule;
import forestry.api.modules.ForestryModuleIds;
import forestry.api.storage.IBackpackInterface;
import forestry.core.config.ForestryConfig;
import forestry.modules.BlankForestryModule;
import forestry.storage.BackpackDefinition;
import forestry.storage.BackpackFilter;
import forestry.storage.BackpackInterface;
import forestry.storage.BackpackResupplyHandler;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.client.StorageClientHandler;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;

@ForestryModule
public class ModuleStorage
extends BlankForestryModule {
    public static final IBackpackInterface BACKPACK_INTERFACE = new BackpackInterface();
    public static final BackpackDefinition APIARIST = new BackpackDefinition(12882493, 0xFFFFFF, BACKPACK_INTERFACE.createNaturalistBackpackFilter(ForestrySpeciesTypes.BEE));
    public static final BackpackDefinition ARBORIST = new BackpackDefinition(6651450, 0xFFFFFF, BACKPACK_INTERFACE.createNaturalistBackpackFilter(ForestrySpeciesTypes.TREE));
    public static final BackpackDefinition LEPIDOPTERIST = new BackpackDefinition(10050353, 0xFFFFFF, BACKPACK_INTERFACE.createNaturalistBackpackFilter(ForestrySpeciesTypes.BUTTERFLY));
    public static final BackpackDefinition MINER = new BackpackDefinition(3545213, 0xFFFFFF, new BackpackFilter(ForestryTags.Items.MINER_ALLOW, ForestryTags.Items.MINER_REJECT));
    public static final BackpackDefinition DIGGER = new BackpackDefinition(3554501, 0xFFFFFF, new BackpackFilter(ForestryTags.Items.DIGGER_ALLOW, ForestryTags.Items.DIGGER_REJECT));
    public static final BackpackDefinition FORESTER = new BackpackDefinition(3437607, 0xFFFFFF, new BackpackFilter(ForestryTags.Items.FORESTER_ALLOW, ForestryTags.Items.FORESTER_REJECT));
    public static final BackpackDefinition HUNTER = new BackpackDefinition(4268565, 0xFFFFFF, new BackpackFilter(ForestryTags.Items.HUNTER_ALLOW, ForestryTags.Items.HUNTER_REJECT));
    public static final BackpackDefinition ADVENTURER = new BackpackDefinition(8370370, 0xFFFFFF, new BackpackFilter(ForestryTags.Items.ADVENTURER_ALLOW, ForestryTags.Items.ADVENTURER_REJECT));
    public static final BackpackDefinition BUILDER = new BackpackDefinition(0xDD3A3A, 0xFFFFFF, new BackpackFilter(ForestryTags.Items.BUILDER_ALLOW, ForestryTags.Items.BUILDER_REJECT));

    @Override
    public ResourceLocation getId() {
        return ForestryModuleIds.STORAGE;
    }

    @Override
    public void registerEvents(IEventBus modBus) {
        MinecraftForge.EVENT_BUS.addListener(ModuleStorage::onItemPickup);
        MinecraftForge.EVENT_BUS.addListener(ModuleStorage::onLevelTick);
    }

    private static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (((Boolean)ForestryConfig.SERVER.enableBackpackResupply.get()).booleanValue() && event.phase == TickEvent.Phase.END) {
            for (Player player : event.level.m_6907_()) {
                BackpackResupplyHandler.resupply(player);
            }
        }
    }

    private static void onItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (PickupHandlerStorage.onItemPickup(event.getEntity(), event.getItem())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @Override
    public void registerClientHandler(Consumer<IClientModuleHandler> registrar) {
        registrar.accept(new StorageClientHandler());
    }
}

