/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.gui;

import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.storage.features.BackpackMenuTypes;
import forestry.storage.inventory.ItemInventoryBackpack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ContainerBackpack
extends ContainerItemInventory<ItemInventoryBackpack> {
    private final Size size;

    public static ContainerBackpack fromNetwork(int windowID, Inventory inv, FriendlyByteBuf extraData) {
        Size size = (Size)extraData.m_130066_(Size.class);
        ItemStack parent = extraData.m_130267_();
        return new ContainerBackpack(windowID, inv.f_35978_, size, parent);
    }

    public ContainerBackpack(int windowID, Player player, Size size, ItemStack parent) {
        super(windowID, new ItemInventoryBackpack(player, size.getSize(), parent), player.m_150109_(), 8, 11 + size.startY + size.rows * 18, BackpackMenuTypes.BACKPACK.menuType());
        this.size = size;
        for (int j = 0; j < size.rows; ++j) {
            for (int k = 0; k < size.columns; ++k) {
                int slot = k + j * size.columns;
                this.m_38897_(new SlotFilteredInventory((ItemInventoryBackpack)this.inventory, slot, size.startX + k * 18, size.startY + j * 18));
            }
        }
    }

    public Size getSize() {
        return this.size;
    }

    public static enum Size {
        DEFAULT(3, 5, 44, 19),
        T2(5, 9, 8, 8);

        final int rows;
        final int columns;
        final int startX;
        final int startY;

        private Size(int rows, int columns, int startX, int startY) {
            this.rows = rows;
            this.columns = columns;
            this.startX = startX;
            this.startY = startY;
        }

        public int getSize() {
            return this.rows * this.columns;
        }
    }
}

