/*
 * Decompiled with CFR 0.152.
 */
package com.krookedlilly.autohidehotbar;

import com.krookedlilly.autohidehotbar.AutoHideHUDConfig;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="autohidehud", dist={Dist.CLIENT})
public class AutoHideHUD {
    public static final String MOD_ID = "autohidehud";
    private static final PlayerData lastPlayerData = new PlayerData();
    private static final PlayerData tempPlayerData = new PlayerData();
    private static int currentTick = 0;
    private static int lastUpdatedTick = 0;
    private static boolean hudState = true;
    private static boolean preventHide = false;
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected static int tickDuration = 100;

    public AutoHideHUD(IEventBus modBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)AutoHideHUDConfig.SPEC);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        ++currentTick;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null) {
            AutoHideHUD.tempPlayerData.health = player.getHealth();
            AutoHideHUD.tempPlayerData.maxHealth = player.getMaxHealth();
            AutoHideHUD.tempPlayerData.armor = player.getArmorValue();
            AutoHideHUD.tempPlayerData.foodLevel = player.getFoodData().getFoodLevel();
            AutoHideHUD.tempPlayerData.airSupply = player.getAirSupply();
            AutoHideHUD.tempPlayerData.isCreative = player.isCreative();
            AutoHideHUD.tempPlayerData.experienceLevel = player.experienceLevel;
            AutoHideHUD.tempPlayerData.experienceProgress = player.experienceProgress;
            AutoHideHUD.tempPlayerData.hotbarSlot = player.getInventory().getSelectedSlot();
            AutoHideHUD.tempPlayerData.vehicleHealth = 0.01f;
            AutoHideHUD.tempPlayerData.vehicleMaxHealth = 0.01f;
            AutoHideHUD.tempPlayerData.inMenu = minecraft.screen != null;
            Entity entity = player.getVehicle();
            if (entity instanceof LivingEntity) {
                LivingEntity vehicle = (LivingEntity)entity;
                AutoHideHUD.tempPlayerData.vehicleHealth = vehicle.getHealth();
                AutoHideHUD.tempPlayerData.vehicleMaxHealth = vehicle.getMaxHealth();
            }
            if (AutoHideHUD.tempPlayerData.inMenu != AutoHideHUD.lastPlayerData.inMenu && ((Boolean)AutoHideHUDConfig.revealOnShowMenu.get()).booleanValue()) {
                AutoHideHUD.lastPlayerData.inMenu = AutoHideHUD.tempPlayerData.inMenu;
                if (AutoHideHUD.tempPlayerData.inMenu && ((Boolean)AutoHideHUDConfig.returnToStateFromMenu.get()).booleanValue()) {
                    if (!hudState) {
                        preventHide = true;
                    } else {
                        preventHide = false;
                        lastUpdatedTick = currentTick;
                    }
                } else if (AutoHideHUD.tempPlayerData.inMenu) {
                    preventHide = false;
                    lastUpdatedTick = currentTick;
                } else {
                    preventHide = false;
                }
            }
            if (AutoHideHUD.tempPlayerData.health != AutoHideHUD.lastPlayerData.health && (float)((Integer)AutoHideHUDConfig.revealWhenPlayerHealthChangedBelow.get()).intValue() / 100.0f > AutoHideHUD.tempPlayerData.health / AutoHideHUD.tempPlayerData.maxHealth || AutoHideHUD.tempPlayerData.vehicleHealth != AutoHideHUD.lastPlayerData.vehicleHealth && (float)((Integer)AutoHideHUDConfig.revealWhenVehicleHealthChangedBelow.get()).intValue() / 100.0f > AutoHideHUD.tempPlayerData.vehicleHealth / AutoHideHUD.tempPlayerData.vehicleMaxHealth || AutoHideHUD.tempPlayerData.armor != AutoHideHUD.lastPlayerData.armor && (Boolean)AutoHideHUDConfig.revealOnPlayerArmorChange.get() != false || AutoHideHUD.tempPlayerData.foodLevel != AutoHideHUD.lastPlayerData.foodLevel && (float)((Integer)AutoHideHUDConfig.revealWhenPlayerFoodChangedBelow.get()).intValue() / 100.0f > (float)AutoHideHUD.tempPlayerData.foodLevel / (float)AutoHideHUD.tempPlayerData.maxFoodLevel || AutoHideHUD.tempPlayerData.airSupply != AutoHideHUD.lastPlayerData.airSupply && (float)((Integer)AutoHideHUDConfig.revealWhenPlayerAirChangedBelow.get()).intValue() / 100.0f > (float)AutoHideHUD.tempPlayerData.airSupply / (float)AutoHideHUD.tempPlayerData.maxAirSupply || AutoHideHUD.tempPlayerData.isCreative != AutoHideHUD.lastPlayerData.isCreative || AutoHideHUD.tempPlayerData.experienceLevel != AutoHideHUD.lastPlayerData.experienceLevel && (Boolean)AutoHideHUDConfig.revealOnPlayerExperienceLevelChange.get() != false || AutoHideHUD.tempPlayerData.experienceProgress != AutoHideHUD.lastPlayerData.experienceProgress && (Boolean)AutoHideHUDConfig.revealOnPlayerExperienceProgressChange.get() != false || AutoHideHUD.tempPlayerData.hotbarSlot != AutoHideHUD.lastPlayerData.hotbarSlot && ((Boolean)AutoHideHUDConfig.revealOnPlayerHotbarSlotChange.get()).booleanValue()) {
                lastUpdatedTick = currentTick;
                AutoHideHUD.lastPlayerData.health = AutoHideHUD.tempPlayerData.health;
                AutoHideHUD.lastPlayerData.maxHealth = AutoHideHUD.tempPlayerData.maxHealth;
                AutoHideHUD.lastPlayerData.armor = AutoHideHUD.tempPlayerData.armor;
                AutoHideHUD.lastPlayerData.foodLevel = AutoHideHUD.tempPlayerData.foodLevel;
                AutoHideHUD.lastPlayerData.airSupply = AutoHideHUD.tempPlayerData.airSupply;
                AutoHideHUD.lastPlayerData.isCreative = AutoHideHUD.tempPlayerData.isCreative;
                AutoHideHUD.lastPlayerData.experienceLevel = AutoHideHUD.tempPlayerData.experienceLevel;
                AutoHideHUD.lastPlayerData.experienceProgress = AutoHideHUD.tempPlayerData.experienceProgress;
                AutoHideHUD.lastPlayerData.hotbarSlot = AutoHideHUD.tempPlayerData.hotbarSlot;
                AutoHideHUD.lastPlayerData.vehicleHealth = AutoHideHUD.tempPlayerData.vehicleHealth;
            }
        }
    }

    @SubscribeEvent
    public void onRenderHUD(RenderGuiLayerEvent.Pre event) {
        if (!preventHide && currentTick - lastUpdatedTick > tickDuration) {
            hudState = false;
            if (this.shouldHideLayer(event.getName())) {
                event.setCanceled(true);
            }
        } else if (!preventHide) {
            hudState = true;
        }
    }

    private boolean shouldHideLayer(ResourceLocation layerName) {
        if (((Boolean)AutoHideHUDConfig.hideHotbar.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.HOTBAR)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideHealthBar.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.PLAYER_HEALTH)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideArmorLevel.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.ARMOR_LEVEL)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideFoodLevel.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.FOOD_LEVEL)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideVehicleHealth.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.VEHICLE_HEALTH)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideAirLevel.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.AIR_LEVEL)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideExperienceLevel.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.EXPERIENCE_LEVEL)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideContextualInfoBar.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.CONTEXTUAL_INFO_BAR)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideContextualInfoBar.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.CONTEXTUAL_INFO_BAR_BACKGROUND)) {
            return true;
        }
        return (Boolean)AutoHideHUDConfig.hideCrossHair.get() != false && layerName.equals((Object)VanillaGuiLayers.CROSSHAIR);
    }

    static class PlayerData {
        float health = 20.0f;
        float maxHealth = 20.0f;
        int armor = 0;
        int foodLevel = 20;
        int maxFoodLevel = 20;
        boolean isCreative = false;
        int experienceLevel = 0;
        float experienceProgress = 0.0f;
        int hotbarSlot = 0;
        int airSupply = 300;
        int maxAirSupply = 300;
        float vehicleHealth = 0.01f;
        float vehicleMaxHealth = 0.01f;
        boolean inMenu = false;

        PlayerData() {
        }
    }
}

