/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.block;

import com.theplumteam.blockentity.ClawMachineBlockEntity;
import com.theplumteam.client.ClientHelpers;
import com.theplumteam.registry.ModBlockEntities;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

public class ClawMachineBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public ClawMachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? new ClawMachineBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return level.f_46443_ ? ClawMachineBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CLAW_MACHINE_BLOCK.get()), ClawMachineBlockEntity::tick) : null;
        }
        return null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos lowerPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        BlockEntity blockEntity = level.m_7702_(lowerPos);
        if (blockEntity instanceof ClawMachineBlockEntity) {
            ClawMachineBlockEntity clawMachineBlockEntity = (ClawMachineBlockEntity)blockEntity;
            if (level.f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelpers.openClawMachineScreen(lowerPos, clawMachineBlockEntity));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            Direction playerFacing = context.m_8125_();
            Direction blockFacing = playerFacing.m_122424_();
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockFacing)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                ClawMachineBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
            } else {
                ClawMachineBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        DoubleBlockHalf half;
        BlockPos otherPos;
        BlockState otherState;
        if (!state.m_60713_(newState.m_60734_()) && (otherState = level.m_8055_(otherPos = (half = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_())).m_60713_((Block)this) && otherState.m_61143_(HALF) != half) {
            level.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(null, 2001, otherPos, Block.m_49956_((BlockState)otherState));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos lowerPos;
        BlockState lowerState;
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (half == DoubleBlockHalf.UPPER && (lowerState = level.m_8055_(lowerPos = pos.m_7495_())).m_60713_(state.m_60734_()) && lowerState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState airState = lowerState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)lowerState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(lowerPos, airState, 35);
            level.m_5898_(player, 2001, lowerPos, Block.m_49956_((BlockState)lowerState));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine particleEngine) {
                BlockState woolState = Blocks.f_50104_.m_49966_();
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        for (int k = 0; k < 4; ++k) {
                            double x = (double)pos.m_123341_() + ((double)i + 0.5) / 4.0;
                            double y = (double)pos.m_123342_() + ((double)j + 0.5) / 4.0;
                            double z = (double)pos.m_123343_() + ((double)k + 0.5) / 4.0;
                            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, woolState), x, y, z, (Math.random() - 0.5) * 0.8, (Math.random() - 0.5) * 0.8, (Math.random() - 0.5) * 0.8);
                        }
                    }
                }
                return true;
            }

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine particleEngine) {
                if (!(target instanceof BlockHitResult)) {
                    return false;
                }
                BlockHitResult blockHit = (BlockHitResult)target;
                BlockState woolState = Blocks.f_50104_.m_49966_();
                BlockPos pos = blockHit.m_82425_();
                Direction side = blockHit.m_82434_();
                for (int i = 0; i < 4; ++i) {
                    double x = (double)pos.m_123341_() + 0.5 + (double)side.m_122429_() * 0.5 + (Math.random() - 0.5) * 0.4;
                    double y = (double)pos.m_123342_() + 0.5 + (double)side.m_122430_() * 0.5 + (Math.random() - 0.5) * 0.4;
                    double z = (double)pos.m_123343_() + 0.5 + (double)side.m_122431_() * 0.5 + (Math.random() - 0.5) * 0.4;
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, woolState), x, y, z, (double)side.m_122429_() * 0.01, (double)side.m_122430_() * 0.01, (double)side.m_122431_() * 0.01);
                }
                return true;
            }
        });
    }
}

