/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.blockentity;

import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FigureBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(FigureBlockEntity.class);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private String figureId = "";
    private String collectionId = "";
    private int alternativeSkinIndex = 0;
    private String skinSnapshot = null;
    private String quickSkinId = null;
    private double figureOffsetX = -0.6;
    private double figureOffsetY = 0.01;
    private double figureOffsetZ = -0.55;
    private double figureScale = 1.0;

    public FigureBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FIGURE_BLOCK.get(), pos, blockState);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId != null ? collectionId : "";
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public String getFigureId() {
        return this.figureId;
    }

    public void setFigureId(String figureId) {
        this.figureId = figureId != null ? figureId : "";
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public FigureDefinition getFigureDefinition() {
        if (this.figureId.isEmpty() || this.collectionId.isEmpty()) {
            return null;
        }
        return CollectionRegistry.getFigure(this.collectionId, this.figureId).orElse(null);
    }

    public boolean hasFigure() {
        return !this.figureId.isEmpty() && !this.collectionId.isEmpty() && this.getFigureDefinition() != null;
    }

    public double getFigureOffsetX() {
        return this.figureOffsetX;
    }

    public double getFigureOffsetY() {
        return this.figureOffsetY;
    }

    public double getFigureOffsetZ() {
        return this.figureOffsetZ;
    }

    public double getFigureScale() {
        return this.figureScale;
    }

    public void setFigureOffset(double x, double y, double z) {
        this.figureOffsetX = x;
        this.figureOffsetY = y;
        this.figureOffsetZ = z;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setFigureScale(double scale) {
        this.figureScale = scale;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getAlternativeSkinIndex() {
        return this.alternativeSkinIndex;
    }

    public String getSkinSnapshot() {
        return this.skinSnapshot;
    }

    public void setSkinSnapshot(String skinSnapshot) {
        this.skinSnapshot = skinSnapshot;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public String getQuickSkinId() {
        return this.quickSkinId;
    }

    public void setQuickSkinId(String quickSkinId) {
        this.quickSkinId = quickSkinId;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void cycleAlternativeSkin() {
        FigureDefinition def = this.getFigureDefinition();
        if (def == null || !def.hasAlternatives()) {
            return;
        }
        int totalSkins = 1 + def.getAlternatives().size();
        this.alternativeSkinIndex = (this.alternativeSkinIndex + 1) % totalSkins;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("FigureId", this.figureId);
        tag.m_128359_("CollectionId", this.collectionId);
        tag.m_128405_("AlternativeSkinIndex", this.alternativeSkinIndex);
        if (this.skinSnapshot != null) {
            tag.m_128359_("SkinSnapshot", this.skinSnapshot);
        }
        if (this.quickSkinId != null) {
            tag.m_128359_("QuickSkinId", this.quickSkinId);
        }
        tag.m_128347_("FigureOffsetX", this.figureOffsetX);
        tag.m_128347_("FigureOffsetY", this.figureOffsetY);
        tag.m_128347_("FigureOffsetZ", this.figureOffsetZ);
        tag.m_128347_("FigureScale", this.figureScale);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("FigureId")) {
            this.figureId = tag.m_128461_("FigureId");
        }
        if (tag.m_128441_("CollectionId")) {
            this.collectionId = tag.m_128461_("CollectionId");
        }
        if (tag.m_128441_("AlternativeSkinIndex")) {
            this.alternativeSkinIndex = tag.m_128451_("AlternativeSkinIndex");
        }
        this.skinSnapshot = tag.m_128425_("SkinSnapshot", 8) ? tag.m_128461_("SkinSnapshot") : null;
        String string = this.quickSkinId = tag.m_128425_("QuickSkinId", 8) ? tag.m_128461_("QuickSkinId") : null;
        if (tag.m_128441_("FigureOffsetX")) {
            this.figureOffsetX = tag.m_128459_("FigureOffsetX");
        }
        if (tag.m_128441_("FigureOffsetY")) {
            this.figureOffsetY = tag.m_128459_("FigureOffsetY");
        }
        if (tag.m_128441_("FigureOffsetZ")) {
            this.figureOffsetZ = tag.m_128459_("FigureOffsetZ");
        }
        if (tag.m_128441_("FigureScale")) {
            this.figureScale = tag.m_128459_("FigureScale");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        stack.m_41700_("BlockEntityTag", (Tag)tag);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (level.f_46443_ && blockEntity instanceof FigureBlockEntity) {
            FigureBlockEntity figureBlockEntity = (FigureBlockEntity)blockEntity;
        }
    }
}

