/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.theplumteam.client.config.ClientConfig;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.client.gui.SettingsScreen;
import com.theplumteam.client.gui.StarPatternCache;
import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.gui.widget.CollectionEntry;
import com.theplumteam.client.gui.widget.CollectionListWidget;
import com.theplumteam.client.gui.widget.FigureListWidget;
import com.theplumteam.client.gui.widget.LinkButton;
import com.theplumteam.client.renderer.FigureWidgetRenderer;
import com.theplumteam.client.token.ClientTokenManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.forge.BlockPopsModForge;
import com.theplumteam.network.ClawMachineCollectionPacket;
import com.theplumteam.network.DropBoxPacket;
import com.theplumteam.network.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionSelectionScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionSelectionScreen.class);
    private final BlockPos blockPos;
    private String selectedCollectionId;
    private final List<FigureCollection> collections;
    @Nullable
    private CollectionListWidget collectionListWidget;
    @Nullable
    private FigureListWidget figureListWidget;
    private Button useRegularButton;
    private Button useSpecialButton;
    private Button doneButton;
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private static final int MIN_PANEL_WIDTH = 500;
    private static final int MAX_PANEL_WIDTH = 1200;
    private static final int MIN_PANEL_HEIGHT = 400;
    private float currentColorR;
    private float currentColorG;
    private float currentColorB;
    private float targetColorR;
    private float targetColorG;
    private float targetColorB;
    private float colorTransitionProgress = 1.0f;
    private static final float COLOR_TRANSITION_SPEED = 0.05f;
    private static final float COLOR_SNAP_THRESHOLD = 0.95f;
    private boolean guiScaleForced = false;
    private boolean isClosing = false;
    private static final ResourceLocation DISCORD_ICON = new ResourceLocation("blockpops", "textures/gui/discord_icon.png");
    private static final ResourceLocation CURSEFORGE_ICON = new ResourceLocation("blockpops", "textures/gui/curseforge_icon.png");
    private static final ResourceLocation MODRINTH_ICON = new ResourceLocation("blockpops", "textures/gui/modrinth_icon.png");
    private static final ResourceLocation SETTINGS_ICON = new ResourceLocation("blockpops", "textures/gui/settings_icon.png");
    private static final String DISCORD_URL = "https://discord.gg/yGxdvA7qej";
    private static final String CURSEFORGE_URL = "https://www.curseforge.com/minecraft/mc-mods/blockpops";
    private static final String MODRINTH_URL = "https://modrinth.com/mod/blockpops";

    public CollectionSelectionScreen(BlockPos blockPos, String currentCollectionId) {
        super((Component)Component.m_237113_((String)"Claw Machine Configuration"));
        this.blockPos = blockPos;
        this.selectedCollectionId = currentCollectionId;
        this.collections = CollectionRegistry.getAllCollections().stream().filter(c -> !"default".equals(c.getId())).collect(Collectors.toCollection(ArrayList::new));
        this.collections.sort((c1, c2) -> {
            boolean c1IsPlayers = "world_players".equals(c1.getId());
            boolean c2IsPlayers = "world_players".equals(c2.getId());
            if (c1IsPlayers && !c2IsPlayers) {
                return -1;
            }
            if (!c1IsPlayers && c2IsPlayers) {
                return 1;
            }
            return 0;
        });
        ClientConfig config = ClientConfig.getInstance();
        this.currentColorR = config.backgroundColorR;
        this.currentColorG = config.backgroundColorG;
        this.currentColorB = config.backgroundColorB;
        this.targetColorR = config.backgroundColorR;
        this.targetColorG = config.backgroundColorG;
        this.targetColorB = config.backgroundColorB;
        this.colorTransitionProgress = 1.0f;
        LOGGER.info("CollectionSelectionScreen opened at {} with current collection: {}", (Object)blockPos, (Object)currentCollectionId);
    }

    protected void m_7856_() {
        FigureWidgetRenderer.ensureInitialized();
        if (!this.guiScaleForced && !this.isClosing) {
            this.guiScaleForced = true;
            int optimalScale = GuiScaleManager.getOptimalMenuScale();
            if (GuiScaleManager.setMenuGuiScale(optimalScale)) {
                return;
            }
        }
        super.m_7856_();
        this.m_169413_();
        this.calculatePanelDimensions();
        int scaledPadding = 10;
        int scaledSpacing = 6;
        int scaledComponentHeight = 20;
        int leftPanelWidth = (int)((float)this.panelWidth * 0.45f);
        int rightPanelWidth = (int)((float)this.panelWidth * 0.5f);
        int componentX = this.panelX + scaledPadding;
        int yPos = this.panelY + scaledPadding + scaledComponentHeight + scaledPadding;
        int topSectionHeight = scaledPadding + scaledComponentHeight + scaledPadding;
        Objects.requireNonNull(this.f_96547_);
        int tokenInfoHeight = 9 + scaledSpacing;
        int extraBottomSpacing = 5;
        int bottomSectionHeight = tokenInfoHeight + scaledComponentHeight * 2 + scaledSpacing + scaledPadding + extraBottomSpacing;
        int listHeight = this.panelHeight - topSectionHeight - bottomSectionHeight;
        int collectionHeaderHeight = 30;
        this.collectionListWidget = new CollectionListWidget(this, this.f_96541_, leftPanelWidth, listHeight, yPos, 55);
        this.collectionListWidget.m_93507_(componentX);
        this.collectionListWidget.m_93488_(false);
        this.collectionListWidget.m_93496_(false);
        this.m_7787_((GuiEventListener)this.collectionListWidget);
        this.loadCollections();
        int previewX = this.panelX + this.panelWidth - rightPanelWidth - scaledPadding;
        int headerHeight = 50;
        int figureListY = yPos;
        int figureListHeight = listHeight;
        this.figureListWidget = new FigureListWidget(this.f_96541_, rightPanelWidth, figureListHeight, figureListY, 90);
        this.figureListWidget.m_93507_(previewX);
        this.figureListWidget.m_93488_(false);
        this.figureListWidget.m_93496_(false);
        this.m_7787_((GuiEventListener)this.figureListWidget);
        if (this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty()) {
            CollectionRegistry.getCollection(this.selectedCollectionId).ifPresent(collection -> {
                if (this.figureListWidget != null) {
                    this.figureListWidget.setCollection((FigureCollection)collection);
                }
            });
        }
        int bottomY = this.panelY + this.panelHeight - scaledPadding;
        int fullWidthX = this.panelX + scaledPadding;
        int fullComponentWidth = this.panelWidth - scaledPadding * 2;
        this.doneButton = Button.m_253074_((Component)Component.m_237113_((String)"Done"), button -> this.m_7379_()).m_252987_(fullWidthX, bottomY -= scaledComponentHeight, fullComponentWidth, scaledComponentHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.doneButton);
        int buttonWidth = (fullComponentWidth - scaledSpacing) / 2;
        this.useRegularButton = Button.m_253074_((Component)Component.m_237113_((String)"Use Regular Token"), button -> {
            if (this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty()) {
                LOGGER.info("Using regular token for collection: {}", (Object)this.selectedCollectionId);
                DropBoxPacket packet = new DropBoxPacket(this.blockPos, this.selectedCollectionId, TokenType.REGULAR);
                BlockPopsModForge.NETWORK_CHANNEL.sendToServer((Object)packet);
                this.m_7379_();
            }
        }).m_252987_(fullWidthX, bottomY -= scaledComponentHeight + scaledSpacing, buttonWidth, scaledComponentHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.useRegularButton);
        this.useSpecialButton = Button.m_253074_((Component)Component.m_237113_((String)"Use Guaranteed Token"), button -> {
            if (this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty()) {
                LOGGER.info("Using guaranteed token for collection: {}", (Object)this.selectedCollectionId);
                DropBoxPacket packet = new DropBoxPacket(this.blockPos, this.selectedCollectionId, TokenType.GUARANTEED);
                BlockPopsModForge.NETWORK_CHANNEL.sendToServer((Object)packet);
                this.m_7379_();
            }
        }).m_252987_(fullWidthX + buttonWidth + scaledSpacing, bottomY, buttonWidth, scaledComponentHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.useSpecialButton);
        this.updateTokenButtonStates();
        int buttonSize = 24;
        int linkButtonY = this.panelY + scaledPadding;
        int settingsButtonX = this.panelX + this.panelWidth - buttonSize - scaledPadding;
        this.m_142416_((GuiEventListener)new LinkButton(settingsButtonX, linkButtonY, buttonSize, buttonSize, SETTINGS_ICON, null, (Component)Component.m_237113_((String)"Settings")){

            public void m_5691_() {
                CollectionSelectionScreen.this.openSettingsScreen();
            }
        });
        int discordButtonX = settingsButtonX - buttonSize - scaledSpacing;
        this.m_142416_((GuiEventListener)new LinkButton(discordButtonX, linkButtonY, buttonSize, buttonSize, DISCORD_ICON, DISCORD_URL, (Component)Component.m_237113_((String)"Join our Discord!")));
        int curseforgeButtonX = discordButtonX - buttonSize - scaledSpacing;
        this.m_142416_((GuiEventListener)new LinkButton(curseforgeButtonX, linkButtonY, buttonSize, buttonSize, CURSEFORGE_ICON, CURSEFORGE_URL, (Component)Component.m_237113_((String)"Visit our CurseForge page")));
        int modrinthButtonX = curseforgeButtonX - buttonSize - scaledSpacing;
        this.m_142416_((GuiEventListener)new LinkButton(modrinthButtonX, linkButtonY, buttonSize, buttonSize, MODRINTH_ICON, MODRINTH_URL, (Component)Component.m_237113_((String)"Visit our Modrinth page")));
    }

    private void calculatePanelDimensions() {
        int screenWidth = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualWidth() : this.f_96543_;
        int screenHeight = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualHeight() : this.f_96544_;
        int desiredWidth = (int)((float)screenWidth * 0.8f);
        int desiredHeight = (int)((float)screenHeight * 0.85f);
        this.panelWidth = Mth.m_14045_((int)desiredWidth, (int)500, (int)Math.min(1200, screenWidth - 60));
        this.panelHeight = Mth.m_14045_((int)desiredHeight, (int)400, (int)(screenHeight - 60));
        this.panelX = (screenWidth - this.panelWidth) / 2;
        this.panelY = (screenHeight - this.panelHeight) / 2;
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.isClosing) {
            this.restoreGuiScaleIfNeeded();
        }
    }

    public void m_7379_() {
        this.isClosing = true;
        this.restoreGuiScaleIfNeeded();
        super.m_7379_();
    }

    private void restoreGuiScaleIfNeeded() {
        if (this.guiScaleForced) {
            this.guiScaleForced = false;
            GuiScaleManager.restoreOriginalGuiScale();
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int adjustedMouseX = mouseX;
        int adjustedMouseY = mouseY;
        if (GuiScaleManager.isUsingInverseScale()) {
            adjustedMouseX = (int)GuiScaleManager.transformMouseX(mouseX);
            adjustedMouseY = (int)GuiScaleManager.transformMouseY(mouseY);
        }
        if (GuiScaleManager.isUsingInverseScale()) {
            graphics.m_280168_().m_85836_();
            float scale = GuiScaleManager.getRenderScaleFactor();
            graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        }
        this.renderBackgroundEffects(graphics, partialTick);
        this.renderPanel(graphics);
        super.m_88315_(graphics, adjustedMouseX, adjustedMouseY, partialTick);
        this.renderTokenInfo(graphics);
        this.renderCollectionListHeader(graphics);
        this.renderFigurePanelHeader(graphics);
        if (GuiScaleManager.isUsingInverseScale()) {
            graphics.m_280168_().m_85849_();
        }
        if (this.collectionListWidget != null) {
            this.collectionListWidget.m_88315_(graphics, adjustedMouseX, adjustedMouseY, partialTick);
        }
        if (this.figureListWidget != null) {
            this.figureListWidget.m_88315_(graphics, adjustedMouseX, adjustedMouseY, partialTick);
        }
    }

    private void renderCollectionListHeader(GuiGraphics graphics) {
        if (this.collectionListWidget == null) {
            return;
        }
        int scaledPadding = 10;
        int scaledComponentHeight = 20;
        int leftPanelWidth = (int)((float)this.panelWidth * 0.45f);
        int componentX = this.panelX + scaledPadding;
        int headerStartY = this.panelY + scaledPadding;
        int headerHeight = scaledComponentHeight + scaledPadding;
        int currentY = headerStartY + 4;
        graphics.m_280056_(this.f_96547_, "Collections", componentX + 8, currentY, 0xFFFFFF, false);
        Objects.requireNonNull(this.f_96547_);
        String collectionCount = this.collections.size() + " collections available";
        graphics.m_280056_(this.f_96547_, collectionCount, componentX + 8, currentY += 9 + 4, 0xAAAAAA, false);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280509_(componentX + 8, currentY += 9 + 4, componentX + leftPanelWidth - 8, currentY + 1, 0x40FFFFFF);
    }

    private void renderFigurePanelHeader(GuiGraphics graphics) {
        if (this.figureListWidget == null) {
            return;
        }
        FigureCollection collection = this.figureListWidget.getCurrentCollection();
        if (collection == null) {
            return;
        }
        int scaledPadding = 10;
        int scaledComponentHeight = 20;
        int rightPanelWidth = (int)((float)this.panelWidth * 0.5f);
        int previewX = this.panelX + this.panelWidth - rightPanelWidth - scaledPadding;
        int headerStartY = this.panelY + scaledPadding;
        int currentY = headerStartY + 4;
        graphics.m_280056_(this.f_96547_, collection.getName(), previewX + 8, currentY, 0xFFFFFF, false);
        Objects.requireNonNull(this.f_96547_);
        String figureCount = collection.getFigures().size() + " figures in this collection";
        graphics.m_280056_(this.f_96547_, figureCount, previewX + 8, currentY += 9 + 4, 0xAAAAAA, false);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280509_(previewX + 8, currentY += 9 + 4, previewX + rightPanelWidth - 8, currentY + 1, 0x40FFFFFF);
    }

    private void renderBackgroundEffects(GuiGraphics graphics, float partialTick) {
        float lerpedB;
        float lerpedG;
        float lerpedR;
        ClientConfig config = ClientConfig.getInstance();
        if (this.colorTransitionProgress < 1.0f) {
            this.colorTransitionProgress = Math.min(1.0f, this.colorTransitionProgress + 0.05f);
            if (this.colorTransitionProgress >= 0.95f) {
                this.colorTransitionProgress = 1.0f;
            }
            if (this.colorTransitionProgress >= 1.0f) {
                config.backgroundColorR = this.targetColorR;
                config.backgroundColorG = this.targetColorG;
                config.backgroundColorB = this.targetColorB;
            }
        }
        if (this.colorTransitionProgress >= 1.0f) {
            lerpedR = config.backgroundColorR;
            lerpedG = config.backgroundColorG;
            lerpedB = config.backgroundColorB;
        } else {
            lerpedR = Mth.m_14179_((float)this.colorTransitionProgress, (float)this.currentColorR, (float)this.targetColorR);
            lerpedG = Mth.m_14179_((float)this.colorTransitionProgress, (float)this.currentColorG, (float)this.targetColorG);
            lerpedB = Mth.m_14179_((float)this.colorTransitionProgress, (float)this.currentColorB, (float)this.targetColorB);
        }
        int bgRed = (int)(lerpedR * 255.0f);
        int bgGreen = (int)(lerpedG * 255.0f);
        int bgBlue = (int)(lerpedB * 255.0f);
        int bgColor = 0xFF000000 | bgRed << 16 | bgGreen << 8 | bgBlue;
        int bgWidth = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualWidth() : this.f_96543_;
        int bgHeight = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualHeight() : this.f_96544_;
        graphics.m_280509_(0, 0, bgWidth, bgHeight, bgColor);
        this.renderStarPattern(graphics, partialTick);
    }

    private void renderStarPattern(GuiGraphics graphics, float partialTick) {
        double pixelsPerSecond = 5.0;
        int tileSize = StarPatternCache.getTileSize();
        int tickCount = this.f_96541_ != null ? this.f_96541_.f_91065_.m_93079_() : 0;
        double smoothTime = (double)((float)tickCount + partialTick) / 20.0;
        double offsetX = smoothTime * pixelsPerSecond % (double)tileSize;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ClientConfig config = ClientConfig.getInstance();
        RenderSystem.setShaderColor((float)config.starColorR, (float)config.starColorG, (float)config.starColorB, (float)config.starOpacity);
        ResourceLocation cacheTexture = StarPatternCache.getTextureLocation();
        int cacheWidth = StarPatternCache.getTextureWidth();
        int cacheHeight = StarPatternCache.getTextureHeight();
        float u0 = (float)offsetX / (float)cacheWidth;
        float v0 = 0.0f;
        float u1 = u0 + (float)(GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualWidth() : this.f_96543_) / (float)cacheWidth;
        float v1 = (float)(GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualHeight() : this.f_96544_) / (float)cacheHeight;
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cacheTexture);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        int starHeight = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualHeight() : this.f_96544_;
        int starWidth = GuiScaleManager.isUsingInverseScale() ? GuiScaleManager.getVirtualWidth() : this.f_96543_;
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), 0.0f, (float)starHeight, 0.0f).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), (float)starWidth, (float)starHeight, 0.0f).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), (float)starWidth, 0.0f, 0.0f).m_7421_(u1, v0).m_5752_();
        bufferBuilder.m_252986_(pose.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f).m_7421_(u0, v0).m_5752_();
        tesselator.m_85914_();
        pose.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderPanel(GuiGraphics graphics) {
        ClientConfig config = ClientConfig.getInstance();
        int alpha = (int)(config.panelOpacity * 255.0f);
        int panelBgColor = alpha << 24 | 0;
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, panelBgColor);
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY + 1, this.panelX + 1, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
        graphics.m_280509_(this.panelX + this.panelWidth - 1, this.panelY + 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
    }

    private void loadCollections() {
        if (this.collectionListWidget == null) {
            return;
        }
        for (FigureCollection collection : this.collections) {
            this.collectionListWidget.addCollectionEntry(collection);
        }
        if (this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty()) {
            this.collectionListWidget.selectByCollectionId(this.selectedCollectionId);
        }
    }

    public void onCollectionSelected(CollectionEntry entry) {
        if (entry != null) {
            FigureCollection collection = entry.getCollection();
            this.selectedCollectionId = collection.getId();
            if (collection.hasBackgroundColor()) {
                int[] bgColor = collection.getBackgroundColor();
                ClientConfig config = ClientConfig.getInstance();
                this.currentColorR = config.backgroundColorR;
                this.currentColorG = config.backgroundColorG;
                this.currentColorB = config.backgroundColorB;
                this.targetColorR = (float)bgColor[0] / 255.0f;
                this.targetColorG = (float)bgColor[1] / 255.0f;
                this.targetColorB = (float)bgColor[2] / 255.0f;
                if (config.enableColorTransition) {
                    this.colorTransitionProgress = 0.0f;
                } else {
                    this.colorTransitionProgress = 1.0f;
                    config.backgroundColorR = this.targetColorR;
                    config.backgroundColorG = this.targetColorG;
                    config.backgroundColorB = this.targetColorB;
                }
            }
            if (this.figureListWidget != null) {
                this.figureListWidget.setCollection(collection);
            }
            this.sendUpdate();
            this.updateTokenButtonStates();
        }
    }

    private void updateTokenButtonStates() {
        boolean hasSelection;
        boolean bl = hasSelection = this.selectedCollectionId != null && !this.selectedCollectionId.isEmpty();
        if (this.useRegularButton != null) {
            boolean bl2 = this.useRegularButton.f_93623_ = hasSelection && ClientTokenManager.getRegularTokens() > 0;
        }
        if (this.useSpecialButton != null) {
            boolean collectionComplete = hasSelection && this.isCollectionComplete();
            this.useSpecialButton.f_93623_ = hasSelection && ClientTokenManager.hasSpecialToken() && !collectionComplete;
        }
    }

    private boolean isCollectionComplete() {
        if (this.selectedCollectionId == null || this.selectedCollectionId.isEmpty()) {
            return false;
        }
        return CollectionRegistry.getCollection(this.selectedCollectionId).map(collection -> {
            for (FigureDefinition figure : collection.getFigures()) {
                String figureId = collection.getId() + ":" + figure.getId();
                if (ClientDiscoveryManager.isDiscovered(figureId)) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    private void renderTokenInfo(GuiGraphics graphics) {
        int scaledPadding = 10;
        int scaledSpacing = 6;
        int scaledComponentHeight = 20;
        int bottomY = this.panelY + this.panelHeight - scaledPadding;
        bottomY -= scaledComponentHeight;
        Objects.requireNonNull(this.f_96547_);
        int tokenInfoY = (bottomY -= scaledComponentHeight + scaledSpacing) - 9 - scaledSpacing;
        int blueColor = 0x5599FF;
        int goldColor = 16766720;
        int fullWidthX = this.panelX + scaledPadding;
        int fullComponentWidth = this.panelWidth - scaledPadding * 2;
        int buttonWidth = (fullComponentWidth - scaledSpacing) / 2;
        int regularTokens = ClientTokenManager.getRegularTokens();
        String regularText = "Regular Tokens: " + regularTokens + "/3";
        if (regularTokens < 3) {
            String nextRegularTime = ClientTokenManager.formatNextRegularTime();
            regularText = regularText + " - Next: " + nextRegularTime;
        }
        int regularButtonCenterX = fullWidthX + buttonWidth / 2;
        int regularTextWidth = this.f_96547_.m_92895_(regularText);
        int regularTextX = regularButtonCenterX - regularTextWidth / 2;
        graphics.m_280056_(this.f_96547_, regularText, regularTextX, tokenInfoY, blueColor, false);
        boolean hasSpecial = ClientTokenManager.hasSpecialToken();
        String specialText = "Guaranteed Token: " + (hasSpecial ? "Available" : "Used");
        if (!hasSpecial) {
            String nextSpecialTime = ClientTokenManager.formatNextSpecialResetTime();
            specialText = specialText + " - Resets: " + nextSpecialTime;
        }
        int specialButtonCenterX = fullWidthX + buttonWidth + scaledSpacing + buttonWidth / 2;
        int specialTextWidth = this.f_96547_.m_92895_(specialText);
        int specialTextX = specialButtonCenterX - specialTextWidth / 2;
        graphics.m_280056_(this.f_96547_, specialText, specialTextX, tokenInfoY, goldColor, false);
    }

    public void m_86600_() {
        super.m_86600_();
        this.updateTokenButtonStates();
    }

    private void sendUpdate() {
        LOGGER.info("Sending collection update - Position: {}, Collection ID: {}", (Object)this.blockPos, (Object)this.selectedCollectionId);
        ClawMachineCollectionPacket packet = new ClawMachineCollectionPacket(this.blockPos, this.selectedCollectionId);
        BlockPopsModForge.NETWORK_CHANNEL.sendToServer((Object)packet);
    }

    private void openSettingsScreen() {
        this.f_96541_.m_91152_((Screen)new SettingsScreen(this));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
            float scale = GuiScaleManager.getMouseScaleFactor();
            dragX *= (double)scale;
            dragY *= (double)scale;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (GuiScaleManager.isUsingInverseScale()) {
            mouseX = GuiScaleManager.transformMouseX(mouseX);
            mouseY = GuiScaleManager.transformMouseY(mouseY);
        }
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

