/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.util;

import com.theplumteam.BlockPopsMod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraftforge.fml.ModList;

public class GuiScaleManager {
    private static Integer originalGuiScale = null;
    private static boolean scaleChanged = false;
    private static boolean usingInverseScale = false;
    private static final int TARGET_GUI_SCALE = 2;

    public static boolean setMenuGuiScale(int targetScale) {
        return GuiScaleManager.setMenuGuiScale(targetScale, false);
    }

    public static boolean setMenuGuiScale(int targetScale, boolean force) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            OptionInstance guiScaleOption = mc.f_91066_.m_231928_();
            int currentScale = (Integer)guiScaleOption.m_231551_();
            if (currentScale == targetScale) {
                usingInverseScale = false;
                return false;
            }
            if (!force && GuiScaleManager.areShadersActive() && GuiScaleManager.isDistantHorizonsInstalled()) {
                BlockPopsMod.LOGGER.info("Shaders + Distant Horizons detected, skipping GUI scale change");
                usingInverseScale = false;
                return false;
            }
            usingInverseScale = false;
            if (originalGuiScale == null) {
                originalGuiScale = currentScale;
            }
            guiScaleOption.m_231514_((Object)targetScale);
            scaleChanged = true;
            mc.m_5741_();
            return true;
        }
        catch (Exception e) {
            BlockPopsMod.LOGGER.error("Failed to set menu GUI scale", (Throwable)e);
            return false;
        }
    }

    public static void restoreOriginalGuiScale() {
        try {
            usingInverseScale = false;
            if (originalGuiScale == null || !scaleChanged) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            OptionInstance guiScaleOption = mc.f_91066_.m_231928_();
            int currentScale = (Integer)guiScaleOption.m_231551_();
            if (currentScale != originalGuiScale) {
                guiScaleOption.m_231514_((Object)originalGuiScale);
                mc.m_5741_();
            }
            originalGuiScale = null;
            scaleChanged = false;
        }
        catch (Exception e) {
            BlockPopsMod.LOGGER.error("Failed to restore original GUI scale", (Throwable)e);
        }
    }

    public static boolean isUsingInverseScale() {
        return usingInverseScale;
    }

    public static float getRenderScaleFactor() {
        Minecraft mc = Minecraft.m_91087_();
        double currentGuiScale = mc.m_91268_().m_85449_();
        if (currentGuiScale <= 0.0) {
            currentGuiScale = 1.0;
        }
        return (float)(2.0 / currentGuiScale);
    }

    public static int getVirtualWidth() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.m_91268_().m_85441_() / 2;
    }

    public static int getVirtualHeight() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.m_91268_().m_85442_() / 2;
    }

    public static double transformMouseX(double mouseX) {
        if (!usingInverseScale) {
            return mouseX;
        }
        Minecraft mc = Minecraft.m_91087_();
        double currentGuiScale = mc.m_91268_().m_85449_();
        if (currentGuiScale <= 0.0) {
            currentGuiScale = 1.0;
        }
        return mouseX * (currentGuiScale / 2.0);
    }

    public static double transformMouseY(double mouseY) {
        if (!usingInverseScale) {
            return mouseY;
        }
        Minecraft mc = Minecraft.m_91087_();
        double currentGuiScale = mc.m_91268_().m_85449_();
        if (currentGuiScale <= 0.0) {
            currentGuiScale = 1.0;
        }
        return mouseY * (currentGuiScale / 2.0);
    }

    public static float getMouseScaleFactor() {
        Minecraft mc = Minecraft.m_91087_();
        double currentGuiScale = mc.m_91268_().m_85449_();
        if (currentGuiScale <= 0.0) {
            currentGuiScale = 1.0;
        }
        return (float)(currentGuiScale / 2.0);
    }

    public static int getOptimalMenuScale() {
        return 2;
    }

    public static boolean areShadersActive() {
        try {
            if (GuiScaleManager.isOptifineShaderActive()) {
                return true;
            }
            if (GuiScaleManager.isIrisShaderActive()) {
                return true;
            }
        }
        catch (Exception e) {
            BlockPopsMod.LOGGER.debug("Error checking for shaders: {}", (Object)e.getMessage());
        }
        return false;
    }

    private static boolean isOptifineShaderActive() {
        try {
            Class<?> shadersClass = Class.forName("net.optifine.shaders.Shaders");
            Field shaderPackLoadedField = shadersClass.getDeclaredField("shaderPackLoaded");
            shaderPackLoadedField.setAccessible(true);
            return shaderPackLoadedField.getBoolean(null);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            try {
                Class<?> shadersClass = Class.forName("net.optifine.shaders.Shaders");
                Method isShaderPackLoaded = shadersClass.getMethod("isShaderPackLoaded", new Class[0]);
                return (Boolean)isShaderPackLoaded.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    private static boolean isIrisShaderActive() {
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Method getInstance = irisApiClass.getMethod("getInstance", new Class[0]);
            Object instance = getInstance.invoke(null, new Object[0]);
            Method isShaderPackInUse = irisApiClass.getMethod("isShaderPackInUse", new Class[0]);
            return (Boolean)isShaderPackInUse.invoke(instance, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isDistantHorizonsInstalled() {
        return ModList.get().isLoaded("distanthorizons");
    }
}

