/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.client.gui.FavoriteColorSelectionScreen;
import com.theplumteam.registry.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;

public class ColorSelectionButton
extends Button {
    private final PopBlockColor color;
    private final FavoriteColorSelectionScreen parentScreen;
    private final ItemStack boxItem;
    private boolean isSelected = false;
    private float rotationX = 30.0f;
    private float rotationY = 45.0f;
    private float rotationZ = 0.0f;
    private float scale = 1.0f;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetZ = 0.0f;

    public ColorSelectionButton(int x, int y, int size, PopBlockColor color, FavoriteColorSelectionScreen parentScreen) {
        super(x, y, size, size, (Component)Component.m_237119_(), button -> {
            if (parentScreen != null) {
                parentScreen.setSelectedColor(color);
            }
        }, f_252438_);
        this.color = color;
        this.parentScreen = parentScreen;
        this.boxItem = new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
        CompoundTag blockEntityTag = this.boxItem.m_41698_("BlockEntityTag");
        blockEntityTag.m_128379_("HideLogo", true);
        blockEntityTag.m_128359_("Color", color.name());
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public PopBlockColor getColor() {
        return this.color;
    }

    public void setTransforms(float rotX, float rotY, float rotZ, float scale, float offX, float offY, float offZ) {
        this.rotationX = rotX;
        this.rotationY = rotY;
        this.rotationZ = rotZ;
        this.scale = scale;
        this.offsetX = offX;
        this.offsetY = offY;
        this.offsetZ = offZ;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int borderColor;
        int backgroundColor;
        Minecraft minecraft = Minecraft.m_91087_();
        if (this.isSelected) {
            backgroundColor = -2130706433;
            borderColor = -1;
        } else if (this.m_198029_()) {
            backgroundColor = 0x60FFFFFF;
            borderColor = -2130706433;
        } else {
            backgroundColor = 0x40FFFFFF;
            borderColor = 0x60FFFFFF;
        }
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, backgroundColor);
        if (this.isSelected) {
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 2, borderColor);
            graphics.m_280509_(this.m_252754_(), this.m_252907_() + this.f_93619_ - 2, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
            graphics.m_280509_(this.m_252754_(), this.m_252907_() + 2, this.m_252754_() + 2, this.m_252907_() + this.f_93619_ - 2, borderColor);
            graphics.m_280509_(this.m_252754_() + this.f_93618_ - 2, this.m_252907_() + 2, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_ - 2, borderColor);
        } else {
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 1, borderColor);
            graphics.m_280509_(this.m_252754_(), this.m_252907_() + this.f_93619_ - 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
            graphics.m_280509_(this.m_252754_(), this.m_252907_() + 1, this.m_252754_() + 1, this.m_252907_() + this.f_93619_ - 1, borderColor);
            graphics.m_280509_(this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_ - 1, borderColor);
        }
        int itemSize = (int)((float)this.f_93618_ * 0.6f);
        int itemX = this.m_252754_() + (this.f_93618_ - itemSize) / 2;
        int itemY = this.m_252907_() + (this.f_93619_ - itemSize) / 2;
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)itemX + (float)itemSize / 2.0f, (float)itemY + (float)itemSize / 2.0f, 100.0f);
        pose.m_252880_(this.offsetX, this.offsetY, this.offsetZ);
        pose.m_252781_(new Quaternionf().rotationXYZ((float)Math.toRadians(this.rotationX), (float)Math.toRadians(this.rotationY), (float)Math.toRadians(this.rotationZ)));
        float finalScale = (float)itemSize / 16.0f * this.scale;
        pose.m_85841_(finalScale, finalScale, finalScale);
        pose.m_252880_(-8.0f, -8.0f, 0.0f);
        graphics.m_280480_(this.boxItem, 0, 0);
        pose.m_85849_();
    }
}

