/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.command;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.capability.IPlayerDiscovery;
import com.theplumteam.capability.PlayerDiscoveryProvider;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.figure.PlayerCollectionGenerator;
import com.theplumteam.forge.BlockPopsModForge;
import com.theplumteam.network.TokenType;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.registry.ModItems;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBoxCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetBoxCommand.class);
    private static final SuggestionProvider<CommandSourceStack> COLLECTION_SUGGESTIONS = (context, builder) -> {
        Set<String> collectionIds = CollectionRegistry.getCollectionIds();
        return SharedSuggestionProvider.m_82981_(collectionIds.stream().filter(id -> !id.equals("default")), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> TOKEN_TYPE_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"regular", "guaranteed"}, (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"blockpops").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"getbox").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"collection_id", (ArgumentType)StringArgumentType.string()).suggests(COLLECTION_SUGGESTIONS).executes(context -> GetBoxCommand.executeCommand((CommandContext<CommandSourceStack>)context, TokenType.REGULAR))).then(Commands.m_82129_((String)"token_type", (ArgumentType)StringArgumentType.string()).suggests(TOKEN_TYPE_SUGGESTIONS).executes(context -> {
            String tokenTypeStr = StringArgumentType.getString((CommandContext)context, (String)"token_type");
            TokenType tokenType = GetBoxCommand.parseTokenType(tokenTypeStr);
            if (tokenType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Invalid token type. Use 'regular' or 'guaranteed'"));
                return 0;
            }
            return GetBoxCommand.executeCommand((CommandContext<CommandSourceStack>)context, tokenType);
        })))));
    }

    private static TokenType parseTokenType(String tokenTypeStr) {
        if (tokenTypeStr.equalsIgnoreCase("regular")) {
            return TokenType.REGULAR;
        }
        if (tokenTypeStr.equalsIgnoreCase("guaranteed")) {
            return TokenType.GUARANTEED;
        }
        return null;
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context, TokenType tokenType) {
        String collectionId = StringArgumentType.getString(context, (String)"collection_id");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.m_81375_();
            if (!CollectionRegistry.getCollection(collectionId).isPresent()) {
                source.m_81352_((Component)Component.m_237113_((String)("Collection '" + collectionId + "' does not exist")));
                return 0;
            }
            player.getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(discovery -> GetBoxCommand.processBoxDrop(player, collectionId, tokenType, discovery));
            source.m_288197_(() -> Component.m_237113_((String)("Gave box from collection '" + collectionId + "' using " + tokenType.name().toLowerCase() + " token logic")), true);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player"));
            LOGGER.error("Error executing getbox command", (Throwable)e);
            return 0;
        }
    }

    @Nullable
    private static GameProfile getFreshGameProfile(ServerPlayer player, FigureDefinition figure) {
        if (figure.getPlayerUUID() == null) {
            return null;
        }
        try {
            GameProfile freshProfile = new GameProfile(figure.getPlayerUUID(), figure.getName());
            return player.m_20194_().m_129925_().fillProfileProperties(freshProfile, true);
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch fresh GameProfile for {}: {}", (Object)figure.getName(), (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private static String getQuickSkinIdFromServer(UUID playerId) {
        try {
            Class<?> repoClass = Class.forName("com.quickskin.mod.server.data.ServerPlayerAppearanceRepository");
            Method getInstanceMethod = repoClass.getMethod("getInstance", new Class[0]);
            Object repoInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getAppearanceMethod = repoClass.getMethod("getAppearance", UUID.class);
            Object appearance = getAppearanceMethod.invoke(repoInstance, playerId);
            if (appearance != null) {
                Class<?> appearanceClass = appearance.getClass();
                Method getSkinIdMethod = appearanceClass.getMethod("getSkinId", new Class[0]);
                return (String)getSkinIdMethod.invoke(appearance, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void processBoxDrop(ServerPlayer player, String collectionId, TokenType tokenType, IPlayerDiscovery discovery) {
        CollectionRegistry.getCollection(collectionId).ifPresent(collection -> {
            List<FigureDefinition> figures = collection.getFigures();
            if (!figures.isEmpty()) {
                FigureDefinition selectedFigure = GetBoxCommand.selectFigure(figures, tokenType, discovery, collectionId);
                ItemStack boxItem = null;
                if (collectionId.equals(PlayerCollectionGenerator.getCollectionId())) {
                    PopBlockColor color = selectedFigure.getFavoriteColor();
                    if (color == null) {
                        color = PopBlockColor.ORIGINAL;
                    }
                    boxItem = new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
                } else {
                    boxItem = ModItems.BOX_BLOCK_ITEMS.containsKey(collectionId) ? new ItemStack((ItemLike)ModItems.BOX_BLOCK_ITEMS.get(collectionId).get()) : new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)PopBlockColor.ORIGINAL).get());
                }
                if (boxItem != null) {
                    String oldSnapshot;
                    String uniqueFigureId = collectionId + ":" + selectedFigure.getId();
                    String skinSnapshot = null;
                    String quickSkinSnapshot = null;
                    if (selectedFigure.getType() == FigureType.PLAYER) {
                        String qsId;
                        GameProfile freshProfile = GetBoxCommand.getFreshGameProfile(player, selectedFigure);
                        if (freshProfile != null && !freshProfile.getProperties().get((Object)"textures").isEmpty()) {
                            skinSnapshot = ((Property)freshProfile.getProperties().get((Object)"textures").iterator().next()).getValue();
                            discovery.saveFigureSkin(uniqueFigureId, skinSnapshot);
                            LOGGER.info("Saved/updated fresh skin snapshot for {}.", (Object)uniqueFigureId);
                        }
                        if (selectedFigure.getPlayerUUID() != null && (qsId = GetBoxCommand.getQuickSkinIdFromServer(selectedFigure.getPlayerUUID())) != null && !qsId.isEmpty()) {
                            quickSkinSnapshot = qsId;
                            LOGGER.info("Captured Quick Skin ID for figure {}: {}", (Object)uniqueFigureId, (Object)qsId);
                        }
                    }
                    if (!discovery.isDiscovered(uniqueFigureId)) {
                        discovery.discover(uniqueFigureId);
                        UnlockFigurePacket unlockPacket = new UnlockFigurePacket(uniqueFigureId, selectedFigure.getName(), skinSnapshot);
                        BlockPopsModForge.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)unlockPacket);
                    }
                    CompoundTag blockEntityTag = new CompoundTag();
                    blockEntityTag.m_128359_("FigureId", selectedFigure.getId());
                    blockEntityTag.m_128359_("CollectionId", collectionId);
                    if (collectionId.equals(PlayerCollectionGenerator.getCollectionId())) {
                        PopBlockColor color = selectedFigure.getFavoriteColor();
                        if (color == null) {
                            color = PopBlockColor.ORIGINAL;
                        }
                        blockEntityTag.m_128359_("Color", color.name());
                    }
                    if (skinSnapshot != null && !skinSnapshot.isEmpty()) {
                        blockEntityTag.m_128359_("SkinSnapshot", skinSnapshot);
                    } else if (selectedFigure.getType() == FigureType.PLAYER && (oldSnapshot = discovery.getFigureSkin(uniqueFigureId)) != null && !oldSnapshot.isEmpty()) {
                        blockEntityTag.m_128359_("SkinSnapshot", oldSnapshot);
                    }
                    if (quickSkinSnapshot != null) {
                        blockEntityTag.m_128359_("QuickSkinId", quickSkinSnapshot);
                    }
                    boxItem.m_41784_().m_128365_("BlockEntityTag", (Tag)blockEntityTag);
                    ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), boxItem);
                    itemEntity.m_20334_(0.0, 0.2, 0.0);
                    player.m_9236_().m_7967_((Entity)itemEntity);
                }
            }
        });
    }

    private static FigureDefinition selectFigure(List<FigureDefinition> figures, TokenType tokenType, IPlayerDiscovery discovery, String collectionId) {
        Random random = new Random();
        if (tokenType == TokenType.GUARANTEED) {
            Set<String> discoveredSet = discovery.getDiscoveredSet();
            ArrayList<FigureDefinition> undiscoveredFigures = new ArrayList<FigureDefinition>();
            for (FigureDefinition figure : figures) {
                String figureId = collectionId + ":" + figure.getId();
                if (discoveredSet.contains(figureId)) continue;
                undiscoveredFigures.add(figure);
            }
            if (!undiscoveredFigures.isEmpty()) {
                return (FigureDefinition)undiscoveredFigures.get(random.nextInt(undiscoveredFigures.size()));
            }
            return figures.get(random.nextInt(figures.size()));
        }
        return figures.get(random.nextInt(figures.size()));
    }
}

