/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.capability.PlayerDiscoveryProvider;
import com.theplumteam.forge.BlockPopsModForge;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.server.ServerTickHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadTokensPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadTokensPacket.class);
    private final boolean reloadRegular;
    private final boolean reloadGuaranteed;

    public ReloadTokensPacket(boolean reloadRegular, boolean reloadGuaranteed) {
        this.reloadRegular = reloadRegular;
        this.reloadGuaranteed = reloadGuaranteed;
    }

    public static void encode(ReloadTokensPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.reloadRegular);
        buffer.writeBoolean(packet.reloadGuaranteed);
    }

    public static ReloadTokensPacket decode(FriendlyByteBuf buffer) {
        boolean reloadRegular = buffer.readBoolean();
        boolean reloadGuaranteed = buffer.readBoolean();
        return new ReloadTokensPacket(reloadRegular, reloadGuaranteed);
    }

    public static void handle(ReloadTokensPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                if (!player.m_20310_(2)) {
                    LOGGER.warn("Player {} tried to reload tokens without permission", (Object)player.m_7755_().getString());
                    return;
                }
                player.getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(discovery -> {
                    if (packet.reloadRegular) {
                        discovery.setRegularTokens(3);
                        discovery.setNextRegularTokenTime(0L);
                        LOGGER.info("Reloaded regular tokens for player {}", (Object)player.m_7755_().getString());
                    }
                    if (packet.reloadGuaranteed) {
                        discovery.setUsedTodaySpecialToken(false);
                        LOGGER.info("Reloaded guaranteed token for player {}", (Object)player.m_7755_().getString());
                    }
                    long gameTime = player.m_284548_().m_46467_();
                    long nextRegularTime = discovery.getNextRegularTokenTime();
                    long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
                    long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
                    SyncTokenDataPacket tokenPacket = new SyncTokenDataPacket(discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
                    BlockPopsModForge.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)tokenPacket);
                });
            } else {
                LOGGER.warn("Player is null in ReloadTokensPacket handler!");
            }
        });
        context.setPacketHandled(true);
    }
}

