/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.client.discovery.ClientDiscoveryManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDiscoveryDataPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDiscoveryDataPacket.class);
    private final Set<String> discoveredFigures;
    private final Map<String, String> figureSkins;

    public SyncDiscoveryDataPacket(Set<String> discoveredFigures, Map<String, String> figureSkins) {
        this.discoveredFigures = new HashSet<String>(discoveredFigures);
        this.figureSkins = new HashMap<String, String>(figureSkins);
    }

    public static void encode(SyncDiscoveryDataPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.discoveredFigures.size());
        for (String string : packet.discoveredFigures) {
            buffer.m_130070_(string);
        }
        buffer.writeInt(packet.figureSkins.size());
        for (Map.Entry entry : packet.figureSkins.entrySet()) {
            buffer.m_130070_((String)entry.getKey());
            buffer.m_130070_((String)entry.getValue());
        }
    }

    public static SyncDiscoveryDataPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashSet<String> discoveredFigures = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            discoveredFigures.add(buffer.m_130277_());
        }
        int skinsSize = buffer.readInt();
        HashMap<String, String> figureSkins = new HashMap<String, String>();
        for (int i = 0; i < skinsSize; ++i) {
            String figureId = buffer.m_130277_();
            String skinUrl = buffer.m_130277_();
            figureSkins.put(figureId, skinUrl);
        }
        return new SyncDiscoveryDataPacket(discoveredFigures, figureSkins);
    }

    public static void handle(SyncDiscoveryDataPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            LOGGER.info("Received discovery data sync: {} figures discovered, {} skins", (Object)packet.discoveredFigures.size(), (Object)packet.figureSkins.size());
            ClientDiscoveryManager.setData(packet.discoveredFigures, packet.figureSkins);
        });
        context.setPacketHandled(true);
    }

    public Set<String> getDiscoveredFigures() {
        return this.discoveredFigures;
    }
}

