/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDynamicCollectionsPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDynamicCollectionsPacket.class);
    private static final Gson GSON = new Gson();
    private final List<String> collectionsJson;

    public SyncDynamicCollectionsPacket(List<FigureCollection> collections) {
        this.collectionsJson = new ArrayList<String>();
        for (FigureCollection collection : collections) {
            JsonObject json = collection.toJson();
            this.collectionsJson.add(GSON.toJson((JsonElement)json));
        }
    }

    private SyncDynamicCollectionsPacket(ArrayList<String> collectionsJson) {
        this.collectionsJson = collectionsJson;
    }

    public static void encode(SyncDynamicCollectionsPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.collectionsJson.size());
        for (String json : packet.collectionsJson) {
            buffer.m_130072_(json, 0x100000);
        }
    }

    public static SyncDynamicCollectionsPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<String> collectionsJson = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            collectionsJson.add(buffer.m_130136_(0x100000));
        }
        return new SyncDynamicCollectionsPacket(collectionsJson);
    }

    public static void handle(SyncDynamicCollectionsPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            LOGGER.info("Received {} dynamic collections from server", (Object)packet.collectionsJson.size());
            for (String json : packet.collectionsJson) {
                try {
                    JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
                    FigureCollection collection = FigureCollection.fromJson(jsonObject);
                    CollectionRegistry.registerDynamicCollection(collection);
                    LOGGER.info("Registered dynamic collection: {} with {} figures", (Object)collection.getName(), (Object)collection.getFigures().size());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to deserialize dynamic collection", (Throwable)e);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public List<String> getCollectionsJson() {
        return this.collectionsJson;
    }
}

