/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.client.token.ClientTokenManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncTokenDataPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncTokenDataPacket.class);
    private final int regularTokens;
    private final long ticksUntilNextRegular;
    private final boolean hasSpecialToken;
    private final long millisUntilNextSpecialReset;

    public SyncTokenDataPacket(int regularTokens, long ticksUntilNextRegular, boolean hasSpecialToken, long millisUntilNextSpecialReset) {
        this.regularTokens = regularTokens;
        this.ticksUntilNextRegular = ticksUntilNextRegular;
        this.hasSpecialToken = hasSpecialToken;
        this.millisUntilNextSpecialReset = millisUntilNextSpecialReset;
    }

    public static void encode(SyncTokenDataPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.regularTokens);
        buffer.writeLong(packet.ticksUntilNextRegular);
        buffer.writeBoolean(packet.hasSpecialToken);
        buffer.writeLong(packet.millisUntilNextSpecialReset);
    }

    public static SyncTokenDataPacket decode(FriendlyByteBuf buffer) {
        int regularTokens = buffer.readInt();
        long ticksUntilNextRegular = buffer.readLong();
        boolean hasSpecialToken = buffer.readBoolean();
        long millisUntilNextSpecialReset = buffer.readLong();
        return new SyncTokenDataPacket(regularTokens, ticksUntilNextRegular, hasSpecialToken, millisUntilNextSpecialReset);
    }

    public static void handle(SyncTokenDataPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            LOGGER.debug("Received token data sync: {} regular tokens, special token: {}", (Object)packet.regularTokens, (Object)(packet.hasSpecialToken ? "available" : "used"));
            ClientTokenManager.update(packet);
        });
        context.setPacketHandled(true);
    }

    public int getRegularTokens() {
        return this.regularTokens;
    }

    public long getTicksUntilNextRegular() {
        return this.ticksUntilNextRegular;
    }

    public boolean hasSpecialToken() {
        return this.hasSpecialToken;
    }

    public long getMillisUntilNextSpecialReset() {
        return this.millisUntilNextSpecialReset;
    }
}

