/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.client.discovery.ClientDiscoveryManager;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockFigurePacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlockFigurePacket.class);
    private final String figureId;
    private final String figureName;
    @Nullable
    private final String skinSnapshot;

    public UnlockFigurePacket(String figureId, String figureName) {
        this(figureId, figureName, null);
    }

    public UnlockFigurePacket(String figureId, String figureName, @Nullable String skinSnapshot) {
        this.figureId = figureId;
        this.figureName = figureName;
        this.skinSnapshot = skinSnapshot;
    }

    public static void encode(UnlockFigurePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.figureId);
        buffer.m_130070_(packet.figureName);
        buffer.writeBoolean(packet.skinSnapshot != null);
        if (packet.skinSnapshot != null) {
            buffer.m_130070_(packet.skinSnapshot);
        }
    }

    public static UnlockFigurePacket decode(FriendlyByteBuf buffer) {
        String figureId = buffer.m_130277_();
        String figureName = buffer.m_130277_();
        String skinSnapshot = null;
        if (buffer.readBoolean()) {
            skinSnapshot = buffer.m_130277_();
        }
        return new UnlockFigurePacket(figureId, figureName, skinSnapshot);
    }

    public static void handle(UnlockFigurePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            LOGGER.info("Unlocked new figure: {} ({})", (Object)packet.figureName, (Object)packet.figureId);
            ClientDiscoveryManager.unlock(packet.figureId);
            if (packet.skinSnapshot != null) {
                ClientDiscoveryManager.saveFigureSkin(packet.figureId, packet.skinSnapshot);
                LOGGER.info("Saved skin snapshot for unlocked figure: {}", (Object)packet.figureId);
            }
        });
        context.setPacketHandled(true);
    }

    public String getFigureId() {
        return this.figureId;
    }

    public String getFigureName() {
        return this.figureName;
    }
}

