/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.server;

import com.theplumteam.BlockPopsMod;
import com.theplumteam.capability.IPlayerDiscovery;
import com.theplumteam.capability.PlayerDiscoveryProvider;
import com.theplumteam.forge.BlockPopsModForge;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.server.config.ServerConfig;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="blockpops", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerTickHandler {
    private static final long REGULAR_TOKEN_COOLDOWN_TICKS = 216000L;
    private static final int MAX_REGULAR_TOKENS = 3;
    private static long lastCheckTick = 0L;
    private static final int CHECK_INTERVAL = 20;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if ((long)event.getServer().m_129921_() - lastCheckTick < 20L) {
            return;
        }
        lastCheckTick = event.getServer().m_129921_();
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            player.getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(capability -> {
                boolean needsSync = false;
                needsSync |= ServerTickHandler.processRegularTokens(player, capability);
                if (needsSync |= ServerTickHandler.processSpecialTokenReset(capability)) {
                    ServerTickHandler.sendSyncPacket(player, capability);
                }
            });
        }
    }

    private static boolean processRegularTokens(ServerPlayer player, IPlayerDiscovery capability) {
        ServerLevel world = (ServerLevel)player.m_9236_();
        long gameTime = world.m_46467_();
        if (capability.getRegularTokens() < 3 && gameTime >= capability.getNextRegularTokenTime()) {
            capability.setRegularTokens(capability.getRegularTokens() + 1);
            capability.setNextRegularTokenTime(gameTime + 216000L);
            BlockPopsMod.LOGGER.debug("Granted regular token to {}. Total: {}/{}", new Object[]{player.m_7755_().getString(), capability.getRegularTokens(), 3});
            return true;
        }
        return false;
    }

    private static boolean processSpecialTokenReset(IPlayerDiscovery capability) {
        int resetHour;
        ZonedDateTime todayReset;
        long lastUpdateMillis = capability.getLastSpecialTokenResetTimestamp();
        if (lastUpdateMillis == 0L) {
            capability.setLastSpecialTokenResetTimestamp(System.currentTimeMillis());
            return false;
        }
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        ZonedDateTime mostRecentReset = now.isBefore(todayReset = now.withHour(resetHour = ServerConfig.getInstance().getGuaranteedTokenResetHour()).withMinute(0).withSecond(0).withNano(0)) ? todayReset.minusDays(1L) : todayReset;
        if (lastUpdateMillis < mostRecentReset.toInstant().toEpochMilli()) {
            capability.setLastSpecialTokenResetTimestamp(System.currentTimeMillis());
            if (capability.hasUsedTodaySpecialToken()) {
                capability.setUsedTodaySpecialToken(false);
                BlockPopsMod.LOGGER.debug("Daily token reset for player (Reset point was: {})", (Object)mostRecentReset);
            }
            return true;
        }
        return false;
    }

    private static void sendSyncPacket(ServerPlayer player, IPlayerDiscovery capability) {
        ServerLevel world = (ServerLevel)player.m_9236_();
        long gameTime = world.m_46467_();
        long nextRegularTime = capability.getNextRegularTokenTime();
        long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
        long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
        SyncTokenDataPacket packet = new SyncTokenDataPacket(capability.getRegularTokens(), ticksUntilNext, !capability.hasUsedTodaySpecialToken(), millisUntilReset);
        BlockPopsModForge.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static long calculateMillisUntilNextReset() {
        int resetHour = ServerConfig.getInstance().getGuaranteedTokenResetHour();
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        ZonedDateTime nextReset = now.withHour(resetHour).withMinute(0).withSecond(0).withNano(0);
        if (now.getHour() >= resetHour) {
            nextReset = nextReset.plusDays(1L);
        }
        return nextReset.toInstant().toEpochMilli() - now.toInstant().toEpochMilli();
    }
}

