/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.server.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.theplumteam.BlockPopsMod;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.loading.FMLPaths;

public class ServerConfig {
    private static ServerConfig instance;
    private static final Gson GSON;
    public int guaranteedTokenResetHour = 18;

    private ServerConfig() {
    }

    public static ServerConfig getInstance() {
        if (instance == null) {
            instance = ServerConfig.load();
        }
        return instance;
    }

    public int getGuaranteedTokenResetHour() {
        return this.guaranteedTokenResetHour;
    }

    public void setGuaranteedTokenResetHour(int hour) {
        this.guaranteedTokenResetHour = Math.max(0, Math.min(23, hour));
        this.save();
    }

    private static ServerConfig load() {
        Path configPath = ServerConfig.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                String json = Files.readString(configPath);
                ServerConfig config = (ServerConfig)GSON.fromJson(json, ServerConfig.class);
                BlockPopsMod.LOGGER.info("Loaded server configuration");
                return config;
            }
            catch (Exception e) {
                BlockPopsMod.LOGGER.error("Failed to load server configuration, using defaults", (Throwable)e);
            }
        }
        ServerConfig config = new ServerConfig();
        config.save();
        return config;
    }

    public void save() {
        Path configPath = ServerConfig.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
            BlockPopsMod.LOGGER.debug("Saved server configuration");
        }
        catch (IOException e) {
            BlockPopsMod.LOGGER.error("Failed to save server configuration", (Throwable)e);
        }
    }

    private static Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("blockpops-server.json");
    }

    public static void reload() {
        instance = ServerConfig.load();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

