/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.variant.api.BuildVariant;

public class CollisionBehavior {
    private static final Predicate<Block> transparent = Builder.builder().matching(AbstractGlassBlock.class, IronBarsBlock.class).matching(BarrierBlock.class).build();
    private static final Predicate<Block> openable = Builder.builder().matching(FenceGateBlock.class).matching(DoorBlock.class, TrapDoorBlock.class).build();
    private static Predicate<Block> custom = block -> false;

    public static boolean isIgnored(Block block) {
        if (ClientModConfig.INSTANCE.collision.ignoreAll && BuildVariant.getInstance().cheatsPermitted()) {
            return true;
        }
        if (ClientModConfig.INSTANCE.collision.ignoreTransparent && transparent.test(block)) {
            return true;
        }
        if (ClientModConfig.INSTANCE.collision.ignoreOpenable && openable.test(block)) {
            return true;
        }
        return ClientModConfig.INSTANCE.collision.ignoreCustom && custom.test(block);
    }

    private static String getBlockId(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block).toString();
    }

    private static class Builder {
        private final Collection<Predicate<Block>> predicates = new ArrayList<Predicate<Block>>();

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public final Builder matching(String ... ids) {
            return this.matching((Block block) -> Arrays.asList(ids).contains(CollisionBehavior.getBlockId(block)));
        }

        public final Builder matching(Pattern ... patterns) {
            return this.matching((Block block) -> {
                String id = CollisionBehavior.getBlockId(block);
                return Arrays.stream(patterns).map(pattern -> pattern.matcher(id)).anyMatch(Matcher::find);
            });
        }

        @SafeVarargs
        public final Builder matching(Class<? extends Block> ... classes) {
            return this.matching((Block block) -> Arrays.stream(classes).anyMatch(clazz -> clazz.isInstance(block)));
        }

        public final Builder matching(Predicate<Block> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public Predicate<Block> build() {
            return block -> this.predicates.stream().anyMatch(predicate -> predicate.test(block));
        }
    }
}

