/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.wheel;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class CommandWheelNode {
    private final String titleKey;
    private String iconPath;
    private CommandWheelNode parent;
    private final List<CommandWheelNode> children = new ArrayList<CommandWheelNode>();
    private Consumer<CommandWheelNode> action;
    private String state;
    private boolean isDynamic = false;

    public CommandWheelNode(String titleKey) {
        this.titleKey = titleKey;
    }

    public CommandWheelNode(String titleKey, Consumer<CommandWheelNode> action) {
        this.titleKey = titleKey;
        this.action = action;
    }

    public CommandWheelNode addChild(CommandWheelNode child) {
        child.setParent(this);
        this.children.add(child);
        return child;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setParent(CommandWheelNode parent) {
        this.parent = parent;
    }

    public CommandWheelNode getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public List<CommandWheelNode> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setAction(Consumer<CommandWheelNode> action) {
        this.action = action;
    }

    public Consumer<CommandWheelNode> getAction() {
        return this.action;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public void executeAction() {
        if (this.hasAction()) {
            this.action.accept(this);
        }
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }
}

