/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributeDefinition;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributeType;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributes;
import ydmsama.hundred_years_war.main.template.attribute.TemplateTagDefinition;
import ydmsama.hundred_years_war.main.template.attribute.TemplateTags;

public class TemplatePropertiesScreen
extends Screen {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final int WINDOW_WIDTH = 360;
    private static final int WINDOW_HEIGHT = 280;
    private static final String BUILDING_TAGS_KEY = "building_tags";
    private static final List<String> BUILT_IN_KEYS = List.of("enable_generation", "require_pregen", "generation_weight", "connection_layer_depth", "min_generation_height", "max_generation_height", "generate_on_surface", "generate_underwater", "generate_on_water_surface", "author", "min_burial_rate", "max_burial_rate");
    private static final Set<String> REQUIRED_CUSTOM_KEYS = Set.of("biome_blacklist", "use_whitelist", "building_tags");
    private final Screen parentScreen;
    private final String templateId;
    private final TemplateMetadata metadata;
    private final boolean isNewTemplate;
    private final PropertiesCallback callback;
    private boolean generationEnabled;
    private int generationWeight;
    private int connectionLayerDepth;
    private int minGenerationHeight;
    private int maxGenerationHeight;
    private boolean generateOnSurface;
    private boolean requirePregen;
    private boolean generateUnderwater;
    private boolean generateOnWaterSurface;
    private String templateAuthor = "";
    private double minBurialRate = 0.0;
    private double maxBurialRate = 1.0;
    private final Map<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>();
    private final List<BasePropertyModel> builtInProperties = new ArrayList<BasePropertyModel>();
    private final List<BasePropertyModel> allProperties = new ArrayList<BasePropertyModel>();
    private AttributeListWidget attributeList;
    private EditBox searchBox;
    private Button addButton;
    private Button saveButton;
    private Button cancelButton;
    private Component errorMessage;
    private String searchText = "";
    private String templateNameForDisplay = "";
    private int layoutLeft;
    private int layoutTop;
    private int layoutHeight;

    public TemplatePropertiesScreen(Screen parentScreen, String templateId) {
        super((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.title"));
        this.parentScreen = parentScreen;
        this.templateId = templateId;
        this.isNewTemplate = false;
        this.callback = null;
        this.metadata = TemplateManager.getInstance().getMetadata(templateId);
        if (this.metadata != null) {
            this.metadata.ensureCommonAttributes();
            this.initialiseState(this.metadata.isGenerationEnabled(), this.metadata.getGenerationWeight(), this.metadata.getConnectionLayerDepth(), this.metadata.getMinGenerationHeight(), this.metadata.getMaxGenerationHeight(), this.metadata.isGenerateOnSurface(), this.metadata.getCustomAttributes(), this.metadata.getName());
        } else {
            this.initialiseState(false, 1, 10, -64, 320, true, TemplateMetadata.createDefaultAttributes(), templateId);
        }
    }

    public TemplatePropertiesScreen(Screen parentScreen, String templateName, boolean currentEnableGeneration, int currentGenerationWeight, int currentConnectionLayerDepth, int currentMinGenerationHeight, int currentMaxGenerationHeight, boolean currentGenerateOnSurface, Map<String, JsonElement> currentAttributes, PropertiesCallback callback) {
        super((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.title"));
        this.parentScreen = parentScreen;
        this.templateId = null;
        this.metadata = null;
        this.isNewTemplate = true;
        this.callback = Objects.requireNonNull(callback);
        this.initialiseState(currentEnableGeneration, currentGenerationWeight, currentConnectionLayerDepth, currentMinGenerationHeight, currentMaxGenerationHeight, currentGenerateOnSurface, currentAttributes, templateName);
    }

    private void initialiseState(boolean enableGeneration, int generationWeight, int connectionLayerDepth, int minGenerationHeight, int maxGenerationHeight, boolean generateOnSurface, Map<String, JsonElement> attributes, String displayName) {
        this.generationEnabled = enableGeneration;
        this.generationWeight = generationWeight;
        this.connectionLayerDepth = connectionLayerDepth;
        this.minGenerationHeight = minGenerationHeight;
        this.maxGenerationHeight = maxGenerationHeight;
        this.generateOnSurface = generateOnSurface;
        this.templateNameForDisplay = displayName == null ? "" : displayName;
        this.customAttributes.clear();
        if (attributes != null) {
            attributes.forEach((key, value) -> this.customAttributes.put((String)key, TemplatePropertiesScreen.cloneJson(value)));
        }
        this.ensureDefaultAttributes();
        this.loadBuiltInAttributeFlags();
        this.initialiseBuiltInProperties();
        this.rebuildPropertyModels();
    }

    private void ensureDefaultAttributes() {
        TemplateMetadata.ensureDefaultAttributes(this.customAttributes);
    }

    private void loadBuiltInAttributeFlags() {
        this.requirePregen = this.getBooleanAttributeValue("require_pregen");
        this.generateUnderwater = this.getBooleanAttributeValue("generate_underwater");
        this.generateOnWaterSurface = this.getBooleanAttributeValue("generate_on_water_surface");
        this.templateAuthor = this.getStringAttributeValue("author");
        if ((this.templateAuthor == null || this.templateAuthor.isEmpty()) && this.metadata != null && this.metadata.getAuthor() != null) {
            this.templateAuthor = this.metadata.getAuthor();
            this.customAttributes.put("author", (JsonElement)new JsonPrimitive(this.templateAuthor));
        }
        this.minBurialRate = this.getDoubleAttributeValue("min_burial_rate", 0.0, 0.0, 1.0);
        this.maxBurialRate = this.getDoubleAttributeValue("max_burial_rate", 1.0, 0.0, 1.0);
    }

    private void syncBuiltInAttributeFlags() {
        this.customAttributes.put("require_pregen", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.requirePregen)));
        this.customAttributes.put("generate_underwater", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.generateUnderwater)));
        this.customAttributes.put("generate_on_water_surface", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.generateOnWaterSurface)));
        this.customAttributes.put("author", (JsonElement)new JsonPrimitive(this.templateAuthor == null ? "" : this.templateAuthor));
        this.customAttributes.put("min_burial_rate", (JsonElement)new JsonPrimitive((Number)Mth.m_14008_((double)this.minBurialRate, (double)0.0, (double)1.0)));
        this.customAttributes.put("max_burial_rate", (JsonElement)new JsonPrimitive((Number)Mth.m_14008_((double)this.maxBurialRate, (double)0.0, (double)1.0)));
    }

    private boolean getBooleanAttributeValue(String key) {
        JsonElement element = this.customAttributes.get(key);
        return element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean() && element.getAsBoolean();
    }

    private String getStringAttributeValue(String key) {
        JsonPrimitive primitive;
        JsonElement element = this.customAttributes.get(key);
        if (element == null || element.isJsonNull()) {
            return "";
        }
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString()) {
            return primitive.getAsString();
        }
        return element.toString();
    }

    private double getDoubleAttributeValue(String key, double defaultValue, double min, double max) {
        JsonElement element = this.customAttributes.get(key);
        double value = defaultValue;
        if (element != null && element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                value = primitive.getAsDouble();
            } else if (primitive.isString()) {
                try {
                    value = Double.parseDouble(primitive.getAsString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return Mth.m_14008_((double)value, (double)min, (double)max);
    }

    private void initialiseBuiltInProperties() {
        this.builtInProperties.clear();
        this.builtInProperties.add(new BuiltInPropertyModel("enable_generation", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.enable_generation"), () -> new JsonPrimitive(Boolean.valueOf(this.generationEnabled)), element -> {
            this.generationEnabled = TemplatePropertiesScreen.expectBoolean(element, "enable_generation");
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("require_pregen", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.require_pregen"), () -> new JsonPrimitive(Boolean.valueOf(this.requirePregen)), element -> {
            this.requirePregen = TemplatePropertiesScreen.expectBoolean(element, "require_pregen");
            this.customAttributes.put("require_pregen", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.requirePregen)));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("generation_weight", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.generation_weight"), () -> new JsonPrimitive((Number)this.generationWeight), element -> {
            this.generationWeight = TemplatePropertiesScreen.expectIntInRange(element, "generation_weight", 1, 9999999);
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("connection_layer_depth", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.connection_layer_depth"), () -> new JsonPrimitive((Number)this.connectionLayerDepth), element -> {
            this.connectionLayerDepth = TemplatePropertiesScreen.expectIntInRange(element, "connection_layer_depth", 1, 255);
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("min_generation_height", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.min_generation_height"), () -> new JsonPrimitive((Number)this.minGenerationHeight), element -> {
            this.minGenerationHeight = TemplatePropertiesScreen.expectIntInRange(element, "min_generation_height", -64, 320);
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("max_generation_height", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.max_generation_height"), () -> new JsonPrimitive((Number)this.maxGenerationHeight), element -> {
            this.maxGenerationHeight = TemplatePropertiesScreen.expectIntInRange(element, "max_generation_height", -64, 320);
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("generate_on_surface", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.generate_on_surface"), () -> new JsonPrimitive(Boolean.valueOf(this.generateOnSurface)), element -> {
            this.generateOnSurface = TemplatePropertiesScreen.expectBoolean(element, "generate_on_surface");
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("generate_underwater", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.generate_underwater"), () -> new JsonPrimitive(Boolean.valueOf(this.generateUnderwater)), element -> {
            this.generateUnderwater = TemplatePropertiesScreen.expectBoolean(element, "generate_underwater");
            this.customAttributes.put("generate_underwater", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.generateUnderwater)));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("generate_on_water_surface", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.generate_on_water_surface"), () -> new JsonPrimitive(Boolean.valueOf(this.generateOnWaterSurface)), element -> {
            this.generateOnWaterSurface = TemplatePropertiesScreen.expectBoolean(element, "generate_on_water_surface");
            this.customAttributes.put("generate_on_water_surface", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.generateOnWaterSurface)));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("author", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.author"), () -> new JsonPrimitive(this.templateAuthor == null ? "" : this.templateAuthor), element -> {
            this.templateAuthor = TemplatePropertiesScreen.expectString(element, "author");
            this.customAttributes.put("author", (JsonElement)new JsonPrimitive(this.templateAuthor));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("min_burial_rate", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.min_burial_rate"), () -> new JsonPrimitive((Number)this.minBurialRate), element -> {
            this.minBurialRate = TemplatePropertiesScreen.expectDoubleInRange(element, "min_burial_rate", 0.0, 1.0);
            this.customAttributes.put("min_burial_rate", (JsonElement)new JsonPrimitive((Number)this.minBurialRate));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("max_burial_rate", (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.property.max_burial_rate"), () -> new JsonPrimitive((Number)this.maxBurialRate), element -> {
            this.maxBurialRate = TemplatePropertiesScreen.expectDoubleInRange(element, "max_burial_rate", 0.0, 1.0);
            this.customAttributes.put("max_burial_rate", (JsonElement)new JsonPrimitive((Number)this.maxBurialRate));
        }));
    }

    private void rebuildPropertyModels() {
        this.allProperties.clear();
        this.allProperties.addAll(this.builtInProperties);
        for (String key : new LinkedHashSet<String>(this.customAttributes.keySet())) {
            if (this.isBuiltInKey(key)) continue;
            this.allProperties.add(new CustomPropertyModel(key));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.isNewTemplate && this.metadata == null) {
            this.m_7379_();
            return;
        }
        int availableHeight = Math.max(this.f_96544_ - 20, 200);
        this.layoutHeight = Math.min(280, availableHeight);
        this.layoutHeight = Math.min(this.layoutHeight, this.f_96544_ - 20);
        if (this.layoutHeight <= 0) {
            this.layoutHeight = Math.max(this.f_96544_ - 20, 200);
        }
        this.layoutTop = Math.max(10, (this.f_96544_ - this.layoutHeight) / 2);
        int left = this.layoutLeft = (this.f_96543_ - 360) / 2;
        int top = this.layoutTop;
        this.searchBox = new EditBox(this.f_96547_, left + 12, top + 34, 230, 18, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.search_hint"));
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.search_hint"));
        this.searchBox.m_94151_(text -> {
            this.searchText = text == null ? "" : text.toLowerCase(Locale.ROOT);
            this.refreshPropertyList();
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        this.addButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.add_attribute"), btn -> this.openAddAttribute()).m_252794_(left + 360 - 110, top + 33).m_253046_(98, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addButton);
        int listHeight = Math.max(80, this.layoutHeight - 98);
        int listTop = top + 60;
        int listBottom = listTop + listHeight;
        this.attributeList = new AttributeListWidget(this.f_96541_, 336, listHeight, listTop, listBottom, 29);
        this.attributeList.m_93507_(left + 12);
        this.m_142416_((GuiEventListener)this.attributeList);
        this.saveButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.save"), btn -> this.saveProperties()).m_252794_(left + 360 - 160, top + this.layoutHeight - 28).m_253046_(70, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.cancel"), btn -> this.m_7379_()).m_252794_(left + 360 - 82, top + this.layoutHeight - 28).m_253046_(70, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.refreshPropertyList();
    }

    public void m_86600_() {
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
    }

    private void refreshPropertyList() {
        if (this.attributeList == null) {
            return;
        }
        String filter = this.searchText == null ? "" : this.searchText.trim();
        ArrayList<PropertyEntry> entries = new ArrayList<PropertyEntry>();
        for (BasePropertyModel model : this.allProperties) {
            if (!filter.isEmpty() && !this.matchesFilter(model, filter)) continue;
            entries.add(new PropertyEntry(model));
        }
        this.attributeList.setEntries(entries);
        this.attributeList.m_6987_(null);
        this.attributeList.m_93410_(0.0);
    }

    private boolean matchesFilter(BasePropertyModel model, String filter) {
        String lower = filter.toLowerCase(Locale.ROOT);
        if (model.key().toLowerCase(Locale.ROOT).contains(lower)) {
            return true;
        }
        return model.displayName().getString().toLowerCase(Locale.ROOT).contains(lower);
    }

    private void openAddAttribute() {
        this.f_96541_.m_91152_((Screen)new AddAttributeScreen(this));
    }

    private void openEditScreen(BasePropertyModel model) {
        TemplateAttributeDefinition definition = this.definitionFor(model.key());
        if (definition != null && definition.getType() == TemplateAttributeType.TAGS) {
            this.f_96541_.m_91152_((Screen)new TagEditorScreen(this, model.key()));
            return;
        }
        if (definition != null && "biome_blacklist".equals(definition.getKey())) {
            this.f_96541_.m_91152_((Screen)new BiomeBlacklistScreen(this));
            return;
        }
        this.f_96541_.m_91152_((Screen)new AttributeEditScreen(this, model, definition));
    }

    void onCustomAttributesChanged() {
        this.ensureDefaultAttributes();
        this.loadBuiltInAttributeFlags();
        this.rebuildPropertyModels();
        this.refreshPropertyList();
    }

    private void saveProperties() {
        this.errorMessage = null;
        if (this.maxGenerationHeight < this.minGenerationHeight) {
            this.errorMessage = Component.m_237115_((String)"gui.hundred_years_war.template_properties.error.height_range").m_130940_(ChatFormatting.RED);
            return;
        }
        if (this.minBurialRate > this.maxBurialRate) {
            this.errorMessage = Component.m_237115_((String)"gui.hundred_years_war.template_properties.error.burial_range").m_130940_(ChatFormatting.RED);
            return;
        }
        this.syncBuiltInAttributeFlags();
        this.ensureDefaultAttributes();
        if (this.isNewTemplate) {
            Map<String, JsonElement> attributesCopy = this.cloneMap(this.customAttributes);
            this.callback.onPropertiesSet(new TemplatePropertiesData(this.generationEnabled, this.generationWeight, this.connectionLayerDepth, this.minGenerationHeight, this.maxGenerationHeight, this.generateOnSurface, attributesCopy));
        } else if (this.metadata != null && this.templateId != null) {
            this.metadata.setGenerationEnabled(this.generationEnabled);
            this.metadata.setGenerationWeight(this.generationWeight);
            this.metadata.setConnectionLayerDepth(this.connectionLayerDepth);
            this.metadata.setMinGenerationHeight(this.minGenerationHeight);
            this.metadata.setMaxGenerationHeight(this.maxGenerationHeight);
            this.metadata.setGenerateOnSurface(this.generateOnSurface);
            this.metadata.setRequiresPregen(this.requirePregen);
            this.metadata.setGenerateUnderwater(this.generateUnderwater);
            this.metadata.setGenerateOnWaterSurface(this.generateOnWaterSurface);
            this.metadata.setCustomAttributes(this.customAttributes);
            this.metadata.ensureCommonAttributes();
            ClientPacketHandler.sendUpdateTemplateProperties(this.templateId, this.generationEnabled, this.generationWeight, this.connectionLayerDepth, this.minGenerationHeight, this.maxGenerationHeight, this.generateOnSurface, this.cloneMap(this.customAttributes));
        }
        this.m_7379_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_5534_(chr, modifiers)) {
            return true;
        }
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.attributeList != null && this.attributeList.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.attributeList != null && this.attributeList.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.attributeList != null && this.attributeList.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.attributeList != null && this.attributeList.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int left = this.layoutLeft;
        int top = this.layoutTop;
        int heightBounds = this.layoutHeight;
        graphics.m_280509_(left - 4, top - 4, left + 360 + 4, top + heightBounds + 4, -16777216);
        graphics.m_280509_(left, top, left + 360, top + heightBounds, -14803426);
        graphics.m_280509_(left + 2, top + 2, left + 360 - 2, top + 20, -11908534);
        MutableComponent title = this.isNewTemplate ? Component.m_237115_((String)"gui.hundred_years_war.building_save_more_options.title_short") : Component.m_237115_((String)"gui.hundred_years_war.template_properties.title_short");
        graphics.m_280653_(this.f_96547_, (Component)title, this.f_96543_ / 2, top + 8, 0xFFFFFF);
        if (!this.templateNameForDisplay.isEmpty()) {
            MutableComponent nameLabel = Component.m_237110_((String)"gui.hundred_years_war.template_properties.template_name", (Object[])new Object[]{this.templateNameForDisplay});
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280430_(this.f_96547_, (Component)nameLabel, left + 12, top + 16 + 9, -3092272);
            if (!this.isNewTemplate && this.metadata != null) {
                MutableComponent stats = Component.m_237113_((String)String.format("  (%s / %d)", this.metadata.getSize().m_123344_(), this.metadata.getTotalBlocks())).m_130940_(ChatFormatting.GRAY);
                int n = left + 12 + this.f_96547_.m_92852_((FormattedText)nameLabel) + 4;
                Objects.requireNonNull(this.f_96547_);
                graphics.m_280430_(this.f_96547_, (Component)stats, n, top + 16 + 9, -5197648);
            }
        }
        if (this.errorMessage != null) {
            graphics.m_280430_(this.f_96547_, this.errorMessage, left + 12, top + heightBounds - 56, -43691);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private static JsonElement cloneJson(JsonElement element) {
        if (element == null) {
            return JsonNull.INSTANCE;
        }
        return element.deepCopy();
    }

    private static boolean expectBoolean(JsonElement element, String key) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isBoolean()) {
            throw new IllegalArgumentException(Component.m_237110_((String)"gui.hundred_years_war.template_properties.error.type_boolean", (Object[])new Object[]{key}).getString());
        }
        return element.getAsBoolean();
    }

    private static int expectIntInRange(JsonElement element, String key, int min, int max) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new IllegalArgumentException(Component.m_237110_((String)"gui.hundred_years_war.template_properties.error.type_integer", (Object[])new Object[]{key}).getString());
        }
        int value = element.getAsInt();
        if (value < min || value > max) {
            throw new IllegalArgumentException(Component.m_237110_((String)"gui.hundred_years_war.template_properties.error.range", (Object[])new Object[]{key, min, max}).getString());
        }
        return value;
    }

    private static double expectDoubleInRange(JsonElement element, String key, double min, double max) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new IllegalArgumentException(Component.m_237110_((String)"gui.hundred_years_war.template_properties.error.type_number", (Object[])new Object[]{key}).getString());
        }
        double value = element.getAsDouble();
        if (value < min || value > max) {
            throw new IllegalArgumentException(Component.m_237110_((String)"gui.hundred_years_war.template_properties.error.range", (Object[])new Object[]{key, min, max}).getString());
        }
        return value;
    }

    private static String expectString(JsonElement element, String key) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
            throw new IllegalArgumentException(Component.m_237110_((String)"gui.hundred_years_war.template_properties.error.type_string", (Object[])new Object[]{key}).getString());
        }
        return element.getAsString();
    }

    private static JsonElement parseFlexibleJson(String input) {
        if (input == null) {
            return JsonNull.INSTANCE;
        }
        try {
            return JsonParser.parseString((String)input);
        }
        catch (JsonSyntaxException ignored) {
            return new JsonPrimitive(input);
        }
    }

    private Map<String, JsonElement> cloneMap(Map<String, JsonElement> source) {
        LinkedHashMap<String, JsonElement> copy = new LinkedHashMap<String, JsonElement>();
        source.forEach((key, value) -> copy.put((String)key, TemplatePropertiesScreen.cloneJson(value)));
        return copy;
    }

    private boolean isBuiltInKey(String key) {
        return BUILT_IN_KEYS.contains(key);
    }

    private boolean isRequiredCustomKey(String key) {
        return REQUIRED_CUSTOM_KEYS.contains(key);
    }

    private MutableComponent resolveCustomLabel(String key) {
        String translationKey = "template_attribute." + key;
        if (I18n.m_118936_((String)translationKey)) {
            return Component.m_237115_((String)translationKey);
        }
        return Component.m_237113_((String)key);
    }

    private TemplateAttributeDefinition definitionFor(String key) {
        return TemplateAttributes.getDefinition(key);
    }

    private TemplateAttributeType typeOf(String key) {
        TemplateAttributeDefinition definition = this.definitionFor(key);
        return definition == null ? null : definition.getType();
    }

    private List<String> getCurrentBuildingTags() {
        ArrayList<String> tags = new ArrayList<String>();
        JsonElement element = this.customAttributes.get(BUILDING_TAGS_KEY);
        if (element != null && element.isJsonArray()) {
            element.getAsJsonArray().forEach(item -> {
                String value;
                if (item != null && item.isJsonPrimitive() && item.getAsJsonPrimitive().isString() && !(value = item.getAsString()).isEmpty()) {
                    tags.add(value);
                }
            });
        }
        return tags;
    }

    private List<ResourceLocation> getCurrentBiomeBlacklist() {
        ArrayList<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
        JsonElement element = this.customAttributes.get("biome_blacklist");
        if (element != null && element.isJsonArray()) {
            element.getAsJsonArray().forEach(item -> {
                ResourceLocation id;
                if (item != null && item.isJsonPrimitive() && item.getAsJsonPrimitive().isString() && (id = ResourceLocation.m_135820_((String)item.getAsString())) != null) {
                    biomes.add(id);
                }
            });
        }
        return biomes;
    }

    private boolean isTagBoundAttribute(String key) {
        if (key == null) {
            return false;
        }
        for (String tagId : this.getCurrentBuildingTags()) {
            if (!TemplateTags.getAttributeKeys(tagId).contains(key)) continue;
            return true;
        }
        return false;
    }

    private Component getTypeDisplayName(TemplateAttributeType type) {
        if (type == null) {
            return Component.m_237113_((String)"-");
        }
        String key = "template_attribute_type." + type.name().toLowerCase(Locale.ROOT);
        if (I18n.m_118936_((String)key)) {
            return Component.m_237115_((String)key);
        }
        return Component.m_237113_((String)type.name().toLowerCase(Locale.ROOT));
    }

    public static interface PropertiesCallback {
        public void onPropertiesSet(TemplatePropertiesData var1);
    }

    private class BuiltInPropertyModel
    extends BasePropertyModel {
        private final String key;
        private final Component label;
        private final Supplier<JsonElement> getter;
        private final Consumer<JsonElement> applier;

        private BuiltInPropertyModel(String key, Component label, Supplier<JsonElement> getter, Consumer<JsonElement> applier) {
            this.key = key;
            this.label = label;
            this.getter = getter;
            this.applier = applier;
        }

        @Override
        String key() {
            return this.key;
        }

        @Override
        Component displayName() {
            return this.label;
        }

        @Override
        JsonElement getValue() {
            return TemplatePropertiesScreen.cloneJson(this.getter.get());
        }

        @Override
        void applyValue(JsonElement value) throws IllegalArgumentException {
            this.applier.accept(value);
        }
    }

    private class CustomPropertyModel
    extends BasePropertyModel {
        private final String key;

        private CustomPropertyModel(String key) {
            this.key = key;
        }

        @Override
        String key() {
            return this.key;
        }

        @Override
        Component displayName() {
            return TemplatePropertiesScreen.this.resolveCustomLabel(this.key);
        }

        @Override
        JsonElement getValue() {
            return TemplatePropertiesScreen.cloneJson(TemplatePropertiesScreen.this.customAttributes.get(this.key));
        }

        @Override
        void applyValue(JsonElement value) {
            TemplatePropertiesScreen.this.customAttributes.put(this.key, TemplateAttributes.normaliseValue(this.key, value));
        }

        @Override
        boolean isRemovable() {
            return !TemplatePropertiesScreen.this.isRequiredCustomKey(this.key) && !TemplatePropertiesScreen.this.isTagBoundAttribute(this.key);
        }

        @Override
        void remove() {
            if (this.isRemovable()) {
                TemplatePropertiesScreen.this.customAttributes.remove(this.key);
            }
        }
    }

    private static class AttributeListWidget
    extends ContainerObjectSelectionList<PropertyEntry> {
        AttributeListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
            this.m_93488_(false);
            this.m_93496_(false);
        }

        protected int m_5756_() {
            return this.f_93393_ + this.f_93388_ - 6;
        }

        public int m_5759_() {
            return this.f_93388_ - 8;
        }

        void setEntries(List<PropertyEntry> entries) {
            this.m_5988_(entries);
        }
    }

    private abstract class BasePropertyModel {
        private BasePropertyModel() {
        }

        abstract String key();

        abstract Component displayName();

        abstract JsonElement getValue();

        abstract void applyValue(JsonElement var1) throws IllegalArgumentException;

        boolean isRemovable() {
            return false;
        }

        void remove() {
        }
    }

    private class PropertyEntry
    extends ContainerObjectSelectionList.Entry<PropertyEntry> {
        private final BasePropertyModel model;
        private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        private final Button editButton;
        private final Button removeButton;

        private PropertyEntry(BasePropertyModel model) {
            this.model = model;
            this.editButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.edit"), btn -> TemplatePropertiesScreen.this.openEditScreen(model)).m_253046_(58, 20).m_253136_();
            this.widgets.add((AbstractWidget)this.editButton);
            this.removeButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.remove"), btn -> {
                model.remove();
                TemplatePropertiesScreen.this.onCustomAttributesChanged();
            }).m_253046_(58, 20).m_253136_();
            this.widgets.add((AbstractWidget)this.removeButton);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.widgets;
        }

        public void m_6311_(@NotNull GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
            boolean removable;
            int valueAreaWidth = width - 136;
            graphics.m_280509_(left, top, left + width, top + height, hovered ? -13684945 : -14342875);
            Component label = this.model.displayName();
            graphics.m_280430_(TemplatePropertiesScreen.this.f_96547_, label, left + 6, top + 1, 0xFFFFFF);
            MutableComponent keyComponent = Component.m_237113_((String)this.model.key()).m_130940_(ChatFormatting.DARK_GRAY);
            graphics.m_280430_(TemplatePropertiesScreen.this.f_96547_, (Component)keyComponent, left + 6, top + 17, -5592406);
            String valueString = GSON.toJson(this.model.getValue());
            String trimmedValue = TemplatePropertiesScreen.this.f_96547_.m_92834_(valueString, valueAreaWidth);
            graphics.m_280488_(TemplatePropertiesScreen.this.f_96547_, trimmedValue, left + 6, top + 10, -6369281);
            int buttonY = top + 3;
            this.editButton.m_264152_(left + width - 132, buttonY);
            this.editButton.m_88315_(graphics, mouseX, mouseY, partialTick);
            this.removeButton.f_93624_ = removable = this.model.isRemovable();
            if (removable) {
                this.removeButton.m_264152_(left + width - 66, buttonY);
                this.removeButton.m_88315_(graphics, mouseX, mouseY, partialTick);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            for (AbstractWidget widget : this.widgets) {
                if (!widget.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }

    private class AddAttributeScreen
    extends Screen {
        private final TemplatePropertiesScreen parent;
        private EditBox keyBox;
        private EditBox valueBox;
        private Component localError;

        protected AddAttributeScreen(TemplatePropertiesScreen parent) {
            super((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.add_attribute"));
            this.parent = parent;
        }

        protected void m_7856_() {
            int dialogWidth = 300;
            int dialogHeight = 160;
            int left = (this.f_96543_ - dialogWidth) / 2;
            int top = (this.f_96544_ - dialogHeight) / 2;
            this.keyBox = new EditBox(this.f_96547_, left + 16, top + 42, dialogWidth - 32, 18, (Component)Component.m_237119_());
            this.keyBox.m_94199_(64);
            this.m_142416_((GuiEventListener)this.keyBox);
            this.valueBox = new EditBox(this.f_96547_, left + 16, top + 91, dialogWidth - 32, 18, (Component)Component.m_237119_());
            this.valueBox.m_94199_(512);
            this.valueBox.m_94144_("\"\"");
            this.m_142416_((GuiEventListener)this.valueBox);
            Button createButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.create"), btn -> this.attemptCreate()).m_252794_(left + dialogWidth - 128, top + dialogHeight - 28).m_253046_(56, 20).m_253136_();
            this.m_142416_((GuiEventListener)createButton);
            Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.cancel"), btn -> this.m_7379_()).m_252794_(left + dialogWidth - 64, top + dialogHeight - 28).m_253046_(48, 20).m_253136_();
            this.m_142416_((GuiEventListener)cancelButton);
        }

        private void attemptCreate() {
            String rawKey = this.keyBox.m_94155_();
            if (rawKey == null || rawKey.isBlank()) {
                this.localError = Component.m_237115_((String)"gui.hundred_years_war.template_properties.error.empty_key").m_130940_(ChatFormatting.RED);
                return;
            }
            String normalisedKey = rawKey.trim().toLowerCase(Locale.ROOT).replace(' ', '_');
            if (!normalisedKey.matches("[a-z0-9_.:\\-]+")) {
                this.localError = Component.m_237110_((String)"gui.hundred_years_war.template_properties.error.invalid_key", (Object[])new Object[]{normalisedKey}).m_130940_(ChatFormatting.RED);
                return;
            }
            if (this.parent.isBuiltInKey(normalisedKey)) {
                this.localError = Component.m_237110_((String)"gui.hundred_years_war.template_properties.error.duplicate_key", (Object[])new Object[]{normalisedKey}).m_130940_(ChatFormatting.RED);
                return;
            }
            if (this.parent.customAttributes.containsKey(normalisedKey)) {
                this.localError = Component.m_237110_((String)"gui.hundred_years_war.template_properties.error.duplicate_key", (Object[])new Object[]{normalisedKey}).m_130940_(ChatFormatting.RED);
                return;
            }
            try {
                JsonElement parsed = TemplatePropertiesScreen.parseFlexibleJson(this.valueBox.m_94155_());
                this.parent.customAttributes.put(normalisedKey, TemplateAttributes.normaliseValue(normalisedKey, parsed));
                this.parent.onCustomAttributesChanged();
                this.m_7379_();
            }
            catch (IllegalArgumentException e) {
                this.localError = Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.RED);
            }
        }

        public void m_7379_() {
            this.f_96541_.m_91152_((Screen)this.parent);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.keyBox != null && this.keyBox.m_7933_(keyCode, scanCode, modifiers) || this.valueBox != null && this.valueBox.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.attemptCreate();
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char chr, int modifiers) {
            if (this.keyBox != null && this.keyBox.m_5534_(chr, modifiers) || this.valueBox != null && this.valueBox.m_5534_(chr, modifiers)) {
                return true;
            }
            return super.m_5534_(chr, modifiers);
        }

        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(graphics);
            int dialogWidth = 300;
            int dialogHeight = 160;
            int left = (this.f_96543_ - dialogWidth) / 2;
            int top = (this.f_96544_ - dialogHeight) / 2;
            graphics.m_280509_(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
            graphics.m_280509_(left, top, left + dialogWidth, top + dialogHeight, -14540254);
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.add_attribute"), this.f_96543_ / 2, top + 8, 0xFFFFFF);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.attribute_key"), left + 16, top + 28, -4473925);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.attribute_value"), left + 16, top + 78, -4473925);
            if (this.localError != null) {
                graphics.m_280430_(this.f_96547_, this.localError, left + 16, top + dialogHeight - 46, -43691);
            }
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }

    private class TagEditorScreen
    extends Screen {
        private final TemplatePropertiesScreen parent;
        private final String attributeKey;
        private final List<String> initialTags;
        private final List<String> workingTags;
        private String searchText;
        private boolean rawMode;
        private String rawDraft;
        private EditBox inputBox;
        private EditBox rawInputBox;
        private TagSuggestionList suggestionList;
        private ActiveTagList activeTagList;
        private Component feedback;
        private int feedbackColor;
        private Component rawFeedback;
        private int rawFeedbackColor;

        protected TagEditorScreen(TemplatePropertiesScreen parent, String attributeKey) {
            super((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.edit_tags"));
            this.workingTags = new ArrayList<String>();
            this.searchText = "";
            this.rawDraft = "";
            this.feedbackColor = -5197648;
            this.rawFeedbackColor = -5197648;
            this.parent = parent;
            this.attributeKey = attributeKey;
            this.initialTags = List.copyOf(parent.getCurrentBuildingTags());
            this.workingTags.addAll(this.initialTags);
        }

        protected void m_7856_() {
            int dialogWidth = 360;
            int dialogHeight = this.rawMode ? 210 : 240;
            int left = (this.f_96543_ - dialogWidth) / 2;
            int top = (this.f_96544_ - dialogHeight) / 2;
            this.inputBox = null;
            this.rawInputBox = null;
            this.suggestionList = null;
            this.activeTagList = null;
            Button modeButton = Button.m_253074_((Component)this.getModeButtonLabel(), btn -> this.toggleRawMode()).m_252794_(left + dialogWidth - 98, top + 32).m_253046_(82, 20).m_253136_();
            this.m_142416_((GuiEventListener)modeButton);
            if (!this.rawMode) {
                this.inputBox = new EditBox(this.f_96547_, left + 16, top + 34, dialogWidth - 134, 18, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.tag_input_hint"));
                this.inputBox.m_257771_((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.tag_input_hint"));
                this.inputBox.m_94144_(this.searchText);
                this.inputBox.m_94151_(text -> {
                    this.searchText = text == null ? "" : text;
                    this.refreshSuggestions();
                    this.refreshActiveList();
                });
                this.m_142416_((GuiEventListener)this.inputBox);
                this.suggestionList = new TagSuggestionList(this.f_96541_, dialogWidth / 2 - 20, 120, top + 70, top + 70 + 120, 28);
                this.suggestionList.m_93507_(left + 16);
                this.m_142416_((GuiEventListener)this.suggestionList);
                this.activeTagList = new ActiveTagList(this.f_96541_, dialogWidth / 2 - 20, 120, top + 70, top + 70 + 120, 28);
                this.activeTagList.m_93507_(left + dialogWidth / 2 + 4);
                this.m_142416_((GuiEventListener)this.activeTagList);
            } else {
                if (this.rawDraft.isEmpty()) {
                    this.rawDraft = this.serialiseWorkingTags();
                }
                this.rawInputBox = new EditBox(this.f_96547_, left + 16, top + 78, dialogWidth - 32, 18, (Component)Component.m_237119_());
                this.rawInputBox.m_94199_(4096);
                this.rawInputBox.m_94144_(this.rawDraft);
                this.rawInputBox.m_94151_(text -> {
                    this.rawDraft = text == null ? "" : text;
                });
                this.m_142416_((GuiEventListener)this.rawInputBox);
            }
            Button saveButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.save"), btn -> this.applyChanges()).m_252794_(left + dialogWidth - 120, top + dialogHeight - 28).m_253046_(52, 20).m_253136_();
            this.m_142416_((GuiEventListener)saveButton);
            Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.cancel"), btn -> this.m_7379_()).m_252794_(left + dialogWidth - 64, top + dialogHeight - 28).m_253046_(52, 20).m_253136_();
            this.m_142416_((GuiEventListener)cancelButton);
            this.refreshSuggestions();
            this.refreshActiveList();
        }

        public void m_86600_() {
            if (this.rawMode) {
                if (this.rawInputBox != null) {
                    this.rawInputBox.m_94120_();
                }
            } else if (this.inputBox != null) {
                this.inputBox.m_94120_();
            }
        }

        private void refreshSuggestions() {
            if (this.suggestionList == null) {
                return;
            }
            String filter = this.searchText == null ? "" : this.searchText.trim().toLowerCase(Locale.ROOT);
            ArrayList<TagSuggestionEntry> entries = new ArrayList<TagSuggestionEntry>();
            for (TemplateTagDefinition definition : TemplateTags.all()) {
                if (!this.matches(definition, filter)) continue;
                entries.add(new TagSuggestionEntry(definition));
            }
            entries.sort(Comparator.comparing(entry -> entry.definition.getTranslationKey()));
            this.suggestionList.setEntries(entries);
        }

        private void refreshActiveList() {
            if (this.activeTagList == null) {
                return;
            }
            String filter = this.searchText == null ? "" : this.searchText.trim().toLowerCase(Locale.ROOT);
            ArrayList<ActiveTagEntry> entries = new ArrayList<ActiveTagEntry>();
            for (String tagId : this.orderTags(this.workingTags)) {
                TemplateTagDefinition definition = TemplateTags.get(tagId);
                if (definition == null || !this.matches(definition, filter)) continue;
                entries.add(new ActiveTagEntry(definition));
            }
            this.activeTagList.setEntries(entries);
        }

        private List<String> orderTags(List<String> source) {
            ArrayList<String> ordered = new ArrayList<String>(source);
            ordered.sort(Comparator.comparingInt(this::definitionIndex));
            return ordered;
        }

        private int definitionIndex(String tagId) {
            int index = 0;
            for (TemplateTagDefinition definition : TemplateTags.all()) {
                if (definition.getId().equals(tagId)) {
                    return index;
                }
                ++index;
            }
            return Integer.MAX_VALUE;
        }

        private boolean matches(TemplateTagDefinition definition, String filter) {
            if (filter == null || filter.isEmpty()) {
                return true;
            }
            String id = definition.getId();
            if (id.contains(filter)) {
                return true;
            }
            String translated = I18n.m_118938_((String)definition.getTranslationKey(), (Object[])new Object[0]);
            return translated != null && translated.toLowerCase(Locale.ROOT).contains(filter);
        }

        private void attemptQuickAdd() {
            TagSuggestionEntry first;
            if (this.inputBox == null) {
                return;
            }
            TemplateTagDefinition definition = this.resolveDefinition(this.inputBox.m_94155_());
            if (definition == null && this.suggestionList != null && (first = this.suggestionList.firstEntry()) != null) {
                definition = first.definition;
            }
            if (definition != null) {
                this.addTag(definition);
            } else {
                this.feedback = Component.m_237115_((String)"gui.hundred_years_war.template_properties.tags.error.unknown");
                this.feedbackColor = -43691;
            }
        }

        private TemplateTagDefinition resolveDefinition(String raw) {
            if (raw == null) {
                return null;
            }
            String normalised = this.normaliseTagId(raw);
            TemplateTagDefinition definition = TemplateTags.get(normalised);
            if (definition != null) {
                return definition;
            }
            String cleaned = raw.trim().toLowerCase(Locale.ROOT);
            for (TemplateTagDefinition candidate : TemplateTags.all()) {
                String translated = I18n.m_118938_((String)candidate.getTranslationKey(), (Object[])new Object[0]).trim().toLowerCase(Locale.ROOT);
                if (!translated.equals(cleaned)) continue;
                return candidate;
            }
            return null;
        }

        private void addTag(TemplateTagDefinition definition) {
            if (definition == null) {
                return;
            }
            String id = definition.getId();
            if (this.workingTags.contains(id)) {
                this.feedback = Component.m_237110_((String)"gui.hundred_years_war.template_properties.tags.error.duplicate", (Object[])new Object[]{I18n.m_118938_((String)definition.getTranslationKey(), (Object[])new Object[0])});
                this.feedbackColor = -171;
                return;
            }
            this.workingTags.add(id);
            this.refreshActiveList();
            this.refreshSuggestions();
            this.feedback = Component.m_237110_((String)"gui.hundred_years_war.template_properties.tags.feedback.added", (Object[])new Object[]{I18n.m_118938_((String)definition.getTranslationKey(), (Object[])new Object[0])});
            this.feedbackColor = -11141291;
        }

        private void removeTag(TemplateTagDefinition definition) {
            if (definition == null) {
                return;
            }
            if (this.workingTags.remove(definition.getId())) {
                this.refreshActiveList();
                this.refreshSuggestions();
                this.feedback = Component.m_237110_((String)"gui.hundred_years_war.template_properties.tags.feedback.removed", (Object[])new Object[]{I18n.m_118938_((String)definition.getTranslationKey(), (Object[])new Object[0])});
                this.feedbackColor = -171;
            }
        }

        private void applyChanges() {
            if (this.rawMode && !this.commitRawInput()) {
                return;
            }
            List<String> result = this.orderTags(this.workingTags);
            JsonArray array = new JsonArray();
            result.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            this.parent.customAttributes.put(this.attributeKey, TemplateAttributes.normaliseValue(this.attributeKey, (JsonElement)array));
            LinkedHashSet<String> before = new LinkedHashSet<String>(this.initialTags);
            LinkedHashSet<String> after = new LinkedHashSet<String>(result);
            for (String tagId : after) {
                if (before.contains(tagId)) continue;
                Map<String, JsonElement> values = TemplateTags.createAttributeValues(tagId);
                values.forEach((key, value) -> this.parent.customAttributes.putIfAbsent((String)key, TemplateAttributes.normaliseValue(key, value)));
            }
            for (String tagId : before) {
                TemplateTagDefinition definition;
                if (after.contains(tagId) || (definition = TemplateTags.get(tagId)) == null) continue;
                LinkedHashSet<String> remainingAttributes = new LinkedHashSet<String>();
                for (String remaining : after) {
                    remainingAttributes.addAll(TemplateTags.getAttributeKeys(remaining));
                }
                for (String attributeKey : definition.getAttributeKeys()) {
                    if (remainingAttributes.contains(attributeKey)) continue;
                    this.parent.customAttributes.remove(attributeKey);
                }
            }
            this.parent.onCustomAttributesChanged();
            this.m_7379_();
        }

        private String normaliseTagId(String input) {
            if (input == null) {
                return "";
            }
            return input.trim().toLowerCase(Locale.ROOT).replace(' ', '_');
        }

        public void m_7379_() {
            this.f_96541_.m_91152_((Screen)this.parent);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.rawMode) {
                if (this.rawInputBox != null && this.rawInputBox.m_7933_(keyCode, scanCode, modifiers)) {
                    return true;
                }
                if (keyCode == 257 || keyCode == 335) {
                    this.commitRawInput();
                    return true;
                }
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
            if (this.inputBox != null && this.inputBox.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.attemptQuickAdd();
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char chr, int modifiers) {
            if (this.rawMode) {
                if (this.rawInputBox != null && this.rawInputBox.m_5534_(chr, modifiers)) {
                    return true;
                }
                return super.m_5534_(chr, modifiers);
            }
            if (this.inputBox != null && this.inputBox.m_5534_(chr, modifiers)) {
                return true;
            }
            return super.m_5534_(chr, modifiers);
        }

        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(graphics);
            int dialogWidth = 360;
            int dialogHeight = this.rawMode ? 210 : 240;
            int left = (this.f_96543_ - dialogWidth) / 2;
            int top = (this.f_96544_ - dialogHeight) / 2;
            graphics.m_280509_(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
            graphics.m_280509_(left, top, left + dialogWidth, top + dialogHeight, -14671840);
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.edit_tags"), this.f_96543_ / 2, top + 8, 0xFFFFFF);
            if (this.rawMode) {
                graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.raw_input_label"), left + 16, top + 60, -4473925);
                if (this.rawFeedback != null) {
                    graphics.m_280430_(this.f_96547_, this.rawFeedback, left + 16, top + dialogHeight - 46, this.rawFeedbackColor);
                }
            } else {
                graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.tag_list_available"), left + 16, top + 57, -5592406);
                graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.tag_list_selected"), left + dialogWidth / 2 + 4, top + 57, -5592406);
                if (this.feedback != null) {
                    graphics.m_280430_(this.f_96547_, this.feedback, left + 16, top + dialogHeight - 46, this.feedbackColor);
                }
            }
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }

        private Component getModeButtonLabel() {
            return Component.m_237115_((String)(this.rawMode ? "gui.hundred_years_war.template_properties.input_mode.list" : "gui.hundred_years_war.template_properties.input_mode.raw"));
        }

        private void toggleRawMode() {
            if (this.rawMode && !this.commitRawInput()) {
                return;
            }
            boolean bl = this.rawMode = !this.rawMode;
            if (this.rawMode) {
                this.rawFeedback = null;
                this.rawDraft = this.serialiseWorkingTags();
            }
            if (this.f_96541_ != null) {
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            }
        }

        private String serialiseWorkingTags() {
            JsonArray array = new JsonArray();
            this.orderTags(this.workingTags).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            return GSON.toJson((JsonElement)array);
        }

        private boolean commitRawInput() {
            JsonElement parsed;
            if (this.rawInputBox == null) {
                return true;
            }
            String value = this.rawInputBox.m_94155_();
            if (value == null || value.isBlank()) {
                value = "[]";
            }
            if ((parsed = TemplatePropertiesScreen.parseFlexibleJson(value)) == null || !parsed.isJsonArray()) {
                this.rawFeedback = Component.m_237115_((String)"gui.hundred_years_war.template_properties.raw_input_error_format");
                this.rawFeedbackColor = -43691;
                return false;
            }
            ArrayList<String> updated = new ArrayList<String>();
            for (JsonElement element : parsed.getAsJsonArray()) {
                if (element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    String normalised = this.normaliseTagId(element.getAsString());
                    if (normalised.isEmpty() || updated.contains(normalised)) continue;
                    updated.add(normalised);
                    continue;
                }
                this.rawFeedback = Component.m_237115_((String)"gui.hundred_years_war.template_properties.raw_input_error_entry");
                this.rawFeedbackColor = -43691;
                return false;
            }
            this.workingTags.clear();
            this.workingTags.addAll(updated);
            this.rawDraft = GSON.toJson(parsed);
            this.rawFeedback = Component.m_237115_((String)"gui.hundred_years_war.template_properties.raw_input_applied");
            this.rawFeedbackColor = -11141291;
            this.refreshActiveList();
            this.refreshSuggestions();
            return true;
        }

        private class TagSuggestionList
        extends ContainerObjectSelectionList<TagSuggestionEntry> {
            TagSuggestionList(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
                super(minecraft, width, height, top, bottom, itemHeight);
                this.m_93488_(false);
                this.m_93496_(false);
            }

            protected int m_5756_() {
                return this.f_93393_ + this.f_93388_ - 6;
            }

            public int m_5759_() {
                return this.f_93388_ - 8;
            }

            void setEntries(List<TagSuggestionEntry> entries) {
                this.m_5988_(entries);
            }

            TagSuggestionEntry firstEntry() {
                List children = this.m_6702_();
                return children.isEmpty() ? null : (TagSuggestionEntry)((Object)children.get(0));
            }
        }

        private class ActiveTagList
        extends ContainerObjectSelectionList<ActiveTagEntry> {
            ActiveTagList(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
                super(minecraft, width, height, top, bottom, itemHeight);
                this.m_93488_(false);
                this.m_93496_(false);
            }

            protected int m_5756_() {
                return this.f_93393_ + this.f_93388_ - 6;
            }

            public int m_5759_() {
                return this.f_93388_ - 8;
            }

            void setEntries(List<ActiveTagEntry> entries) {
                this.m_5988_(entries);
            }
        }

        private class TagSuggestionEntry
        extends ContainerObjectSelectionList.Entry<TagSuggestionEntry> {
            private final TemplateTagDefinition definition;
            private int lastLeft;
            private int lastTop;
            private int lastRight;
            private int lastBottom;

            private TagSuggestionEntry(TemplateTagDefinition definition) {
                this.definition = definition;
            }

            public List<? extends GuiEventListener> m_6702_() {
                return List.of();
            }

            public List<? extends NarratableEntry> m_142437_() {
                return List.of();
            }

            public void m_6311_(@NotNull GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                this.lastLeft = left;
                this.lastTop = top;
                this.lastRight = left + width;
                this.lastBottom = top + height;
                graphics.m_280509_(left, top, left + width, top + height, hovered ? -13681617 : -14800866);
                MutableComponent displayName = Component.m_237115_((String)this.definition.getTranslationKey());
                MutableComponent idComponent = Component.m_237113_((String)this.definition.getId()).m_130940_(ChatFormatting.DARK_GRAY);
                int textLeft = left + 6;
                int textRight = left + width - 6;
                Font font = TagEditorScreen.this.f_96547_;
                Objects.requireNonNull(TagEditorScreen.this.f_96547_);
                ScrollingTextRenderer.render(graphics, font, (Component)displayName, textLeft, top + 2, textRight, top + 2 + 9, 0xFFFFFF);
                Font font2 = TagEditorScreen.this.f_96547_;
                Objects.requireNonNull(TagEditorScreen.this.f_96547_);
                ScrollingTextRenderer.render(graphics, font2, (Component)idComponent, textLeft, top + 12, textRight, top + 12 + 9, -5197648);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0 && mouseX >= (double)this.lastLeft && mouseX <= (double)this.lastRight && mouseY >= (double)this.lastTop && mouseY <= (double)this.lastBottom) {
                    TagEditorScreen.this.addTag(this.definition);
                    return true;
                }
                return false;
            }
        }

        private class ActiveTagEntry
        extends ContainerObjectSelectionList.Entry<ActiveTagEntry> {
            private final TemplateTagDefinition definition;
            private int lastLeft;
            private int lastTop;
            private int lastRight;
            private int lastBottom;

            private ActiveTagEntry(TemplateTagDefinition definition) {
                this.definition = definition;
            }

            public List<? extends GuiEventListener> m_6702_() {
                return List.of();
            }

            public List<? extends NarratableEntry> m_142437_() {
                return List.of();
            }

            public void m_6311_(@NotNull GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                this.lastLeft = left;
                this.lastTop = top;
                this.lastRight = left + width;
                this.lastBottom = top + height;
                graphics.m_280509_(left, top, left + width, top + height, hovered ? -12376538 : -13688800);
                MutableComponent displayName = Component.m_237115_((String)this.definition.getTranslationKey());
                MutableComponent idComponent = Component.m_237113_((String)this.definition.getId()).m_130940_(ChatFormatting.DARK_GRAY);
                int textLeft = left + 6;
                int textRight = left + width - 6;
                Font font = TagEditorScreen.this.f_96547_;
                Objects.requireNonNull(TagEditorScreen.this.f_96547_);
                ScrollingTextRenderer.render(graphics, font, (Component)displayName, textLeft, top + 2, textRight, top + 2 + 9, 0xFFFFFF);
                Font font2 = TagEditorScreen.this.f_96547_;
                Objects.requireNonNull(TagEditorScreen.this.f_96547_);
                ScrollingTextRenderer.render(graphics, font2, (Component)idComponent, textLeft, top + 12, textRight, top + 12 + 9, -5197648);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0 && mouseX >= (double)this.lastLeft && mouseX <= (double)this.lastRight && mouseY >= (double)this.lastTop && mouseY <= (double)this.lastBottom) {
                    TagEditorScreen.this.removeTag(this.definition);
                    return true;
                }
                return false;
            }
        }
    }

    private class BiomeBlacklistScreen
    extends Screen {
        private final TemplatePropertiesScreen parent;
        private final List<ResourceLocation> initialBiomes;
        private final List<ResourceLocation> workingBiomes;
        private final List<BiomeDescriptor> descriptors;
        private final Map<ResourceLocation, Component> nameCache;
        private String filterText;
        private boolean rawMode;
        private String rawDraft;
        private EditBox filterBox;
        private EditBox rawInputBox;
        private SelectedBiomeList selectedList;
        private Button pickerButton;
        private Component feedback;
        private int feedbackColor;
        private Component rawFeedback;
        private int rawFeedbackColor;

        protected BiomeBlacklistScreen(TemplatePropertiesScreen parent) {
            super((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.biome_blacklist.title"));
            this.workingBiomes = new ArrayList<ResourceLocation>();
            this.nameCache = new HashMap<ResourceLocation, Component>();
            this.filterText = "";
            this.rawDraft = "";
            this.feedbackColor = -5197648;
            this.rawFeedbackColor = -5197648;
            this.parent = parent;
            this.initialBiomes = List.copyOf(parent.getCurrentBiomeBlacklist());
            this.workingBiomes.addAll(this.initialBiomes);
            this.descriptors = this.loadDescriptors();
        }

        protected void m_7856_() {
            int dialogWidth = 360;
            int dialogHeight = this.dialogHeight();
            int left = (this.f_96543_ - dialogWidth) / 2;
            int top = (this.f_96544_ - dialogHeight) / 2;
            this.filterBox = null;
            this.rawInputBox = null;
            this.selectedList = null;
            this.pickerButton = null;
            Button modeButton = Button.m_253074_((Component)this.getModeButtonLabel(), btn -> this.toggleRawMode()).m_252794_(left + dialogWidth - 98, top + 32).m_253046_(82, 20).m_253136_();
            this.m_142416_((GuiEventListener)modeButton);
            if (!this.rawMode) {
                int addButtonSize = 20;
                int modeButtonWidth = 82;
                int searchWidth = dialogWidth - 32 - addButtonSize - modeButtonWidth - 8;
                this.filterBox = new EditBox(this.f_96547_, left + 16, top + 34, searchWidth, 18, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.biome_blacklist.search_hint"));
                this.filterBox.m_257771_((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.biome_blacklist.search_hint"));
                this.filterBox.m_94144_(this.filterText);
                this.filterBox.m_94151_(text -> {
                    this.filterText = text == null ? "" : text;
                    this.refreshSelectedList();
                });
                this.m_142416_((GuiEventListener)this.filterBox);
                this.pickerButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), btn -> this.openPicker()).m_252794_(left + 16 + searchWidth + 4, top + 33).m_253046_(addButtonSize, 20).m_253136_();
                this.pickerButton.f_93623_ = this.hasAvailableBiomes();
                this.m_142416_((GuiEventListener)this.pickerButton);
                int listHeight = Math.max(120, dialogHeight - 110);
                this.selectedList = new SelectedBiomeList(this.f_96541_, dialogWidth - 32, listHeight, top + 70, top + 70 + listHeight, 26);
                this.selectedList.m_93507_(left + 16);
                this.m_142416_((GuiEventListener)this.selectedList);
            } else {
                if (this.rawDraft.isEmpty()) {
                    this.rawDraft = this.serialiseWorkingBiomes();
                }
                this.rawInputBox = new EditBox(this.f_96547_, left + 16, top + 78, dialogWidth - 32, 18, (Component)Component.m_237119_());
                this.rawInputBox.m_94199_(4096);
                this.rawInputBox.m_94144_(this.rawDraft);
                this.rawInputBox.m_94151_(text -> {
                    this.rawDraft = text == null ? "" : text;
                });
                this.m_142416_((GuiEventListener)this.rawInputBox);
            }
            Button saveButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.save"), btn -> this.applyChanges()).m_252794_(left + dialogWidth - 120, top + dialogHeight - 28).m_253046_(52, 20).m_253136_();
            this.m_142416_((GuiEventListener)saveButton);
            Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.cancel"), btn -> this.m_7379_()).m_252794_(left + dialogWidth - 64, top + dialogHeight - 28).m_253046_(52, 20).m_253136_();
            this.m_142416_((GuiEventListener)cancelButton);
            this.refreshSelectedList();
        }

        public void m_86600_() {
            if (this.rawMode) {
                if (this.rawInputBox != null) {
                    this.rawInputBox.m_94120_();
                }
            } else if (this.filterBox != null) {
                this.filterBox.m_94120_();
            }
        }

        private void refreshSelectedList() {
            if (this.selectedList == null) {
                return;
            }
            String filter = this.filterText == null ? "" : this.filterText.trim().toLowerCase(Locale.ROOT);
            ArrayList<SelectedBiomeEntry> entries = new ArrayList<SelectedBiomeEntry>();
            for (ResourceLocation id : this.workingBiomes) {
                if (!filter.isEmpty() && !this.matches(id, filter)) continue;
                entries.add(new SelectedBiomeEntry(id));
            }
            this.selectedList.setEntries(entries);
            this.updatePickerAvailability();
        }

        private boolean matches(ResourceLocation id, String filter) {
            if (filter == null || filter.isEmpty()) {
                return true;
            }
            Component name = this.displayNameFor(id);
            return id.toString().toLowerCase(Locale.ROOT).contains(filter) || name.getString().toLowerCase(Locale.ROOT).contains(filter);
        }

        private void addBiome(ResourceLocation id) {
            if (id == null) {
                return;
            }
            if (this.workingBiomes.contains(id)) {
                this.feedback = Component.m_237110_((String)"gui.hundred_years_war.template_properties.biome_blacklist.duplicate", (Object[])new Object[]{id.toString()});
                this.feedbackColor = -171;
                return;
            }
            this.workingBiomes.add(id);
            this.refreshSelectedList();
            this.feedback = Component.m_237110_((String)"gui.hundred_years_war.template_properties.biome_blacklist.added", (Object[])new Object[]{this.displayNameFor(id)});
            this.feedbackColor = -11141291;
        }

        private void removeBiome(ResourceLocation id) {
            if (id == null) {
                return;
            }
            if (this.workingBiomes.remove(id)) {
                this.refreshSelectedList();
                this.feedback = Component.m_237110_((String)"gui.hundred_years_war.template_properties.biome_blacklist.removed", (Object[])new Object[]{this.displayNameFor(id)});
                this.feedbackColor = -171;
            }
        }

        private void openPicker() {
            if (this.descriptors.isEmpty() || !this.hasAvailableBiomes()) {
                return;
            }
            this.f_96541_.m_91152_((Screen)new BiomePickerScreen(this, this.descriptors));
        }

        private void applyChanges() {
            if (this.rawMode && !this.commitRawInput()) {
                return;
            }
            JsonArray array = new JsonArray();
            this.workingBiomes.forEach(id -> array.add(id.toString()));
            this.parent.customAttributes.put("biome_blacklist", TemplateAttributes.normaliseValue("biome_blacklist", (JsonElement)array));
            this.parent.onCustomAttributesChanged();
            this.m_7379_();
        }

        private Component displayNameFor(ResourceLocation id) {
            return this.nameCache.computeIfAbsent(id, key -> {
                String translationKey = "biome." + key.m_135827_() + "." + key.m_135815_();
                if (I18n.m_118936_((String)translationKey)) {
                    return Component.m_237115_((String)translationKey);
                }
                return Component.m_237113_((String)key.toString());
            });
        }

        private int dialogHeight() {
            return this.rawMode ? 210 : 250;
        }

        private void updatePickerAvailability() {
            if (this.pickerButton != null) {
                this.pickerButton.f_93623_ = this.hasAvailableBiomes();
            }
        }

        private boolean hasAvailableBiomes() {
            for (BiomeDescriptor descriptor : this.descriptors) {
                if (this.workingBiomes.contains(descriptor.id())) continue;
                return true;
            }
            return false;
        }

        private List<BiomeDescriptor> loadDescriptors() {
            ArrayList<BiomeDescriptor> list = new ArrayList<BiomeDescriptor>();
            Registry<Biome> registry = this.resolveBiomeRegistry();
            for (ResourceLocation id : registry.m_6566_()) {
                Component name = this.displayNameFor(id);
                list.add(new BiomeDescriptor(id, name, name.getString().toLowerCase(Locale.ROOT), id.toString().toLowerCase(Locale.ROOT)));
            }
            list.sort(Comparator.comparing(descriptor -> descriptor.displayName().getString()));
            return list;
        }

        private Registry<Biome> resolveBiomeRegistry() {
            ClientPacketListener connection;
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null && mc.f_91073_ != null) {
                return mc.f_91073_.m_9598_().m_175515_(Registries.f_256952_);
            }
            if (mc != null && (connection = mc.m_91403_()) != null) {
                return connection.m_105152_().m_175515_(Registries.f_256952_);
            }
            return RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_).m_175515_(Registries.f_256952_);
        }

        private Component getModeButtonLabel() {
            return Component.m_237115_((String)(this.rawMode ? "gui.hundred_years_war.template_properties.input_mode.list" : "gui.hundred_years_war.template_properties.input_mode.raw"));
        }

        private void toggleRawMode() {
            if (this.rawMode && !this.commitRawInput()) {
                return;
            }
            boolean bl = this.rawMode = !this.rawMode;
            if (this.rawMode) {
                this.rawFeedback = null;
                this.rawDraft = this.serialiseWorkingBiomes();
            }
            if (this.f_96541_ != null) {
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            }
        }

        private String serialiseWorkingBiomes() {
            JsonArray array = new JsonArray();
            this.workingBiomes.forEach(id -> array.add(id.toString()));
            return GSON.toJson((JsonElement)array);
        }

        private boolean commitRawInput() {
            JsonElement parsed;
            if (this.rawInputBox == null) {
                return true;
            }
            String value = this.rawInputBox.m_94155_();
            if (value == null || value.isBlank()) {
                value = "[]";
            }
            if ((parsed = TemplatePropertiesScreen.parseFlexibleJson(value)) == null || !parsed.isJsonArray()) {
                this.rawFeedback = Component.m_237115_((String)"gui.hundred_years_war.template_properties.raw_input_error_format");
                this.rawFeedbackColor = -43691;
                return false;
            }
            ArrayList<ResourceLocation> updated = new ArrayList<ResourceLocation>();
            for (JsonElement element : parsed.getAsJsonArray()) {
                if (element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    ResourceLocation id = ResourceLocation.m_135820_((String)element.getAsString());
                    if (id != null) {
                        if (updated.contains(id)) continue;
                        updated.add(id);
                        continue;
                    }
                    this.rawFeedback = Component.m_237115_((String)"gui.hundred_years_war.template_properties.raw_input_error_entry");
                    this.rawFeedbackColor = -43691;
                    return false;
                }
                this.rawFeedback = Component.m_237115_((String)"gui.hundred_years_war.template_properties.raw_input_error_entry");
                this.rawFeedbackColor = -43691;
                return false;
            }
            this.workingBiomes.clear();
            this.workingBiomes.addAll(updated);
            this.rawDraft = GSON.toJson(parsed);
            this.rawFeedback = Component.m_237115_((String)"gui.hundred_years_war.template_properties.raw_input_applied");
            this.rawFeedbackColor = -11141291;
            this.refreshSelectedList();
            return true;
        }

        public void m_7379_() {
            this.f_96541_.m_91152_((Screen)this.parent);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.rawMode) {
                if (this.rawInputBox != null && this.rawInputBox.m_7933_(keyCode, scanCode, modifiers)) {
                    return true;
                }
                if (keyCode == 257 || keyCode == 335) {
                    this.commitRawInput();
                    return true;
                }
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
            if (this.filterBox != null && this.filterBox.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char chr, int modifiers) {
            if (this.rawMode) {
                if (this.rawInputBox != null && this.rawInputBox.m_5534_(chr, modifiers)) {
                    return true;
                }
                return super.m_5534_(chr, modifiers);
            }
            if (this.filterBox != null && this.filterBox.m_5534_(chr, modifiers)) {
                return true;
            }
            return super.m_5534_(chr, modifiers);
        }

        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(graphics);
            int dialogWidth = 360;
            int dialogHeight = this.dialogHeight();
            int left = (this.f_96543_ - dialogWidth) / 2;
            int top = (this.f_96544_ - dialogHeight) / 2;
            graphics.m_280509_(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
            graphics.m_280509_(left, top, left + dialogWidth, top + dialogHeight, -14671840);
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.biome_blacklist.title"), this.f_96543_ / 2, top + 8, 0xFFFFFF);
            if (this.rawMode) {
                graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.raw_input_label"), left + 16, top + 60, -4473925);
                if (this.rawFeedback != null) {
                    graphics.m_280430_(this.f_96547_, this.rawFeedback, left + 16, top + dialogHeight - 46, this.rawFeedbackColor);
                }
            } else {
                graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.biome_blacklist.selected"), left + 16, top + 57, -5592406);
                if (this.feedback != null) {
                    graphics.m_280430_(this.f_96547_, this.feedback, left + 16, top + dialogHeight - 46, this.feedbackColor);
                }
            }
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }

        private class SelectedBiomeList
        extends ContainerObjectSelectionList<SelectedBiomeEntry> {
            SelectedBiomeList(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
                super(minecraft, width, height, top, bottom, itemHeight);
                this.m_93488_(false);
                this.m_93496_(false);
            }

            protected int m_5756_() {
                return this.f_93393_ + this.f_93388_ - 6;
            }

            public int m_5759_() {
                return this.f_93388_ - 8;
            }

            void setEntries(List<SelectedBiomeEntry> entries) {
                this.m_5988_(entries);
            }
        }

        private class SelectedBiomeEntry
        extends ContainerObjectSelectionList.Entry<SelectedBiomeEntry> {
            private final ResourceLocation id;
            private final Component displayName;
            private final Button removeButton;

            private SelectedBiomeEntry(ResourceLocation id) {
                this.id = id;
                this.displayName = BiomeBlacklistScreen.this.displayNameFor(id);
                this.removeButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), btn -> BiomeBlacklistScreen.this.removeBiome(id)).m_253046_(20, 20).m_253136_();
            }

            public List<? extends GuiEventListener> m_6702_() {
                return List.of(this.removeButton);
            }

            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.removeButton);
            }

            public void m_6311_(@NotNull GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                graphics.m_280509_(left, top, left + width, top + height, hovered ? -12961222 : -14013910);
                graphics.m_280430_(BiomeBlacklistScreen.this.f_96547_, this.displayName, left + 6, top + 6, 0xFFFFFF);
                graphics.m_280430_(BiomeBlacklistScreen.this.f_96547_, (Component)Component.m_237113_((String)this.id.toString()).m_130940_(ChatFormatting.DARK_GRAY), left + 6, top + 16, -5197648);
                this.removeButton.m_264152_(left + width - 24, top + 3);
                this.removeButton.m_88315_(graphics, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.removeButton.m_6375_(mouseX, mouseY, button)) {
                    return true;
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        }

        private class BiomePickerScreen
        extends Screen {
            private final BiomeBlacklistScreen parent;
            private final List<BiomeDescriptor> descriptors;
            private final List<BiomeDescriptor> working;
            private final Set<ResourceLocation> selectedBiomes;
            private EditBox searchBox;
            private BiomeSelectionList selectionList;
            private Button confirmButton;
            private String searchFilter;

            protected BiomePickerScreen(BiomeBlacklistScreen parent, List<BiomeDescriptor> descriptors) {
                super((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.biome_picker.title"));
                this.working = new ArrayList<BiomeDescriptor>();
                this.selectedBiomes = new LinkedHashSet<ResourceLocation>();
                this.searchFilter = "";
                this.parent = parent;
                this.descriptors = descriptors;
            }

            protected void m_7856_() {
                int dialogWidth = 360;
                int dialogHeight = 240;
                int left = (this.f_96543_ - dialogWidth) / 2;
                int top = (this.f_96544_ - dialogHeight) / 2;
                this.searchBox = new EditBox(this.f_96547_, left + 16, top + 34, dialogWidth - 32, 18, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.biome_picker.search_hint"));
                this.searchBox.m_94144_(this.searchFilter);
                this.searchBox.m_94151_(text -> {
                    this.searchFilter = text == null ? "" : text;
                    this.refreshEntries();
                });
                this.m_142416_((GuiEventListener)this.searchBox);
                this.selectionList = new BiomeSelectionList(this.f_96541_, dialogWidth - 32, 150, top + 64, top + 64 + 150, 26);
                this.selectionList.m_93507_(left + 16);
                this.m_142416_((GuiEventListener)this.selectionList);
                this.confirmButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.add"), btn -> this.confirmSelection()).m_252794_(left + dialogWidth - 120, top + dialogHeight - 28).m_253046_(52, 20).m_253136_();
                this.m_142416_((GuiEventListener)this.confirmButton);
                Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.cancel"), btn -> this.m_7379_()).m_252794_(left + dialogWidth - 64, top + dialogHeight - 28).m_253046_(52, 20).m_253136_();
                this.m_142416_((GuiEventListener)cancelButton);
                this.refreshEntries();
            }

            private void refreshEntries() {
                if (this.selectionList == null) {
                    return;
                }
                String filter = this.searchFilter == null ? "" : this.searchFilter.trim().toLowerCase(Locale.ROOT);
                this.working.clear();
                for (BiomeDescriptor descriptor : this.descriptors) {
                    if (this.parent.workingBiomes.contains(descriptor.id()) || !descriptor.matches(filter)) continue;
                    this.working.add(descriptor);
                }
                ArrayList<BiomeSelectionEntry> entries = new ArrayList<BiomeSelectionEntry>();
                for (BiomeDescriptor descriptor : this.working) {
                    entries.add(new BiomeSelectionEntry(descriptor));
                }
                this.selectionList.setEntries(entries);
                this.updateConfirmState();
            }

            private void confirmSelection() {
                if (this.selectedBiomes.isEmpty()) {
                    return;
                }
                ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(this.selectedBiomes);
                this.selectedBiomes.clear();
                for (ResourceLocation id : ids) {
                    this.parent.addBiome(id);
                }
                this.f_96541_.m_91152_((Screen)this.parent);
            }

            private void toggleSelection(ResourceLocation id) {
                if (this.selectedBiomes.contains(id)) {
                    this.selectedBiomes.remove(id);
                } else {
                    this.selectedBiomes.add(id);
                }
                this.updateConfirmState();
            }

            private void updateConfirmState() {
                if (this.confirmButton != null) {
                    this.confirmButton.f_93623_ = !this.selectedBiomes.isEmpty();
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.selectionList != null && this.selectionList.m_6375_(mouseX, mouseY, button)) {
                    this.updateConfirmState();
                    return true;
                }
                return super.m_6375_(mouseX, mouseY, button);
            }

            public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                this.m_280273_(graphics);
                int dialogWidth = 360;
                int dialogHeight = 240;
                int left = (this.f_96543_ - dialogWidth) / 2;
                int top = (this.f_96544_ - dialogHeight) / 2;
                graphics.m_280509_(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
                graphics.m_280509_(left, top, left + dialogWidth, top + dialogHeight, -14671840);
                graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.biome_picker.title"), this.f_96543_ / 2, top + 8, 0xFFFFFF);
                super.m_88315_(graphics, mouseX, mouseY, partialTick);
            }

            public void m_7379_() {
                this.f_96541_.m_91152_((Screen)this.parent);
            }

            private class BiomeSelectionList
            extends ContainerObjectSelectionList<BiomeSelectionEntry> {
                BiomeSelectionList(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
                    super(minecraft, width, height, top, bottom, itemHeight);
                    this.m_93488_(false);
                    this.m_93496_(false);
                }

                protected int m_5756_() {
                    return this.f_93393_ + this.f_93388_ - 6;
                }

                public int m_5759_() {
                    return this.f_93388_ - 8;
                }

                void setEntries(List<BiomeSelectionEntry> entries) {
                    this.m_5988_(entries);
                }
            }

            private class BiomeSelectionEntry
            extends ContainerObjectSelectionList.Entry<BiomeSelectionEntry> {
                private final BiomeDescriptor descriptor;
                private int lastLeft;
                private int lastTop;
                private int lastRight;
                private int lastBottom;

                private BiomeSelectionEntry(BiomeDescriptor descriptor) {
                    this.descriptor = descriptor;
                }

                public List<? extends GuiEventListener> m_6702_() {
                    return List.of();
                }

                public List<? extends NarratableEntry> m_142437_() {
                    return List.of();
                }

                public void m_6311_(@NotNull GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                    this.lastLeft = left;
                    this.lastTop = top;
                    this.lastRight = left + width;
                    this.lastBottom = top + height;
                    boolean selected = BiomePickerScreen.this.selectedBiomes.contains(this.descriptor.id());
                    int color = selected ? (hovered ? -11849937 : -13677777) : (hovered ? -12961222 : -14013910);
                    graphics.m_280509_(left, top, left + width, top + height, color);
                    graphics.m_280430_(BiomePickerScreen.this.f_96547_, this.descriptor.displayName(), left + 6, top + 6, 0xFFFFFF);
                    graphics.m_280430_(BiomePickerScreen.this.f_96547_, (Component)Component.m_237113_((String)this.descriptor.id().toString()).m_130940_(ChatFormatting.DARK_GRAY), left + 6, top + 16, -5197648);
                }

                public boolean m_6375_(double mouseX, double mouseY, int button) {
                    if (button == 0 && mouseX >= (double)this.lastLeft && mouseX <= (double)this.lastRight && mouseY >= (double)this.lastTop && mouseY <= (double)this.lastBottom) {
                        BiomePickerScreen.this.toggleSelection(this.descriptor.id());
                        return true;
                    }
                    return false;
                }
            }
        }

        private record BiomeDescriptor(ResourceLocation id, Component displayName, String lowerName, String lowerId) {
            boolean matches(String filter) {
                if (filter == null || filter.isEmpty()) {
                    return true;
                }
                return this.lowerName.contains(filter) || this.lowerId.contains(filter);
            }
        }
    }

    private class AttributeEditScreen
    extends Screen {
        private final TemplatePropertiesScreen parent;
        private final BasePropertyModel model;
        private final TemplateAttributeDefinition definition;
        private EditBox valueBox;
        private Component localError;

        protected AttributeEditScreen(TemplatePropertiesScreen parent, BasePropertyModel model, TemplateAttributeDefinition definition) {
            super((Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.edit_attribute"));
            this.parent = parent;
            this.model = model;
            this.definition = definition;
        }

        protected void m_7856_() {
            int dialogWidth = 260;
            int dialogHeight = 150;
            int left = (this.f_96543_ - dialogWidth) / 2;
            int top = (this.f_96544_ - dialogHeight) / 2;
            this.valueBox = new EditBox(this.f_96547_, left + 16, top + 95, dialogWidth - 32, 18, (Component)Component.m_237119_());
            this.valueBox.m_94199_(512);
            this.valueBox.m_94144_(GSON.toJson(this.model.getValue()));
            this.m_142416_((GuiEventListener)this.valueBox);
            Button saveButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.save"), btn -> this.attemptSave()).m_252794_(left + dialogWidth - 116, top + dialogHeight - 28).m_253046_(48, 20).m_253136_();
            this.m_142416_((GuiEventListener)saveButton);
            Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.cancel"), btn -> this.m_7379_()).m_252794_(left + dialogWidth - 60, top + dialogHeight - 28).m_253046_(48, 20).m_253136_();
            this.m_142416_((GuiEventListener)cancelButton);
        }

        private void attemptSave() {
            try {
                JsonElement parsed = TemplatePropertiesScreen.parseFlexibleJson(this.valueBox.m_94155_());
                this.model.applyValue(parsed);
                this.parent.onCustomAttributesChanged();
                this.m_7379_();
            }
            catch (IllegalArgumentException e) {
                this.localError = Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.RED);
            }
        }

        public void m_7379_() {
            this.f_96541_.m_91152_((Screen)this.parent);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.valueBox != null && this.valueBox.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.attemptSave();
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char chr, int modifiers) {
            if (this.valueBox != null && this.valueBox.m_5534_(chr, modifiers)) {
                return true;
            }
            return super.m_5534_(chr, modifiers);
        }

        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(graphics);
            int dialogWidth = 260;
            int dialogHeight = 140;
            int left = (this.f_96543_ - dialogWidth) / 2;
            int top = (this.f_96544_ - dialogHeight) / 2;
            graphics.m_280509_(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
            graphics.m_280509_(left, top, left + dialogWidth, top + dialogHeight, -14671840);
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.edit_attribute"), this.f_96543_ / 2, top + 8, 0xFFFFFF);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.attribute_key"), left + 16, top + 32, -4473925);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.model.key()), left + 16, top + 44, 0xFFFFFF);
            if (this.definition != null) {
                MutableComponent typeLabel = Component.m_237110_((String)"gui.hundred_years_war.template_properties.attribute_type", (Object[])new Object[]{TemplatePropertiesScreen.this.getTypeDisplayName(this.definition.getType()).m_6881_().m_130940_(ChatFormatting.AQUA)});
                graphics.m_280430_(this.f_96547_, (Component)typeLabel, left + 16, top + 58, -6250336);
            }
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.template_properties.attribute_value"), left + 16, top + 72, -4473925);
            if (this.localError != null) {
                graphics.m_280430_(this.f_96547_, this.localError, left + 16, top + dialogHeight - 46, -43691);
            }
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }

    public record TemplatePropertiesData(boolean enableGeneration, int generationWeight, int connectionLayerDepth, int minGenerationHeight, int maxGenerationHeight, boolean generateOnSurface, Map<String, JsonElement> customAttributes) {
    }

    private static class ScrollingTextRenderer
    extends AbstractWidget {
        private ScrollingTextRenderer() {
            super(0, 0, 0, 0, (Component)Component.m_237119_());
        }

        static void render(GuiGraphics graphics, Font font, Component text, int left, int top, int right, int bottom, int color) {
            ScrollingTextRenderer.m_280138_((GuiGraphics)graphics, (Font)font, (Component)text, (int)left, (int)top, (int)right, (int)bottom, (int)color);
        }

        protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        }

        protected void m_168797_(@NotNull NarrationElementOutput narrationElementOutput) {
        }
    }
}

