/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.handler;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import ydmsama.hundred_years_war.client.gui.BuildingPlaceScreen;
import ydmsama.hundred_years_war.client.gui.BuildingSaveScreen;
import ydmsama.hundred_years_war.client.gui.PlaceholderFillScreen;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.network.packets.BuildingToolActionPacket;

public class BuildingToolClientHandler {
    public static void handleRightClick(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BuildingToolItem)) {
            return;
        }
        BuildingToolItem.Mode mode = BuildingToolItem.getMode(stack);
        if (mode == BuildingToolItem.Mode.SAVE) {
            BuildingToolClientHandler.handleSaveUndo(stack);
        } else if (mode == BuildingToolItem.Mode.PLACE) {
            BuildingToolClientHandler.openBuildingSelectionUI(stack);
        } else if (mode == BuildingToolItem.Mode.FILL) {
            BuildingToolClientHandler.handleFillUndoRightClick(stack);
        }
    }

    public static void switchMode(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof BuildingToolItem) {
            ClientPacketHandler.sendBuildingToolSwitchMode();
            BuildingToolItem.Mode currentMode = BuildingToolItem.getMode(stack);
            BuildingToolItem.Mode newMode = currentMode.next();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.mode_switched").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)newMode.getDisplayName().m_130940_(newMode.getColor())), true);
            }
        }
    }

    public static void handleKeyPress(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof BuildingToolItem) {
            BuildingToolItem.Mode mode = BuildingToolItem.getMode(stack);
            if (mode == BuildingToolItem.Mode.SAVE) {
                BuildingToolClientHandler.handleSaveMode(stack);
            } else if (mode == BuildingToolItem.Mode.PLACE) {
                BuildingToolClientHandler.handlePlaceMode(stack);
            } else if (mode == BuildingToolItem.Mode.FILL) {
                BuildingToolClientHandler.handleFillMode(stack);
            }
        }
    }

    private static void handleSaveMode(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        BuildingToolItem.SaveState state = BuildingToolItem.getSaveState(stack);
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        BlockPos pos = null;
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            pos = ((BlockHitResult)hitResult).m_82425_();
        } else if (hitResult.m_6662_() == HitResult.Type.MISS) {
            pos = new BlockPos((int)Math.floor(hitResult.m_82450_().f_82479_), (int)Math.floor(hitResult.m_82450_().f_82480_), (int)Math.floor(hitResult.m_82450_().f_82481_));
        }
        if (pos != null) {
            switch (state) {
                case NONE: {
                    ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_FIRST_POS, pos);
                    player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_tool.set_first_pos", (Object[])new Object[]{pos.m_123344_()}).m_130940_(ChatFormatting.GREEN), true);
                    break;
                }
                case FIRST_POS: {
                    ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_SECOND_POS, pos);
                    player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_tool.set_second_pos", (Object[])new Object[]{pos.m_123344_()}).m_130940_(ChatFormatting.RED), true);
                    break;
                }
                case SECOND_POS: {
                    ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_ENTRANCE_POS, pos);
                    player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_tool.set_entrance_pos", (Object[])new Object[]{pos.m_123344_()}).m_130940_(ChatFormatting.BLUE), true);
                    break;
                }
                case READY_TO_SAVE: {
                    BuildingToolClientHandler.openSaveUI(stack);
                }
            }
        }
    }

    private static void handleFillMode(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        BuildingToolItem.FillState state = BuildingToolItem.getFillState(stack);
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        BlockPos pos = null;
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            pos = ((BlockHitResult)hitResult).m_82425_();
        } else if (hitResult.m_6662_() == HitResult.Type.MISS) {
            pos = new BlockPos((int)Math.floor(hitResult.m_82450_().f_82479_), (int)Math.floor(hitResult.m_82450_().f_82480_), (int)Math.floor(hitResult.m_82450_().f_82481_));
        }
        if (pos == null) {
            return;
        }
        switch (state) {
            case NONE: {
                ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_FILL_FIRST_POS, pos);
                player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_tool.fill_set_first_pos", (Object[])new Object[]{pos.m_123344_()}).m_130940_(ChatFormatting.GOLD), true);
                break;
            }
            case FIRST_POS: {
                ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_FILL_SECOND_POS, pos);
                player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_tool.fill_set_second_pos", (Object[])new Object[]{pos.m_123344_()}).m_130940_(ChatFormatting.GOLD), true);
                break;
            }
            case SECOND_POS: {
                BuildingToolClientHandler.openFillUI(stack);
            }
        }
    }

    private static void handleSaveUndo(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        BuildingToolItem.SaveState state = BuildingToolItem.getSaveState(stack);
        switch (state) {
            case NONE: {
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.nothing_to_undo").m_130940_(ChatFormatting.YELLOW), true);
                break;
            }
            case FIRST_POS: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_FIRST_POS);
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.undo_first_pos").m_130940_(ChatFormatting.YELLOW), true);
                break;
            }
            case SECOND_POS: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_SECOND_POS);
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.undo_second_pos").m_130940_(ChatFormatting.YELLOW), true);
                break;
            }
            case READY_TO_SAVE: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_ENTRANCE_POS);
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.undo_entrance_pos").m_130940_(ChatFormatting.YELLOW), true);
            }
        }
    }

    private static void handleFillUndoRightClick(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        BuildingToolItem.FillState state = BuildingToolItem.getFillState(stack);
        switch (state) {
            case NONE: {
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.fill_nothing_to_undo").m_130940_(ChatFormatting.YELLOW), true);
                break;
            }
            case FIRST_POS: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_FILL_FIRST_POS);
                BuildingToolItem.resetFillState(stack);
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.fill_undo_first").m_130940_(ChatFormatting.YELLOW), true);
                break;
            }
            case SECOND_POS: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_FILL_SECOND_POS);
                BuildingToolItem.setFillSecondPos(stack, null);
                BuildingToolItem.setFillState(stack, BuildingToolItem.FillState.FIRST_POS);
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.fill_undo_second").m_130940_(ChatFormatting.YELLOW), true);
            }
        }
    }

    private static void handlePlaceMode(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        String selectedTemplateData = BuildingToolItem.getSelectedTemplate(stack);
        if (selectedTemplateData == null || selectedTemplateData.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.no_template_selected").m_130940_(ChatFormatting.RED), true);
            return;
        }
        String[] parts = selectedTemplateData.split("\\|");
        String templateName = parts[0];
        int rotation = 0;
        long buildTime = 0L;
        boolean generateConnectionLayer = false;
        boolean terrainCheck = false;
        try {
            rotation = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            buildTime = parts.length > 2 ? Long.parseLong(parts[2]) : 0L;
            generateConnectionLayer = parts.length > 3 && Boolean.parseBoolean(parts[3]);
            terrainCheck = parts.length > 4 && Boolean.parseBoolean(parts[4]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        HitResult hitResult = player.m_19907_(200.0, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)hitResult).m_82425_();
            ClientPacketHandler.sendBuildingToolPlaceBuilding(pos, templateName, rotation, buildTime, generateConnectionLayer, terrainCheck);
            player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_tool.placing_template", (Object[])new Object[]{templateName}).m_130940_(ChatFormatting.GREEN), true);
        }
    }

    private static void openBuildingSelectionUI(ItemStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.execute(() -> minecraft.m_91152_((Screen)new BuildingPlaceScreen(stack)));
    }

    private static void openSaveUI(ItemStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.execute(() -> minecraft.m_91152_((Screen)new BuildingSaveScreen(stack)));
    }

    private static void openFillUI(ItemStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null) {
            minecraft.m_91152_((Screen)new PlaceholderFillScreen(stack));
        }
    }
}

