/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.models.siege;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.entities.siege.TrebuchetsEntity;

public class TrebuchetsCartModel
extends HierarchicalModel<TrebuchetsEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("hundred_years_war", "trebuchets_cart"), "main");
    private final ModelPart parts;
    private static final Map<UUID, WheelRotationData> entityWheelRotations = new HashMap<UUID, WheelRotationData>();
    private static final long UPDATE_INTERVAL_MS = 10L;

    public TrebuchetsCartModel(ModelPart root) {
        this.parts = root.m_171324_("parts");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition parts = partdefinition.m_171599_("parts", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-20.9203f, (float)21.2f, (float)-21.0797f));
        PartDefinition trebuchets = parts.m_171599_("trebuchets", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-59.0f, (float)0.0f));
        PartDefinition support1 = trebuchets.m_171599_("support1", CubeListBuilder.m_171558_().m_171514_(1024, 0).m_171488_(20.9203f, 34.8f, -67.9203f, 4.0f, 4.0f, 172.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = support1.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(1552, 273).m_171488_(-2.0f, -1.0f, -31.0f, 4.0f, 2.0f, 61.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)29.0f, (float)38.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)0.0f));
        PartDefinition cube_r2 = support1.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(1024, 441).m_171488_(-2.0f, -1.0f, -63.0f, 4.0f, 2.0f, 93.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)34.0f, (float)38.0f, (float)15.0f, (float)0.0f, (float)3.098f, (float)0.0f));
        PartDefinition cube_r3 = support1.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(1516, 432).m_171488_(-2.0f, -1.0f, -63.0f, 4.0f, 2.0f, 93.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)22.0f, (float)32.0f, (float)11.0f, (float)0.0f, (float)3.0543f, (float)0.0f));
        PartDefinition cube_r4 = support1.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(1552, 336).m_171488_(-2.0f, -1.0f, -31.0f, 4.0f, 2.0f, 61.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)33.0f, (float)36.0f, (float)36.0f, (float)0.0f, (float)-0.0436f, (float)0.0f));
        PartDefinition cube_r5 = support1.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(1024, 176).m_171488_(-2.0f, -2.0f, -67.0f, 4.0f, 4.0f, 134.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.9203f, (float)36.8f, (float)21.0797f, (float)0.0f, (float)-3.098f, (float)0.0f));
        PartDefinition right_main_support = support1.m_171599_("right_main_support", CubeListBuilder.m_171558_().m_171514_(1270, 314).m_171488_(16.5263f, -58.7154f, -2.3f, 5.0f, 78.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(1256, 559).m_171488_(17.5263f, 10.2846f, -23.3f, 5.0f, 3.0f, 52.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-16.606f, (float)22.5154f, (float)40.3797f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = right_main_support.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(1552, 415).m_171488_(-10.0f, 0.0f, 1.2f, 40.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9599f));
        PartDefinition cube_r7 = right_main_support.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(1670, 527).m_171488_(-14.0f, -1.5f, -3.0f, 22.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.6163f, (float)9.9153f, (float)3.2f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition cube_r8 = right_main_support.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(1622, 56).m_171488_(-1.0f, -2.0f, -26.0f, 2.0f, 4.0f, 52.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)18.4263f, (float)-10.9308f, (float)14.8287f, (float)-1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = right_main_support.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(1622, 0).m_171488_(-1.0f, -2.0f, -26.0f, 2.0f, 4.0f, 52.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)18.4263f, (float)-10.9308f, (float)-9.1713f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition left_main_support = trebuchets.m_171599_("left_main_support", CubeListBuilder.m_171558_().m_171514_(1218, 441).m_171488_(-21.5263f, -58.7154f, -2.3f, 5.0f, 78.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(1370, 559).m_171488_(-22.5263f, 10.2846f, -23.3f, 5.0f, 3.0f, 52.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)58.4466f, (float)21.5154f, (float)41.3797f, (float)1.7017f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = left_main_support.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(1552, 421).m_171488_(-30.0f, 0.0f, 1.2f, 40.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9599f));
        PartDefinition cube_r11 = left_main_support.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(1670, 535).m_171488_(-8.0f, -1.5f, -3.0f, 22.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.6163f, (float)9.9153f, (float)3.2f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition cube_r12 = left_main_support.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(1132, 604).m_171488_(-1.0f, -2.0f, -26.0f, 2.0f, 4.0f, 52.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-18.4263f, (float)-10.9308f, (float)14.8287f, (float)-1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = left_main_support.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(1024, 604).m_171488_(-1.0f, -2.0f, -26.0f, 2.0f, 4.0f, 52.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-18.4263f, (float)-10.9308f, (float)-9.1713f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition rail = trebuchets.m_171599_("rail", CubeListBuilder.m_171558_().m_171514_(1552, 399).m_171488_(-25.7f, 0.5f, -58.0f, 42.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(1300, 176).m_171488_(-13.7f, -1.5f, -63.0f, 2.0f, 4.0f, 124.0f, new CubeDeformation(0.0f)).m_171514_(1552, 407).m_171488_(-25.7f, 0.5f, -25.0f, 42.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(1300, 304).m_171488_(2.3f, -1.5f, -63.0f, 2.0f, 4.0f, 124.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)25.6203f, (float)32.3f, (float)16.0797f));
        PartDefinition cube_r14 = rail.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(1376, 0).m_171488_(-1.0f, -2.0f, -62.0f, 1.0f, 5.0f, 122.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition cube_r15 = rail.m_171599_("cube_r15", CubeListBuilder.m_171558_().m_171514_(1270, 432).m_171488_(0.0f, -2.0f, -62.0f, 1.0f, 5.0f, 122.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition cube_r16 = rail.m_171599_("cube_r16", CubeListBuilder.m_171558_().m_171514_(1024, 314).m_171488_(0.0f, -2.0f, -62.0f, 1.0f, 5.0f, 122.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.2f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition main_roll = trebuchets.m_171599_("main_roll", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)20.4203f, (float)-67.2f, (float)21.0797f));
        PartDefinition cube_r17 = main_roll.m_171599_("cube_r17", CubeListBuilder.m_171558_().m_171514_(1376, 168).m_171488_(-22.5f, -2.0f, -2.0f, 45.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)96.0f, (float)10.0f, (float)0.0f, (float)1.6581f, (float)0.0f));
        PartDefinition main_roll2 = main_roll.m_171599_("main_roll2", CubeListBuilder.m_171558_().m_171514_(1622, 112).m_171488_(-12.5f, -3.0f, -3.0f, 26.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(1648, 399).m_171488_(-4.5f, -5.0f, -11.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(0.0f)).m_171514_(1516, 527).m_171488_(-3.5f, -4.0f, 11.0f, 8.0f, 8.0f, 69.0f, new CubeDeformation(0.0f)).m_171514_(1552, 127).m_171488_(-2.5f, -3.0f, 80.0f, 6.0f, 6.0f, 69.0f, new CubeDeformation(0.0f)).m_171514_(1538, 643).m_171488_(-10.5f, -7.0f, -7.0f, 22.0f, 14.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(1538, 643).m_171488_(-10.5f, -7.0f, 5.0f, 22.0f, 14.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(1538, 643).m_171488_(-10.5f, -7.0f, 19.0f, 22.0f, 14.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(1024, 536).m_171488_(-6.5f, -6.0f, -12.0f, 2.0f, 12.0f, 56.0f, new CubeDeformation(0.0f)).m_171514_(1376, 127).m_171488_(-8.5f, -4.0f, -9.0f, 2.0f, 8.0f, 33.0f, new CubeDeformation(0.0f)).m_171514_(1248, 441).m_171488_(-6.5f, -5.0f, -17.0f, 2.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(1140, 536).m_171488_(5.5f, -6.0f, -12.0f, 2.0f, 12.0f, 56.0f, new CubeDeformation(0.0f)).m_171514_(1248, 456).m_171488_(5.5f, -5.0f, -17.0f, 2.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(1252, 499).m_171488_(5.5f, -4.0f, -20.0f, 2.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(1252, 510).m_171488_(-6.5f, -4.0f, -20.0f, 2.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(1446, 127).m_171488_(7.5f, -4.0f, -9.0f, 2.0f, 8.0f, 33.0f, new CubeDeformation(0.0f)).m_171514_(1474, 168).m_171488_(-13.5f, -1.5f, -18.0f, 28.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-10.0f, (float)93.0f, (float)-61.0f));
        PartDefinition roll_weight = main_roll.m_171599_("roll_weight", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)-16.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition bone = roll_weight.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(1484, 604).m_171488_(-4.5f, -12.5f, -11.5f, 9.0f, 16.0f, 23.0f, new CubeDeformation(0.0f)).m_171514_(1664, 637).m_171488_(-4.5f, 3.5f, -8.5f, 9.0f, 2.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.7451f, (float)94.8634f, (float)-5.0f, (float)0.1062f, (float)-0.294f, (float)-0.9702f));
        PartDefinition bone2 = roll_weight.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(1612, 637).m_171488_(-4.5f, 3.5f, -8.5f, 9.0f, 2.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(1548, 604).m_171488_(-4.5f, -12.5f, -11.5f, 9.0f, 16.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.9843f, (float)84.0389f, (float)-28.0f, (float)-0.0436f, (float)-0.2618f, (float)-1.1345f));
        PartDefinition cart = parts.m_171599_("cart", CubeListBuilder.m_171558_().m_171514_(0, 200).m_171488_(-27.0f, -4.4f, -49.7f, 5.0f, 9.0f, 99.0f, new CubeDeformation(0.0f)).m_171514_(0, 92).m_171488_(22.0f, -4.4f, -49.7f, 5.0f, 9.0f, 99.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-25.0f, -5.4f, -44.7f, 49.0f, 3.0f, 89.0f, new CubeDeformation(0.0f)).m_171514_(208, 92).m_171488_(16.5f, -6.4f, -44.7f, 7.0f, 1.0f, 89.0f, new CubeDeformation(0.0f)).m_171514_(208, 182).m_171488_(8.5f, -6.4f, -44.7f, 7.0f, 1.0f, 89.0f, new CubeDeformation(0.0f)).m_171514_(208, 272).m_171488_(0.5f, -6.4f, -44.7f, 7.0f, 1.0f, 89.0f, new CubeDeformation(0.0f)).m_171514_(276, 0).m_171488_(-7.5f, -6.4f, -44.7f, 7.0f, 1.0f, 89.0f, new CubeDeformation(0.0f)).m_171514_(0, 308).m_171488_(-15.5f, -6.4f, -44.7f, 7.0f, 1.0f, 89.0f, new CubeDeformation(0.0f)).m_171514_(192, 362).m_171488_(-23.5f, -6.4f, -44.7f, 7.0f, 1.0f, 89.0f, new CubeDeformation(0.0f)).m_171514_(400, 282).m_171488_(-29.0f, -2.4f, -36.7f, 58.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(400, 298).m_171488_(-29.0f, -2.4f, 30.3f, 58.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)20.9203f, (float)-13.8f, (float)21.7797f));
        PartDefinition wheel_r2 = cart.m_171599_("wheel_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(548, 317).m_171488_(-2.5f, -5.0f, -12.5f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-31.7273f, (float)4.6771f, (float)33.3691f));
        PartDefinition cube_r18 = wheel_r2.m_171599_("cube_r18", CubeListBuilder.m_171558_().m_171514_(552, 528).m_171488_(-2.5f, -7.8284f, -9.6716f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = wheel_r2.m_171599_("cube_r19", CubeListBuilder.m_171558_().m_171514_(552, 493).m_171488_(-2.5f, -5.0f, -8.5f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r20 = wheel_r2.m_171599_("cube_r20", CubeListBuilder.m_171558_().m_171514_(552, 458).m_171488_(-2.5f, -2.1716f, -9.6716f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wheel_r1 = cart.m_171599_("wheel_r1", CubeListBuilder.m_171558_().m_171514_(180, 548).m_171488_(-2.5f, -5.0f, -12.5f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-31.7273f, (float)4.6771f, (float)-33.6309f));
        PartDefinition cube_r21 = wheel_r1.m_171599_("cube_r21", CubeListBuilder.m_171558_().m_171514_(300, 548).m_171488_(-2.5f, -7.8284f, -9.6716f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r22 = wheel_r1.m_171599_("cube_r22", CubeListBuilder.m_171558_().m_171514_(548, 282).m_171488_(-2.5f, -5.0f, -8.5f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r23 = wheel_r1.m_171599_("cube_r23", CubeListBuilder.m_171558_().m_171514_(240, 548).m_171488_(-2.5f, -2.1716f, -9.6716f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wheel_l2 = cart.m_171599_("wheel_l2", CubeListBuilder.m_171558_().m_171514_(60, 529).m_171488_(-2.5f, -5.0f, -12.5f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(2.0f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)31.2727f, (float)4.6771f, (float)33.3691f));
        PartDefinition cube_r24 = wheel_l2.m_171599_("cube_r24", CubeListBuilder.m_171558_().m_171514_(542, 35).m_171488_(-2.5f, -7.8284f, -9.6716f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r25 = wheel_l2.m_171599_("cube_r25", CubeListBuilder.m_171558_().m_171514_(542, 0).m_171488_(-2.5f, -5.0f, -8.5f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r26 = wheel_l2.m_171599_("cube_r26", CubeListBuilder.m_171558_().m_171514_(120, 529).m_171488_(-2.5f, -2.1716f, -9.6716f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wheel_l1 = cart.m_171599_("wheel_l1", CubeListBuilder.m_171558_().m_171514_(0, 494).m_171488_(-2.5f, -5.0f, -12.5f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(2.0f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)31.2727f, (float)4.6771f, (float)-33.6309f, (float)1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r27 = wheel_l1.m_171599_("cube_r27", CubeListBuilder.m_171558_().m_171514_(0, 529).m_171488_(-2.5f, -7.8284f, -9.6716f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r28 = wheel_l1.m_171599_("cube_r28", CubeListBuilder.m_171558_().m_171514_(120, 494).m_171488_(-2.5f, -5.0f, -8.5f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r29 = wheel_l1.m_171599_("cube_r29", CubeListBuilder.m_171558_().m_171514_(60, 494).m_171488_(-2.5f, -2.1716f, -9.6716f, 5.0f, 10.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightWall = cart.m_171599_("rightWall", CubeListBuilder.m_171558_().m_171514_(322, 583).m_171488_(-1.0f, -15.0f, -86.0f, 3.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(384, 362).m_171488_(-2.0f, -14.0f, -86.0f, 1.0f, 5.0f, 91.0f, new CubeDeformation(0.0f)).m_171514_(0, 398).m_171488_(-2.0f, -8.0f, -86.0f, 1.0f, 5.0f, 91.0f, new CubeDeformation(0.0f)).m_171514_(400, 90).m_171488_(-2.0f, -2.0f, -86.0f, 1.0f, 5.0f, 91.0f, new CubeDeformation(0.0f)).m_171514_(306, 583).m_171488_(-1.0f, -15.0f, -26.0f, 3.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(192, 308).m_171488_(-1.0f, -15.0f, 0.0f, 3.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(290, 583).m_171488_(-1.0f, -15.0f, -60.0f, 3.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)26.0f, (float)-8.4f, (float)40.3f));
        PartDefinition cube_r30 = rightWall.m_171599_("cube_r30", CubeListBuilder.m_171558_().m_171514_(568, 352).m_171488_(-0.5f, -1.5f, -14.0f, 1.0f, 3.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-4.0253f, (float)-10.6268f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r31 = rightWall.m_171599_("cube_r31", CubeListBuilder.m_171558_().m_171514_(116, 564).m_171488_(-0.5f, -1.5f, -14.0f, 1.0f, 3.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-4.0253f, (float)-10.6268f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r32 = rightWall.m_171599_("cube_r32", CubeListBuilder.m_171558_().m_171514_(468, 0).m_171488_(-0.5f, -1.5f, -18.0f, 1.0f, 3.0f, 36.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-4.0253f, (float)-40.6268f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r33 = rightWall.m_171599_("cube_r33", CubeListBuilder.m_171558_().m_171514_(400, 314).m_171488_(-0.5f, -1.5f, -18.0f, 1.0f, 3.0f, 36.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-4.0253f, (float)-40.6268f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r34 = rightWall.m_171599_("cube_r34", CubeListBuilder.m_171558_().m_171514_(58, 564).m_171488_(-0.5f, -1.5f, -14.0f, 1.0f, 3.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-4.0253f, (float)-70.6268f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r35 = rightWall.m_171599_("cube_r35", CubeListBuilder.m_171558_().m_171514_(0, 564).m_171488_(-0.5f, -1.5f, -14.0f, 1.0f, 3.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-4.0253f, (float)-70.6268f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightWall2 = cart.m_171599_("rightWall2", CubeListBuilder.m_171558_().m_171514_(338, 583).m_171488_(-0.8077f, -11.5652f, -45.4415f, 3.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(400, 186).m_171488_(-1.8077f, -10.5652f, -45.4415f, 1.0f, 5.0f, 91.0f, new CubeDeformation(0.0f)).m_171514_(184, 452).m_171488_(-1.8077f, -4.5652f, -45.4415f, 1.0f, 5.0f, 91.0f, new CubeDeformation(0.0f)).m_171514_(368, 458).m_171488_(-1.8077f, 1.4348f, -45.4415f, 1.0f, 5.0f, 91.0f, new CubeDeformation(0.0f)).m_171514_(584, 70).m_171488_(-0.8077f, -11.5652f, 14.5585f, 3.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(584, 103).m_171488_(-0.8077f, -11.5652f, 40.5585f, 3.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(584, 136).m_171488_(-0.8077f, -11.5652f, -19.4415f, 3.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-25.6923f, (float)-11.8348f, (float)-0.2585f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r36 = rightWall2.m_171599_("cube_r36", CubeListBuilder.m_171558_().m_171514_(232, 583).m_171488_(-0.5f, -1.5f, -14.0f, 1.0f, 3.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.3077f, (float)-0.5905f, (float)29.9317f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r37 = rightWall2.m_171599_("cube_r37", CubeListBuilder.m_171558_().m_171514_(174, 583).m_171488_(-0.5f, -1.5f, -14.0f, 1.0f, 3.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.6923f, (float)-0.5905f, (float)29.9317f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r38 = rightWall2.m_171599_("cube_r38", CubeListBuilder.m_171558_().m_171514_(474, 314).m_171488_(-0.5f, -1.5f, -18.0f, 1.0f, 3.0f, 36.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.3077f, (float)-0.5905f, (float)-0.0683f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r39 = rightWall2.m_171599_("cube_r39", CubeListBuilder.m_171558_().m_171514_(468, 39).m_171488_(-0.5f, -1.5f, -18.0f, 1.0f, 3.0f, 36.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.6923f, (float)-0.5905f, (float)-0.0683f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r40 = rightWall2.m_171599_("cube_r40", CubeListBuilder.m_171558_().m_171514_(568, 414).m_171488_(-0.5f, -1.5f, -14.0f, 1.0f, 3.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.3077f, (float)-0.5905f, (float)-30.0683f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r41 = rightWall2.m_171599_("cube_r41", CubeListBuilder.m_171558_().m_171514_(568, 383).m_171488_(-0.5f, -1.5f, -14.0f, 1.0f, 3.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.6923f, (float)-0.5905f, (float)-30.0683f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)2048, (int)2048);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.parts;
    }

    public void setupAnim(TrebuchetsEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean shouldUpdate;
        UUID entityId = entity.m_20148_();
        WheelRotationData rotationData = entityWheelRotations.computeIfAbsent(entityId, id -> new WheelRotationData());
        double velocityX = entity.m_20184_().f_82479_;
        double velocityZ = entity.m_20184_().f_82481_;
        double speedSq = velocityX * velocityX + velocityZ * velocityZ;
        double speedThreshold = 1.0E-4;
        float leftWheelRotationToAdd = 0.0f;
        float rightWheelRotationToAdd = 0.0f;
        long currentTime = System.currentTimeMillis();
        long timeDelta = currentTime - rotationData.lastUpdateTime;
        boolean bl = shouldUpdate = timeDelta >= 10L;
        if (shouldUpdate) {
            rotationData.lastUpdateTime = currentTime;
            if (speedSq > speedThreshold) {
                rotationDifference = Mth.m_14177_((float)(entity.f_20883_ - entity.f_20884_));
                wheelRotationSpeed = -((float)Math.sqrt(speedSq)) * 35.0f;
                if ((double)rotationDifference > 0.1) {
                    leftWheelRotationToAdd = 1.25f * wheelRotationSpeed;
                    rightWheelRotationToAdd = 0.5f * wheelRotationSpeed;
                } else if ((double)rotationDifference < -0.1) {
                    leftWheelRotationToAdd = 0.5f * wheelRotationSpeed;
                    rightWheelRotationToAdd = 1.25f * wheelRotationSpeed;
                } else {
                    leftWheelRotationToAdd = wheelRotationSpeed;
                    rightWheelRotationToAdd = wheelRotationSpeed;
                }
            } else {
                rotationDifference = Mth.m_14177_((float)(entity.f_20883_ - entity.f_20884_));
                wheelRotationSpeed = -((float)Math.sqrt(Math.abs(rotationDifference * 1.0f)));
                if ((double)rotationDifference > 0.1) {
                    leftWheelRotationToAdd = wheelRotationSpeed;
                    rightWheelRotationToAdd = -wheelRotationSpeed;
                } else if ((double)rotationDifference < -0.1) {
                    leftWheelRotationToAdd = -wheelRotationSpeed;
                    rightWheelRotationToAdd = wheelRotationSpeed;
                }
            }
            rotationData.leftWheelRotation += leftWheelRotationToAdd;
            rotationData.rightWheelRotation += rightWheelRotationToAdd;
        }
        ModelPart wheelLeft1 = this.parts.m_171324_("cart").m_171324_("wheel_l1");
        ModelPart wheelLeft2 = this.parts.m_171324_("cart").m_171324_("wheel_l2");
        ModelPart wheelRight1 = this.parts.m_171324_("cart").m_171324_("wheel_r1");
        ModelPart wheelRight2 = this.parts.m_171324_("cart").m_171324_("wheel_r2");
        wheelLeft1.f_104203_ = -rotationData.leftWheelRotation * 0.0174533f;
        wheelLeft2.f_104203_ = -rotationData.leftWheelRotation * 0.0174533f;
        wheelRight1.f_104203_ = -rotationData.rightWheelRotation * 0.0174533f;
        wheelRight2.f_104203_ = -rotationData.rightWheelRotation * 0.0174533f;
    }

    public static void clearUnusedEntities() {
        entityWheelRotations.clear();
    }

    private static class WheelRotationData {
        public float leftWheelRotation = 0.0f;
        public float rightWheelRotation = 0.0f;
        public long lastUpdateTime = 0L;

        private WheelRotationData() {
        }
    }
}

