/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ydmsama.hundred_years_war.client.render.BuildingPreviewRenderer;
import ydmsama.hundred_years_war.client.render.PlacedBuildingRenderer;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;

@Mod.EventBusSubscriber(modid="hundred_years_war", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BuildingToolRenderer {
    public static void register() {
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Minecraft minecraft = Minecraft.m_91087_();
            BuildingToolRenderer.render(event.getPoseStack(), (MultiBufferSource)minecraft.m_91269_().m_110104_(), event.getPartialTick());
        }
    }

    private static void render(PoseStack poseStack, MultiBufferSource bufferSource, float tickDelta) {
        boolean holdingSpawnPoint;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
            return;
        }
        Vec3 cameraPos = minecraft.f_91063_.m_109153_().m_90583_();
        PlacedBuildingRenderer.getInstance().renderBuildings(poseStack, bufferSource, cameraPos);
        ItemStack mainHand = minecraft.f_91074_.m_21205_();
        ItemStack offHand = minecraft.f_91074_.m_21206_();
        boolean holdingBuildingTool = mainHand.m_41720_() instanceof BuildingToolItem;
        boolean holdingPlaceholder = mainHand.m_150930_(((Block)ModBlocks.PLACEHOLDER_BLOCK.get()).m_5456_()) || offHand.m_150930_(((Block)ModBlocks.PLACEHOLDER_BLOCK.get()).m_5456_());
        boolean bl = holdingSpawnPoint = mainHand.m_150930_(((Block)ModBlocks.SPAWN_POINT.get()).m_5456_()) || offHand.m_150930_(((Block)ModBlocks.SPAWN_POINT.get()).m_5456_());
        if (holdingBuildingTool) {
            BuildingToolItem.Mode mode = BuildingToolItem.getMode(mainHand);
            if (mode == BuildingToolItem.Mode.SAVE) {
                BuildingToolRenderer.renderSaveMode(poseStack, bufferSource, mainHand, (Player)minecraft.f_91074_, cameraPos);
            } else if (mode == BuildingToolItem.Mode.PLACE) {
                BuildingToolRenderer.renderPlaceMode(poseStack, bufferSource, mainHand, (Player)minecraft.f_91074_, cameraPos);
            } else if (mode == BuildingToolItem.Mode.FILL) {
                BuildingToolRenderer.renderFillMode(poseStack, bufferSource, mainHand, (Player)minecraft.f_91074_, cameraPos);
            }
        }
        if (holdingBuildingTool || holdingPlaceholder) {
            BuildingToolRenderer.renderPlaceholderMarkers(poseStack, bufferSource, (Player)minecraft.f_91074_, cameraPos, holdingBuildingTool);
        }
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)bufferSource).m_109911_();
        }
    }

    private static void renderFillMode(PoseStack poseStack, MultiBufferSource bufferSource, ItemStack stack, Player player, Vec3 cameraPos) {
        BuildingToolItem.FillState state = BuildingToolItem.getFillState(stack);
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        BlockPos currentPos = null;
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            currentPos = ((BlockHitResult)hitResult).m_82425_();
        } else if (hitResult.m_6662_() == HitResult.Type.MISS) {
            currentPos = new BlockPos((int)Math.floor(hitResult.m_82450_().f_82479_), (int)Math.floor(hitResult.m_82450_().f_82480_), (int)Math.floor(hitResult.m_82450_().f_82481_));
        }
        BlockPos firstPos = BuildingToolItem.getFillFirstPos(stack);
        BlockPos secondPos = BuildingToolItem.getFillSecondPos(stack);
        switch (state) {
            case NONE: {
                if (currentPos == null) break;
                BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 1.0f, 1.0f, 0.0f, 1.0f);
                break;
            }
            case FIRST_POS: {
                if (firstPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, firstPos, cameraPos, 1.0f, 1.0f, 0.0f, 1.0f);
                }
                if (currentPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 1.0f, 0.6f, 0.0f, 1.0f);
                }
                if (firstPos == null || currentPos == null) break;
                BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, currentPos, cameraPos, 1.0f, 1.0f, 0.0f, 0.6f);
                break;
            }
            case SECOND_POS: {
                if (firstPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, firstPos, cameraPos, 1.0f, 1.0f, 0.0f, 1.0f);
                }
                if (secondPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, secondPos, cameraPos, 1.0f, 1.0f, 0.0f, 1.0f);
                }
                if (firstPos == null || secondPos == null) break;
                BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, secondPos, cameraPos, 1.0f, 1.0f, 0.0f, 0.6f);
            }
        }
    }

    private static void renderPlaceholderMarkers(PoseStack poseStack, MultiBufferSource bufferSource, Player player, Vec3 cameraPos, boolean holdingBuildingTool) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        int radius = holdingBuildingTool ? 16 : 12;
        BlockPos center = player.m_20183_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean rendered = false;
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.m_122178_(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                    if (!minecraft.f_91073_.m_8055_((BlockPos)mutablePos).m_60713_((Block)ModBlocks.PLACEHOLDER_BLOCK.get())) continue;
                    rendered = true;
                    double minX = (double)mutablePos.m_123341_() + 0.35;
                    double minY = (double)mutablePos.m_123342_() + 0.35;
                    double minZ = (double)mutablePos.m_123343_() + 0.35;
                    double maxX = (double)mutablePos.m_123341_() + 0.65;
                    double maxY = (double)mutablePos.m_123342_() + 0.65;
                    double maxZ = (double)mutablePos.m_123343_() + 0.65;
                    LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
                }
            }
        }
        poseStack.m_85849_();
    }

    private static void renderSaveMode(PoseStack poseStack, MultiBufferSource bufferSource, ItemStack stack, Player player, Vec3 cameraPos) {
        BuildingToolItem.SaveState state = BuildingToolItem.getSaveState(stack);
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        BlockPos currentPos = null;
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            currentPos = ((BlockHitResult)hitResult).m_82425_();
        } else if (hitResult.m_6662_() == HitResult.Type.MISS) {
            currentPos = new BlockPos((int)Math.floor(hitResult.m_82450_().f_82479_), (int)Math.floor(hitResult.m_82450_().f_82480_), (int)Math.floor(hitResult.m_82450_().f_82481_));
        }
        BlockPos firstPos = BuildingToolItem.getFirstPos(stack);
        BlockPos secondPos = BuildingToolItem.getSecondPos(stack);
        BlockPos entrancePos = BuildingToolItem.getEntrancePos(stack);
        switch (state) {
            case NONE: {
                if (currentPos == null) break;
                BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 0.0f, 1.0f, 0.0f, 1.0f);
                break;
            }
            case FIRST_POS: {
                if (firstPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, firstPos, cameraPos, 0.0f, 1.0f, 0.0f, 1.0f);
                }
                if (currentPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 1.0f, 0.0f, 0.0f, 1.0f);
                }
                if (firstPos == null || currentPos == null) break;
                BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, currentPos, cameraPos, 1.0f, 1.0f, 1.0f, 0.8f);
                break;
            }
            case SECOND_POS: {
                if (firstPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, firstPos, cameraPos, 0.0f, 1.0f, 0.0f, 1.0f);
                }
                if (secondPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, secondPos, cameraPos, 1.0f, 0.0f, 0.0f, 1.0f);
                }
                if (firstPos != null && secondPos != null) {
                    BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, secondPos, cameraPos, 1.0f, 1.0f, 1.0f, 0.8f);
                }
                if (currentPos == null) break;
                BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 0.0f, 0.0f, 1.0f, 1.0f);
                break;
            }
            case READY_TO_SAVE: {
                if (firstPos == null || secondPos == null || entrancePos == null) break;
                BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, secondPos, cameraPos, 1.0f, 1.0f, 1.0f, 0.8f);
                BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, entrancePos, cameraPos, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
    }

    private static void renderPlaceMode(PoseStack poseStack, MultiBufferSource bufferSource, ItemStack stack, Player player, Vec3 cameraPos) {
        String selectedTemplateData = BuildingToolItem.getSelectedTemplate(stack);
        HitResult hitResult = player.m_19907_(200.0, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            String[] parts;
            BlockPos pos = ((BlockHitResult)hitResult).m_82425_();
            BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, pos, cameraPos, 0.0f, 0.0f, 1.0f, 1.0f);
            if (selectedTemplateData != null && !selectedTemplateData.isEmpty() && (parts = selectedTemplateData.split("\\|")).length > 0) {
                String templateId = parts[0];
                int rotation = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                boolean mirror = parts.length > 2 && Boolean.parseBoolean(parts[2]);
                BuildingPreviewRenderer.setTemplate(templateId);
                BuildingPreviewRenderer.setPreviewPosition(pos);
                BuildingPreviewRenderer.setRotation(rotation);
                BuildingPreviewRenderer.render(poseStack, bufferSource, cameraPos);
            }
        } else {
            BuildingPreviewRenderer.setTemplate(null);
        }
    }

    private static void renderBlockOutline(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos pos, Vec3 cameraPos, float r, float g, float b, float a) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        AABB box = new AABB(pos).m_82400_(0.002);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_, (double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_, (float)r, (float)g, (float)b, (float)a);
        poseStack.m_85849_();
    }

    private static void renderSelectionBox(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos pos1, BlockPos pos2, Vec3 cameraPos, float r, float g, float b, float a) {
        int y;
        int z;
        int x;
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_()) + 1;
        int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_()) + 1;
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_()) + 1;
        AABB box = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).m_82400_(0.002);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_, (double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_, (float)r, (float)g, (float)b, (float)a);
        float gridAlpha = a * 0.3f;
        int gridSpacing = 2;
        for (x = minX + gridSpacing; x < maxX; x += gridSpacing) {
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)x, (double)minY, (double)minZ, (double)x, (double)minY, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)x, (double)maxY, (double)minZ, (double)x, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (z = minZ + gridSpacing; z < maxZ; z += gridSpacing) {
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)minX, (double)minY, (double)z, (double)maxX, (double)minY, (double)z, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)minX, (double)maxY, (double)z, (double)maxX, (double)maxY, (double)z, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (y = minY + gridSpacing; y < maxY; y += gridSpacing) {
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)minX, (double)y, (double)minZ, (double)minX, (double)y, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)maxX, (double)y, (double)minZ, (double)maxX, (double)y, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (z = minZ + gridSpacing; z < maxZ; z += gridSpacing) {
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)minX, (double)minY, (double)z, (double)minX, (double)maxY, (double)z, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)maxX, (double)minY, (double)z, (double)maxX, (double)maxY, (double)z, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (y = minY + gridSpacing; y < maxY; y += gridSpacing) {
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)minX, (double)y, (double)minZ, (double)maxX, (double)y, (double)minZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)minX, (double)y, (double)maxZ, (double)maxX, (double)y, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (x = minX + gridSpacing; x < maxX; x += gridSpacing) {
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)x, (double)minY, (double)minZ, (double)x, (double)maxY, (double)minZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)x, (double)minY, (double)maxZ, (double)x, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        poseStack.m_85849_();
    }
}

