/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.item.CommandStaffHandler;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;

@Mod.EventBusSubscriber(modid="hundred_years_war", value={Dist.CLIENT})
public class CommandStaffTargetRenderer {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (Freecam.isEnabled()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_41619_() || !(mainHandItem.m_41720_() instanceof CommandStaffItem)) {
            return;
        }
        CommandStaffHandler handler = CommandStaffHandler.getInstance();
        handler.updateCurrentCommandStaff((Player)player);
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        CommandStaffTargetRenderer.renderTargetPositions(poseStack, camera, handler, minecraft);
    }

    private static void renderTargetPositions(PoseStack poseStack, Camera camera, CommandStaffHandler handler, Minecraft minecraft) {
        BlockPos attackMovePos;
        Vec3 cameraPos = camera.m_90583_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        BlockPos movePos = handler.getTargetBlockPos();
        if (movePos != null) {
            CommandStaffTargetRenderer.renderTargetBox(poseStack, vertexConsumer, movePos, cameraPos, 0.0f, 1.0f, 0.0f);
        }
        if ((attackMovePos = handler.getAttackMoveBlockPos()) != null) {
            CommandStaffTargetRenderer.renderTargetBox(poseStack, vertexConsumer, attackMovePos, cameraPos, 1.0f, 0.0f, 0.0f);
        }
        bufferSource.m_109912_(RenderType.m_110504_());
    }

    private static void renderTargetBox(PoseStack poseStack, VertexConsumer vertexConsumer, BlockPos pos, Vec3 cameraPos, float r, float g, float b) {
        Vec3 targetPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5);
        Vec3 centerPos = targetPos.m_82546_(cameraPos);
        double outerMinX = centerPos.f_82479_ - 0.5;
        double outerMinZ = centerPos.f_82481_ - 0.5;
        double outerMaxX = centerPos.f_82479_ + 0.5;
        double outerMaxZ = centerPos.f_82481_ + 0.5;
        double innerMinX = centerPos.f_82479_ - 0.3;
        double innerMinZ = centerPos.f_82481_ - 0.3;
        double innerMaxX = centerPos.f_82479_ + 0.3;
        double innerMaxZ = centerPos.f_82481_ + 0.3;
        AABB outerBox = new AABB(outerMinX, centerPos.f_82480_, outerMinZ, outerMaxX, centerPos.f_82480_, outerMaxZ);
        AABB innerBox = new AABB(innerMinX, centerPos.f_82480_, innerMinZ, innerMaxX, centerPos.f_82480_, innerMaxZ);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)outerBox.f_82288_, (double)outerBox.f_82289_, (double)outerBox.f_82290_, (double)outerBox.f_82291_, (double)outerBox.f_82292_, (double)outerBox.f_82293_, (float)r, (float)g, (float)b, (float)1.0f);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)innerBox.f_82288_, (double)innerBox.f_82289_, (double)innerBox.f_82290_, (double)innerBox.f_82291_, (double)innerBox.f_82292_, (double)innerBox.f_82293_, (float)r, (float)g, (float)b, (float)1.0f);
    }
}

