/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;

@Mod.EventBusSubscriber(modid="hundred_years_war", value={Dist.CLIENT})
public class FreecamTargetRenderer {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        boolean shouldRender;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!shouldRender) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        FreecamTargetRenderer.renderEntityTargets(poseStack, camera, mc);
    }

    private static void renderEntityTargets(PoseStack poseStack, Camera camera, Minecraft mc) {
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        HashMap<String, List> formationMap = new HashMap<String, List>();
        for (Object entity : level.m_104735_()) {
            CopyOnWriteArraySet<TargetInfo> copyOnWriteArraySet;
            if (!(entity instanceof BaseCombatEntity) || (copyOnWriteArraySet = SelectionHandler.getInstance().getCombinedTargetMap().get(entity)) == null) continue;
            for (TargetInfo target : copyOnWriteArraySet) {
                String type = target.getType();
                if (!"formTarget".equals(type) && !"formAttackTarget".equals(type)) continue;
                BlockPos targetPos = target.getPosition();
                String formationKey = (String)type + "_" + targetPos.m_123344_();
                formationMap.computeIfAbsent(formationKey, k -> new ArrayList()).add(entity);
            }
        }
        HashSet<BlockPos> renderedPositions = new HashSet<BlockPos>();
        for (Map.Entry entry : formationMap.entrySet()) {
            List formationEntities = (List)entry.getValue();
            Vec3 formationCenter = FreecamTargetRenderer.calculateCenterPosition(formationEntities);
            for (Entity entity : formationEntities) {
                CopyOnWriteArraySet<TargetInfo> targets = SelectionHandler.getInstance().getCombinedTargetMap().get(entity);
                if (targets == null) continue;
                FreecamTargetRenderer.renderTargetPositions(poseStack, entity, targets, formationCenter, renderedPositions, formationEntities);
            }
        }
        for (Entity entity : level.m_104735_()) {
            BlockPos unloadTarget;
            BlockPos bombardTarget;
            SelectionHandler selectionHandler;
            CopyOnWriteArraySet<TargetInfo> targets;
            if (!(entity instanceof BaseCombatEntity)) continue;
            boolean inFormation = formationMap.values().stream().anyMatch(list -> list.contains(entity));
            if (!inFormation && (targets = SelectionHandler.getInstance().getCombinedTargetMap().get(entity)) != null) {
                List<Entity> singleEntityList = Collections.singletonList(entity);
                FreecamTargetRenderer.renderTargetPositions(poseStack, entity, targets, entity.m_20182_(), renderedPositions, singleEntityList);
            }
            if ((selectionHandler = SelectionHandler.getInstance()).getPatrolPointsMap().containsKey(entity)) {
                FreecamTargetRenderer.renderPatrolPositions(poseStack, entity, selectionHandler.getPatrolPointsMap().get(entity));
            }
            if (entity instanceof PositionAttackable && selectionHandler.getSelectedEntities().contains(entity) && (bombardTarget = selectionHandler.getBombardTarget(entity)) != null) {
                FreecamTargetRenderer.renderBombardTarget(poseStack, entity, bombardTarget);
            }
            if (!(entity instanceof UnloadPassengerable) || !selectionHandler.getSelectedEntities().contains(entity) || (unloadTarget = selectionHandler.getUnloadTarget(entity)) == null) continue;
            FreecamTargetRenderer.renderUnloadTarget(poseStack, entity, unloadTarget);
        }
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        bufferSource.m_109912_(RenderType.m_110504_());
    }

    private static void renderTargetPositions(PoseStack poseStack, Entity entity, CopyOnWriteArraySet<TargetInfo> targets, Vec3 formationCenter, Set<BlockPos> renderedPositions, List<Entity> formationEntities) {
        boolean shouldRender;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        AtomicReference<Vec3> entityPreviousPos = new AtomicReference<Vec3>(entity.m_20182_().m_82546_(cameraPos));
        AtomicReference<Vec3> previousPos = new AtomicReference<Vec3>(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()).m_82546_(cameraPos));
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        List<Entity> selectedEntities = selectionHandler.getSelectedEntities();
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!selectedEntities.contains(entity) || !shouldRender) {
            return;
        }
        for (TargetInfo target : targets) {
            float b;
            float g;
            float r;
            BlockPos pos = target.getPosition();
            String type = target.getType();
            if (!Objects.equals(type, "entityTarget") && !Objects.equals(type, "followTarget")) {
                float b2;
                float g2;
                float r2;
                Vec3 targetPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5);
                Vec3 centerPos = targetPos.m_82546_(cameraPos);
                double outerMinX = centerPos.m_7096_() - 0.5;
                double outerMinZ = centerPos.m_7094_() - 0.5;
                double outerMaxX = centerPos.m_7096_() + 0.5;
                double outerMaxZ = centerPos.m_7094_() + 0.5;
                double innerMinX = centerPos.m_7096_() - 0.3;
                double innerMinZ = centerPos.m_7094_() - 0.3;
                double innerMaxX = centerPos.m_7096_() + 0.3;
                double innerMaxZ = centerPos.m_7094_() + 0.3;
                AABB outerBox = new AABB(outerMinX, centerPos.m_7098_(), outerMinZ, outerMaxX, centerPos.m_7098_(), outerMaxZ);
                AABB innerBox = new AABB(innerMinX, centerPos.m_7098_(), innerMinZ, innerMaxX, centerPos.m_7098_(), innerMaxZ);
                if (Objects.equals(type, "target") || Objects.equals(type, "formTarget")) {
                    r2 = 0.0f;
                    g2 = 1.0f;
                    b2 = 0.0f;
                } else {
                    r2 = 1.0f;
                    g2 = 0.0f;
                    b2 = 0.0f;
                }
                if (!renderedPositions.contains(pos)) {
                    LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)outerBox.f_82288_, (double)outerBox.f_82289_, (double)outerBox.f_82290_, (double)outerBox.f_82291_, (double)outerBox.f_82292_, (double)outerBox.f_82293_, (float)r2, (float)g2, (float)b2, (float)1.0f);
                    LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)innerBox.f_82288_, (double)innerBox.f_82289_, (double)innerBox.f_82290_, (double)innerBox.f_82291_, (double)innerBox.f_82292_, (double)innerBox.f_82293_, (float)r2, (float)g2, (float)b2, (float)1.0f);
                    renderedPositions.add(pos);
                }
                if (previousPos != null && previousPos.get() != null) {
                    Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
                    vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)previousPos.get().m_7096_(), (float)previousPos.get().m_7098_(), (float)previousPos.get().m_7094_()).m_85950_(r2, g2, b2, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                    vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)centerPos.m_7096_(), (float)centerPos.m_7098_(), (float)centerPos.m_7094_()).m_85950_(r2, g2, b2, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                }
                previousPos.set(centerPos);
                entityPreviousPos.set(centerPos);
                continue;
            }
            Entity targetEntity = target.getHywTarget();
            if (!targetEntity.m_6084_()) continue;
            Vec3 entityPos = targetEntity.m_20182_().m_82546_(cameraPos);
            if (Objects.equals(type, "entityTarget")) {
                r = 1.0f;
                g = 0.0f;
                b = 0.0f;
            } else if (Objects.equals(type, "followTarget")) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            }
            if (entityPreviousPos.get() != null) {
                Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
                vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)entityPreviousPos.get().m_7096_(), (float)entityPreviousPos.get().m_7098_(), (float)entityPreviousPos.get().m_7094_()).m_85950_(r, g, b, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)entityPos.m_7096_(), (float)entityPos.m_7098_(), (float)entityPos.m_7094_()).m_85950_(r, g, b, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            entityPreviousPos.set(entityPos);
            previousPos.set(new Vec3(targetEntity.m_20185_(), targetEntity.m_20186_(), targetEntity.m_20189_()).m_82546_(cameraPos));
        }
    }

    private static void renderPatrolPositions(PoseStack poseStack, Entity entity, CopyOnWriteArrayList<BlockPos> patrolPoints) {
        boolean shouldRender;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        List<Entity> selectedEntities = selectionHandler.getSelectedEntities();
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!selectedEntities.contains(entity) || !shouldRender) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        Vec3 previousPos = null;
        for (BlockPos patrolPoint : patrolPoints) {
            Vec3 targetPos = new Vec3((double)patrolPoint.m_123341_() + 0.5, (double)patrolPoint.m_123342_() + 1.1, (double)patrolPoint.m_123343_() + 0.5);
            Vec3 centerPos = targetPos.m_82546_(cameraPos);
            double outerMinX = centerPos.m_7096_() - 0.5;
            double outerMinZ = centerPos.m_7094_() - 0.5;
            double outerMaxX = centerPos.m_7096_() + 0.5;
            double outerMaxZ = centerPos.m_7094_() + 0.5;
            double innerMinX = centerPos.m_7096_() - 0.3;
            double innerMinZ = centerPos.m_7094_() - 0.3;
            double innerMaxX = centerPos.m_7096_() + 0.3;
            double innerMaxZ = centerPos.m_7094_() + 0.3;
            AABB outerBox = new AABB(outerMinX, centerPos.m_7098_(), outerMinZ, outerMaxX, centerPos.m_7098_(), outerMaxZ);
            AABB innerBox = new AABB(innerMinX, centerPos.m_7098_(), innerMinZ, innerMaxX, centerPos.m_7098_(), innerMaxZ);
            float r = 0.0f;
            float g = 0.0f;
            float b = 1.0f;
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)outerBox.f_82288_, (double)outerBox.f_82289_, (double)outerBox.f_82290_, (double)outerBox.f_82291_, (double)outerBox.f_82292_, (double)outerBox.f_82293_, (float)r, (float)g, (float)b, (float)1.0f);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)innerBox.f_82288_, (double)innerBox.f_82289_, (double)innerBox.f_82290_, (double)innerBox.f_82291_, (double)innerBox.f_82292_, (double)innerBox.f_82293_, (float)r, (float)g, (float)b, (float)1.0f);
            if (previousPos != null) {
                Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
                vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)previousPos.m_7096_(), (float)previousPos.m_7098_(), (float)previousPos.m_7094_()).m_85950_(r, g, b, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)centerPos.m_7096_(), (float)centerPos.m_7098_(), (float)centerPos.m_7094_()).m_85950_(r, g, b, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            previousPos = centerPos;
        }
    }

    private static void renderUnloadTarget(PoseStack poseStack, Entity entity, BlockPos unloadTarget) {
        boolean shouldRender;
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!SelectionHandler.getInstance().getSelectedEntities().contains(entity) || !shouldRender) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        Vec3 centerPos = new Vec3((double)unloadTarget.m_123341_() + 0.5, (double)unloadTarget.m_123342_() + 0.5, (double)unloadTarget.m_123343_() + 0.5).m_82546_(cameraPos);
        float innerSize = 0.5f;
        float outerSizeXZ = 1.5f;
        float outerSizeY = 0.5f;
        float red = 1.0f;
        float green = 1.0f;
        float blue = 0.0f;
        float alpha = 1.0f;
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)(centerPos.f_82479_ - (double)innerSize), (double)(centerPos.f_82480_ - (double)innerSize), (double)(centerPos.f_82481_ - (double)innerSize), (double)(centerPos.f_82479_ + (double)innerSize), (double)(centerPos.f_82480_ + (double)innerSize), (double)(centerPos.f_82481_ + (double)innerSize), (float)red, (float)green, (float)blue, (float)alpha);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)(centerPos.f_82479_ - (double)outerSizeXZ), (double)(centerPos.f_82480_ - (double)outerSizeY), (double)(centerPos.f_82481_ - (double)outerSizeXZ), (double)(centerPos.f_82479_ + (double)outerSizeXZ), (double)(centerPos.f_82480_ + (double)outerSizeY), (double)(centerPos.f_82481_ + (double)outerSizeXZ), (float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void renderBombardTarget(PoseStack poseStack, Entity entity, BlockPos bombardTarget) {
        boolean shouldRender;
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!SelectionHandler.getInstance().getSelectedEntities().contains(entity) || !shouldRender) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        Vec3 centerPos = new Vec3((double)bombardTarget.m_123341_() + 0.5, (double)bombardTarget.m_123342_() + 0.5, (double)bombardTarget.m_123343_() + 0.5).m_82546_(cameraPos);
        float smallSize = 0.5f;
        float largeSize = 1.5f;
        float red = 1.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float alpha = 1.0f;
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)(centerPos.f_82479_ - (double)smallSize), (double)(centerPos.f_82480_ - (double)smallSize), (double)(centerPos.f_82481_ - (double)smallSize), (double)(centerPos.f_82479_ + (double)smallSize), (double)(centerPos.f_82480_ + (double)smallSize), (double)(centerPos.f_82481_ + (double)smallSize), (float)red, (float)green, (float)blue, (float)alpha);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)(centerPos.f_82479_ - (double)largeSize), (double)(centerPos.f_82480_ - (double)largeSize), (double)(centerPos.f_82481_ - (double)largeSize), (double)(centerPos.f_82479_ + (double)largeSize), (double)(centerPos.f_82480_ + (double)largeSize), (double)(centerPos.f_82481_ + (double)largeSize), (float)red, (float)green, (float)blue, (float)alpha);
    }

    private static Vec3 calculateCenterPosition(List<Entity> selectedEntities) {
        if (selectedEntities.isEmpty()) {
            return Vec3.f_82478_;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (Entity entity : selectedEntities) {
            Vec3 entityPos = entity.m_20182_();
            sumX += entityPos.f_82479_;
            sumY += entityPos.f_82480_;
            sumZ += entityPos.f_82481_;
        }
        double centerX = sumX / (double)selectedEntities.size();
        double centerY = sumY / (double)selectedEntities.size();
        double centerZ = sumZ / (double)selectedEntities.size();
        return new Vec3(centerX, centerY, centerZ);
    }
}

