/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;

public class SpawnPointRenderer
implements BlockEntityRenderer<SpawnPointBlockEntity> {
    public SpawnPointRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SpawnPointBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        if (!this.shouldDisplay(entity)) {
            return;
        }
        this.renderNameplate(entity, poseStack, bufferSource, combinedLight);
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        double flatHeight = 0.09375;
        AABB flatOuter = new AABB(0.4, 0.0, 0.4, 0.6, flatHeight, 0.6);
        LevelRenderer.m_109621_((PoseStack)poseStack, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110504_()), (double)flatOuter.f_82288_, (double)flatOuter.f_82289_, (double)flatOuter.f_82290_, (double)flatOuter.f_82291_, (double)flatOuter.f_82292_, (double)flatOuter.f_82293_, (float)red, (float)green, (float)blue, (float)alpha, (float)red, (float)green, (float)blue);
        AABB flatInner = new AABB(0.2, 0.0, 0.2, 0.8, flatHeight, 0.8);
        LevelRenderer.m_109621_((PoseStack)poseStack, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110504_()), (double)flatInner.f_82288_, (double)flatInner.f_82289_, (double)flatInner.f_82290_, (double)flatInner.f_82291_, (double)flatInner.f_82292_, (double)flatInner.f_82293_, (float)red, (float)green, (float)blue, (float)alpha, (float)red, (float)green, (float)blue);
        if (entity.isShowActivationRange()) {
            this.renderActivationRange(entity, poseStack, bufferSource);
        }
    }

    private boolean shouldDisplay(SpawnPointBlockEntity entity) {
        if (entity.isShowActivationRange()) {
            return true;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        return this.isHighlightStack(player.m_21205_()) || this.isHighlightStack(player.m_21206_());
    }

    private boolean isHighlightStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        return itemId.equals("hundred_years_war:spawn_point") || stack.m_41720_() instanceof BuildingToolItem;
    }

    private void renderNameplate(SpawnPointBlockEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (entity == null) {
            return;
        }
        Component nameComponent = entity.getPrimaryEntryName();
        if (nameComponent == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91073_ == null) {
            return;
        }
        double distanceSq = minecraft.m_91290_().m_114378_((double)entity.m_58899_().m_123341_() + 0.5, (double)entity.m_58899_().m_123342_() + 0.5, (double)entity.m_58899_().m_123343_() + 0.5);
        if (distanceSq > 4096.0) {
            return;
        }
        Font font = minecraft.f_91062_;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.6, 0.5);
        poseStack.m_252781_(minecraft.m_91290_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float background = minecraft.f_91066_.m_92141_(0.25f);
        int backgroundColor = (int)(background * 255.0f) << 24;
        float xOffset = (float)(-font.m_92852_((FormattedText)nameComponent)) / 2.0f;
        font.m_272077_(nameComponent, xOffset, 0.0f, 0x20FFFFFF, false, matrix4f, bufferSource, Font.DisplayMode.SEE_THROUGH, backgroundColor, light);
        font.m_272077_(nameComponent, xOffset, 0.0f, -1, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, light);
        poseStack.m_85849_();
    }

    private void renderActivationRange(SpawnPointBlockEntity entity, PoseStack poseStack, MultiBufferSource bufferSource) {
        double localZ;
        int z;
        double localX;
        int x;
        double radius = Math.max(0.0, entity.getActivationDistance());
        if (radius <= 0.0) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerY = (double)pos.m_123342_() + 0.5;
        double centerZ = (double)pos.m_123343_() + 0.5;
        double minX = centerX - radius;
        double minY = centerY - radius;
        double minZ = centerZ - radius;
        double maxX = centerX + radius;
        double maxY = centerY + radius;
        double maxZ = centerZ + radius;
        double localMinX = minX - (double)pos.m_123341_();
        double localMaxX = maxX - (double)pos.m_123341_();
        double localMinY = minY - (double)pos.m_123342_();
        double localMaxY = maxY - (double)pos.m_123342_();
        double localMinZ = minZ - (double)pos.m_123343_();
        double localMaxZ = maxZ - (double)pos.m_123343_();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float alpha = 0.6f;
        float gridAlpha = alpha * 0.3f;
        int gridSpacing = 2;
        AABB box = new AABB(localMinX, localMinY, localMinZ, localMaxX, localMaxY, localMaxZ).m_82400_(0.002);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_, (double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_, (float)r, (float)g, (float)b, (float)alpha);
        int gridMinX = Mth.m_14107_((double)minX);
        int gridMaxX = Mth.m_14165_((double)maxX);
        int gridMinY = Mth.m_14107_((double)minY);
        int gridMaxY = Mth.m_14165_((double)maxY);
        int gridMinZ = Mth.m_14107_((double)minZ);
        int gridMaxZ = Mth.m_14165_((double)maxZ);
        for (x = gridMinX + gridSpacing; x < gridMaxX; x += gridSpacing) {
            localX = x - pos.m_123341_();
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localX, (double)localMinY, (double)localMinZ, (double)localX, (double)localMinY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localX, (double)localMaxY, (double)localMinZ, (double)localX, (double)localMaxY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (z = gridMinZ + gridSpacing; z < gridMaxZ; z += gridSpacing) {
            localZ = z - pos.m_123343_();
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localMinX, (double)localMinY, (double)localZ, (double)localMaxX, (double)localMinY, (double)localZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localMinX, (double)localMaxY, (double)localZ, (double)localMaxX, (double)localMaxY, (double)localZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (int y = gridMinY + gridSpacing; y < gridMaxY; y += gridSpacing) {
            double localY = y - pos.m_123342_();
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localMinX, (double)localY, (double)localMinZ, (double)localMinX, (double)localY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localMaxX, (double)localY, (double)localMinZ, (double)localMaxX, (double)localY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localMinX, (double)localY, (double)localMinZ, (double)localMaxX, (double)localY, (double)localMinZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localMinX, (double)localY, (double)localMaxZ, (double)localMaxX, (double)localY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (x = gridMinX + gridSpacing; x < gridMaxX; x += gridSpacing) {
            localX = x - pos.m_123341_();
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localX, (double)localMinY, (double)localMinZ, (double)localX, (double)localMaxY, (double)localMinZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localX, (double)localMinY, (double)localMaxZ, (double)localX, (double)localMaxY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (z = gridMinZ + gridSpacing; z < gridMaxZ; z += gridSpacing) {
            localZ = z - pos.m_123343_();
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localMinX, (double)localMinY, (double)localZ, (double)localMinX, (double)localMaxY, (double)localZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)localMaxX, (double)localMinY, (double)localZ, (double)localMaxX, (double)localMaxY, (double)localZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRenderOffScreen(SpawnPointBlockEntity blockEntity) {
        return false;
    }
}

