/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.models.projectile.MangonelsBulletModel;
import ydmsama.hundred_years_war.main.entity.entities.projectile.MangonelsBulletEntity;

public class MangonelsBulletRenderer
extends ArrowRenderer<MangonelsBulletEntity> {
    private final MangonelsBulletModel<MangonelsBulletEntity> model;

    public MangonelsBulletRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new MangonelsBulletModel(context.m_174023_(MangonelsBulletModel.LAYER_LOCATION));
    }

    public void render(MangonelsBulletEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.25f, 1.25f, 1.25f);
        float ticksExisted = (float)entity.f_19797_ + partialTicks;
        int entityId = entity.m_19879_();
        float randomFactor1 = (float)(entityId * 31 % 20) / 10.0f + 0.5f;
        float randomFactor2 = (float)(entityId * 17 % 15) / 10.0f + 0.8f;
        float randomFactor3 = (float)(entityId * 23 % 18) / 10.0f + 0.6f;
        float wobbleX = Mth.m_14031_((float)(ticksExisted * 0.05f)) * 5.0f;
        float wobbleY = Mth.m_14089_((float)(ticksExisted * 0.07f)) * 5.0f;
        float wobbleZ = Mth.m_14031_((float)(ticksExisted * 0.06f + 0.3f)) * 5.0f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(ticksExisted * 5.0f * randomFactor1 + wobbleX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(ticksExisted * 3.0f * randomFactor2 + wobbleY));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(ticksExisted * 2.0f * randomFactor3 + wobbleZ));
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity)));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(MangonelsBulletEntity entity) {
        return new ResourceLocation("hundred_years_war", "textures/entity/mangonels_bullet.png");
    }
}

