/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.entities.projectile.RocketEntity;

public class RocketRenderer
extends ArrowRenderer<RocketEntity> {
    public static final ResourceLocation ROCKET_TEXTURE_LOCATION = new ResourceLocation("textures/entity/projectiles/arrow.png");

    public RocketRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(RocketEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        float Scale = 1.5f;
        poseStack.m_85841_(Scale, Scale, Scale);
        DarkArrowBufferSource darkBuffer = new DarkArrowBufferSource(buffer);
        super.m_7392_((AbstractArrow)entity, entityYaw, partialTicks, poseStack, (MultiBufferSource)darkBuffer, (int)((float)packedLight * 0.7f));
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(RocketEntity entity) {
        return ROCKET_TEXTURE_LOCATION;
    }

    private static class DarkArrowBufferSource
    implements MultiBufferSource {
        private final MultiBufferSource parent;

        public DarkArrowBufferSource(MultiBufferSource parent) {
            this.parent = parent;
        }

        public VertexConsumer m_6299_(final RenderType renderType) {
            return new VertexConsumer(){
                private final VertexConsumer delegate;
                {
                    this.delegate = parent.m_6299_(renderType);
                }

                public VertexConsumer m_5483_(double x, double y, double z) {
                    return this.delegate.m_5483_(x, y, z);
                }

                public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
                    int darkRed = Math.max(20, (int)((float)red * 0.6f));
                    int darkGreen = Math.max(10, (int)((float)green * 0.4f));
                    int darkBlue = Math.max(5, (int)((float)blue * 0.3f));
                    return this.delegate.m_6122_(darkRed, darkGreen, darkBlue, alpha);
                }

                public VertexConsumer m_7421_(float u, float v) {
                    return this.delegate.m_7421_(u, v);
                }

                public VertexConsumer m_7122_(int u, int v) {
                    return this.delegate.m_7122_(u, v);
                }

                public VertexConsumer m_7120_(int u, int v) {
                    return this.delegate.m_7120_(u, v);
                }

                public VertexConsumer m_5601_(float x, float y, float z) {
                    return this.delegate.m_5601_(x, y, z);
                }

                public void m_5752_() {
                    this.delegate.m_5752_();
                }

                public void m_7404_(int red, int green, int blue, int alpha) {
                    int darkRed = Math.max(20, (int)((float)red * 0.6f));
                    int darkGreen = Math.max(10, (int)((float)green * 0.4f));
                    int darkBlue = Math.max(5, (int)((float)blue * 0.3f));
                    this.delegate.m_7404_(darkRed, darkGreen, darkBlue, alpha);
                }

                public void m_141991_() {
                    this.delegate.m_141991_();
                }
            };
        }
    }
}

