/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import ydmsama.hundred_years_war.client.screen.SpawnPointScreen;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;

public class EntitySelectionScreen
extends Screen {
    private final SpawnPointScreen parent;
    private final int entryIndex;
    private final SpawnPointBlockEntity.SpawnEntry existingEntry;
    private EditBox searchBox;
    private Button confirmButton;
    private Button cancelButton;
    private ResourceLocation selectedEntityId;
    private final List<ResourceLocation> allEntities = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> filteredEntities = new ArrayList<ResourceLocation>();
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private boolean isScrolling = false;
    private static final int WINDOW_WIDTH = 300;
    private static final int WINDOW_HEIGHT = 200;
    private static final int LIST_WIDTH = 260;
    private static final int LIST_HEIGHT = 130;
    private static final int ENTRY_HEIGHT = 24;
    private static final int SCROLL_BAR_WIDTH = 6;

    public EntitySelectionScreen(SpawnPointScreen parent, int entryIndex, SpawnPointBlockEntity.SpawnEntry existingEntry) {
        super((Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.select_entity"));
        this.parent = parent;
        this.entryIndex = entryIndex;
        this.existingEntry = existingEntry;
        this.selectedEntityId = existingEntry != null ? existingEntry.entityId() : new ResourceLocation("minecraft", "zombie");
        this.loadEntities();
    }

    private void loadEntities() {
        for (EntityType entityType : BuiltInRegistries.f_256780_) {
            ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)entityType);
            if (id == null || entityType.m_20674_() != MobCategory.CREATURE && entityType.m_20674_() != MobCategory.MONSTER && entityType.m_20674_() != MobCategory.AMBIENT && entityType.m_20674_() != MobCategory.AXOLOTLS && entityType.m_20674_() != MobCategory.UNDERGROUND_WATER_CREATURE && entityType.m_20674_() != MobCategory.WATER_CREATURE && entityType.m_20674_() != MobCategory.WATER_AMBIENT) continue;
            this.allEntities.add(id);
        }
        this.allEntities.sort((a, b) -> a.toString().compareTo(b.toString()));
        this.filteredEntities.addAll(this.allEntities);
        this.calculateMaxScroll();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        this.searchBox = new EditBox(this.f_96547_, startX + 20, startY + 5, 240, 16, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.search"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Enter entity name..."));
        this.searchBox.m_94151_(this::onSearchChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.confirmButton = Button.m_253074_((Component)Component.m_237113_((String)"Confirm"), button -> this.confirm()).m_252794_(startX + 300 - 110, startY + 200 - 25).m_253046_(50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.m_7379_()).m_252794_(startX + 300 - 55, startY + 200 - 25).m_253046_(50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        graphics.m_280509_(startX, startY, startX + 300, startY + 200, -533712848);
        graphics.m_280509_(startX + 1, startY + 1, startX + 300 - 1, startY + 200 - 1, -535818224);
        int listX = startX + 20;
        int listY = startY + 25;
        graphics.m_280509_(listX, listY, listX + 260, listY + 130, -14671840);
        graphics.m_280509_(listX + 1, listY + 1, listX + 260 - 1, listY + 130 - 1, -16777216);
        int scrollBarX = listX + 260 - 6 - 2;
        graphics.m_280509_(scrollBarX, listY + 2, scrollBarX + 6, listY + 130 - 2, -12566464);
        if (this.maxScroll > 0) {
            int totalHeight = this.filteredEntities.size() * 24;
            int scrollBarHeight = Math.max(10, (int)(130.0f / (float)totalHeight * 130.0f));
            int scrollBarY = listY + 2 + (int)((float)this.scrollOffset / (float)this.maxScroll * (float)(126 - scrollBarHeight));
            graphics.m_280509_(scrollBarX, scrollBarY, scrollBarX + 6, scrollBarY + scrollBarHeight, -8355712);
        }
        graphics.m_280588_(listX + 2, listY + 2, listX + 260 - 6 - 4, listY + 130 - 2);
        int currentY = listY + 2 - this.scrollOffset;
        for (ResourceLocation entityId : this.filteredEntities) {
            if (currentY + 24 > listY && currentY < listY + 130) {
                boolean hover;
                boolean isSelected = this.selectedEntityId != null && this.selectedEntityId.equals((Object)entityId);
                boolean bl = hover = mouseX >= listX + 2 && mouseX <= listX + 260 - 6 - 4 && mouseY >= currentY && mouseY <= currentY + 24;
                int bgColor = isSelected ? -11513776 : (hover ? -13290187 : -14342875);
                graphics.m_280509_(listX + 2, currentY, listX + 260 - 6 - 4, currentY + 24, bgColor);
                EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entityId);
                Component displayName = entityType != null ? entityType.m_20676_() : Component.m_237113_((String)entityId.toString());
                int nameColor = isSelected ? 65280 : 0xFFFFFF;
                graphics.m_280430_(this.f_96547_, displayName, listX + 5, currentY + 2, nameColor);
                int idColor = isSelected ? 43520 : 0xAAAAAA;
                graphics.m_280488_(this.f_96547_, entityId.toString(), listX + 5, currentY + 13, idColor);
            }
            currentY += 24;
        }
        graphics.m_280618_();
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int scrollBarX;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        int listX = startX + 20;
        int listY = startY + 25;
        if (mouseX >= (double)(listX + 2) && mouseX <= (double)(listX + 260 - 6 - 4) && mouseY >= (double)(listY + 2) && mouseY <= (double)(listY + 130 - 2)) {
            int currentY = listY + 2 - this.scrollOffset;
            for (ResourceLocation entityId : this.filteredEntities) {
                if (mouseY >= (double)currentY && mouseY <= (double)(currentY + 24)) {
                    this.selectedEntityId = entityId;
                    return true;
                }
                currentY += 24;
            }
        }
        if (mouseX >= (double)(scrollBarX = listX + 260 - 6 - 2) && mouseX <= (double)(scrollBarX + 6) && mouseY >= (double)listY && mouseY <= (double)(listY + 130)) {
            this.isScrolling = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling && this.maxScroll > 0) {
            int centerX = this.f_96543_ / 2;
            int centerY = this.f_96544_ / 2;
            int startX = centerX - 150;
            int startY = centerY - 100;
            int listX = startX + 20;
            int listY = startY + 25;
            int totalHeight = this.filteredEntities.size() * 24;
            int scrollBarHeight = Math.max(10, (int)(130.0f / (float)totalHeight * 130.0f));
            int usableScrollSpace = 126 - scrollBarHeight;
            int relativeY = (int)(mouseY - (double)listY - 2.0 - (double)(scrollBarHeight / 2));
            if (usableScrollSpace > 0) {
                this.scrollOffset = (int)Math.max(0.0f, Math.min((float)this.maxScroll, (float)relativeY / (float)usableScrollSpace * (float)this.maxScroll));
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        int listX = startX + 20;
        int listY = startY + 25;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + 260) && mouseY >= (double)listY && mouseY <= (double)(listY + 130)) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScroll, (double)this.scrollOffset - delta * 10.0));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void onSearchChanged(String search) {
        this.filteredEntities.clear();
        String searchLower = search.toLowerCase();
        if (searchLower.isEmpty()) {
            this.filteredEntities.addAll(this.allEntities);
        } else {
            for (ResourceLocation entityId : this.allEntities) {
                if (entityId.toString().toLowerCase().contains(searchLower)) {
                    this.filteredEntities.add(entityId);
                    continue;
                }
                EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entityId);
                if (entityType == null) continue;
                String translationKey = entityType.m_20675_().toLowerCase();
                if (translationKey.contains(searchLower)) {
                    this.filteredEntities.add(entityId);
                    continue;
                }
                String displayName = entityType.m_20676_().getString().toLowerCase();
                if (!displayName.contains(searchLower)) continue;
                this.filteredEntities.add(entityId);
            }
        }
        this.calculateMaxScroll();
        this.scrollOffset = 0;
    }

    private void calculateMaxScroll() {
        int totalHeight = this.filteredEntities.size() * 24;
        this.maxScroll = Math.max(0, totalHeight - 130);
    }

    private void confirm() {
        this.parent.updateEntityEntry(this.entryIndex, this.selectedEntityId);
        this.m_7379_();
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)this.parent);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

