/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.supply.PlayerSupplyScreenHandler;

public class PlayerSupplyScreen
extends AbstractContainerScreen<PlayerSupplyScreenHandler> {
    private static final int LABEL_COLOR = 0x404040;
    private static final int VALUE_COLOR = 0x404040;
    private static final int WARNING_COLOR = 0x804040;
    private static final int LABEL_MAX_PIXEL_WIDTH = 90;
    private static final int LABEL_X_OFFSET = 10;
    private static final int VALUE_X_OFFSET = 110;
    private Button convertButton;

    public PlayerSupplyScreen(PlayerSupplyScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 202;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.convertButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.supply.convert"), button -> ClientPacketHandler.sendPlayerSupplyConvertPacket()).m_252794_(this.f_97735_ + 62, this.f_97736_ + 56).m_253046_(52, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.convertButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        this.drawGuiFrame(graphics);
        this.drawSupplyInfo(graphics);
    }

    private void drawGuiFrame(GuiGraphics graphics) {
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -3750202);
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + 1, -13158601);
        graphics.m_280509_(this.f_97735_, this.f_97736_ + this.f_97727_ - 1, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -13158601);
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + 1, this.f_97736_ + this.f_97727_, -13158601);
        graphics.m_280509_(this.f_97735_ + this.f_97726_ - 1, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -13158601);
        graphics.m_280509_(this.f_97735_ + 1, this.f_97736_ + 1, this.f_97735_ + this.f_97726_ - 1, this.f_97736_ + this.f_97727_ - 1, -2039584);
        graphics.m_280509_(this.f_97735_ + 7, this.f_97736_ + 30, this.f_97735_ + 169, this.f_97736_ + 54, -986896);
        for (int i = 0; i < 9; ++i) {
            int x = this.f_97735_ + 8 + i * 18;
            int y = this.f_97736_ + 35;
            graphics.m_280509_(x - 1, y - 1, x + 17, y + 17, -7631989);
            graphics.m_280509_(x, y, x + 16, y + 16, -13158601);
        }
        graphics.m_280509_(this.f_97735_ + 7, this.f_97736_ + 80, this.f_97735_ + 169, this.f_97736_ + 118, -986896);
        int invY = this.f_97736_ + 120;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = this.f_97735_ + 8 + col * 18;
                int y = invY + row * 18;
                graphics.m_280509_(x - 1, y - 1, x + 17, y + 17, -7631989);
                graphics.m_280509_(x, y, x + 16, y + 16, -13158601);
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = this.f_97735_ + 8 + col * 18;
            int y = this.f_97736_ + 178;
            graphics.m_280509_(x - 1, y - 1, x + 17, y + 17, -7631989);
            graphics.m_280509_(x, y, x + 16, y + 16, -13158601);
        }
    }

    private void drawSupplyInfo(GuiGraphics graphics) {
        int labelX = this.f_97735_ + 10;
        int valueX = this.f_97735_ + 110;
        String storedText = this.getClampedLabel("gui.hundred_years_war.supply.stored");
        String supplyValue = String.format("%.0f / %.0f", ((PlayerSupplyScreenHandler)this.f_97732_).getStoredSupply(), ((PlayerSupplyScreenHandler)this.f_97732_).getMaxStoredSupply());
        graphics.m_280056_(this.f_96547_, storedText, labelX, this.f_97736_ + 83, 0x404040, false);
        graphics.m_280056_(this.f_96547_, supplyValue, valueX, this.f_97736_ + 83, 0x404040, false);
        String unitsText = this.getClampedLabel("gui.hundred_years_war.supply.supplied_units");
        String unitsValue = String.valueOf(((PlayerSupplyScreenHandler)this.f_97732_).getSuppliedEntityCount());
        graphics.m_280056_(this.f_96547_, unitsText, labelX, this.f_97736_ + 92, 0x404040, false);
        graphics.m_280056_(this.f_96547_, unitsValue, valueX, this.f_97736_ + 92, 0x404040, false);
        String consumptionText = this.getClampedLabel("gui.hundred_years_war.supply.daily_consumption");
        double dailyConsumption = ((PlayerSupplyScreenHandler)this.f_97732_).getDailyConsumption();
        boolean consumptionClamped = ((PlayerSupplyScreenHandler)this.f_97732_).isDailyConsumptionClamped();
        String consumptionValue = consumptionClamped ? ">" + String.format("%.1f", ((PlayerSupplyScreenHandler)this.f_97732_).getDailyConsumptionDisplayCap()) : String.format("%.1f", dailyConsumption);
        graphics.m_280056_(this.f_96547_, consumptionText, labelX, this.f_97736_ + 101, 0x404040, false);
        graphics.m_280056_(this.f_96547_, consumptionValue, valueX, this.f_97736_ + 101, 0x404040, false);
        if (!consumptionClamped && dailyConsumption > 0.0 && ((PlayerSupplyScreenHandler)this.f_97732_).getStoredSupply() > 0.0) {
            String daysLeftText = this.getClampedLabel("gui.hundred_years_war.supply.days_remaining");
            String timeLeft = String.format("%.1f", ((PlayerSupplyScreenHandler)this.f_97732_).getStoredSupply() / dailyConsumption);
            graphics.m_280056_(this.f_96547_, daysLeftText, labelX, this.f_97736_ + 110, 0x404040, false);
            graphics.m_280056_(this.f_96547_, timeLeft, valueX, this.f_97736_ + 110, 0x804040, false);
        }
    }

    private String getClampedLabel(String translationKey) {
        String text = Component.m_237115_((String)translationKey).getString();
        if (this.f_96547_.m_92895_(text) <= 90) {
            return text;
        }
        int ellipsisWidth = this.f_96547_.m_92895_("...");
        String trimmed = text;
        while (!trimmed.isEmpty() && this.f_96547_.m_92895_(trimmed) + ellipsisWidth > 90) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return trimmed.isEmpty() ? "..." : trimmed + "...";
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.supply.food_to_convert"), 8, 20, 0x404040, false);
    }
}

