/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.utils;

public class RenderingEntityTracker {
    private static final ThreadLocal<Object> CURRENT_RENDERING_ENTITY = new ThreadLocal();
    private static final ThreadLocal<Boolean> OPTIMIZATION_SUPPRESSED = ThreadLocal.withInitial(() -> false);

    public static void setCurrentRenderingEntity(Object entity) {
        CURRENT_RENDERING_ENTITY.set(entity);
    }

    public static void clearCurrentRenderingEntity() {
        CURRENT_RENDERING_ENTITY.remove();
    }

    public static Object getCurrentRenderingEntity() {
        return CURRENT_RENDERING_ENTITY.get();
    }

    public static boolean isOptimizationSuppressed() {
        return OPTIMIZATION_SUPPRESSED.get();
    }

    public static void runWithOptimizationSuppressed(Runnable runnable) {
        boolean previous = OPTIMIZATION_SUPPRESSED.get();
        OPTIMIZATION_SUPPRESSED.set(true);
        try {
            runnable.run();
        }
        finally {
            OPTIMIZATION_SUPPRESSED.set(previous);
        }
    }
}

