/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import ydmsama.hundred_years_war.main.generation.InstGenManager;
import ydmsama.hundred_years_war.main.generation.PregenManager;
import ydmsama.hundred_years_war.main.template.BuildingTaskManager;

public class StructureCommands {
    private static final int MAX_DISPLAY_LINES = 5;

    private StructureCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hyw_structure").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"stats").executes(context -> StructureCommands.executeStats((CommandSourceStack)context.getSource()))));
    }

    private static int executeStats(CommandSourceStack source) {
        ServerLevel level = source.m_81377_().m_129783_();
        if (level == null) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65e0\u6cd5\u83b7\u53d6\u4e3b\u4e16\u754c\u5b9e\u4f8b"));
            return 0;
        }
        PregenManager pregenManager = PregenManager.get(level);
        InstGenManager instGenManager = InstGenManager.get(level);
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76=== \u5efa\u7b51\u7cfb\u7edf\u72b6\u6001 ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7e\u9884\u8f7d\u7cfb\u7edf: \u00a7f" + pregenManager.getStats())), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7e\u5373\u65f6\u751f\u6210: \u00a7f" + instGenManager.getStats())), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7e\u5efa\u9020\u4efb\u52a1\u8fd0\u884c\u4e2d: \u00a7f" + (instGenManager.hasRunningTasks() ? "\u662f" : "\u5426"))), false);
        List<String> pregenSummaries = pregenManager.getActiveTaskSummaries();
        if (pregenSummaries.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77\u9884\u8f7d\u4efb\u52a1: \u65e0\u6d3b\u52a8\u4efb\u52a1"), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)String.format(Locale.ROOT, "\u00a77\u9884\u8f7d\u4efb\u52a1: %d \u4e2a\u6d3b\u52a8\u4efb\u52a1", pregenSummaries.size())), false);
            int displayCount = Math.min(5, pregenSummaries.size());
            for (int i = 0; i < displayCount; ++i) {
                String summary = pregenSummaries.get(i);
                source.m_288197_(() -> Component.m_237113_((String)("  \u00a7f" + summary)), false);
            }
            if (pregenSummaries.size() > displayCount) {
                source.m_288197_(() -> Component.m_237113_((String)String.format(Locale.ROOT, "  \u00a77... \u8fd8\u6709 %d \u4e2a\u4efb\u52a1", pregenSummaries.size() - displayCount)), false);
            }
        }
        List<String> instSummaries = instGenManager.getRunningTaskSummaries();
        if (instSummaries.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77\u5373\u65f6\u5efa\u9020: \u65e0\u8fd0\u884c\u4e2d\u7684\u5efa\u9020\u4efb\u52a1"), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)String.format(Locale.ROOT, "\u00a77\u5373\u65f6\u5efa\u9020: %d \u4e2a\u5efa\u9020\u4efb\u52a1", instSummaries.size())), false);
            int displayCount = Math.min(5, instSummaries.size());
            for (int i = 0; i < displayCount; ++i) {
                String summary = instSummaries.get(i);
                source.m_288197_(() -> Component.m_237113_((String)("  \u00a7f" + summary)), false);
            }
            if (instSummaries.size() > displayCount) {
                source.m_288197_(() -> Component.m_237113_((String)String.format(Locale.ROOT, "  \u00a77... \u8fd8\u6709 %d \u4e2a\u4efb\u52a1", instSummaries.size() - displayCount)), false);
            }
        }
        List<BuildingTaskManager.BuildingTaskStatus> activeTasks = taskManager.getActiveTaskSnapshots();
        if (activeTasks.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77\u5efa\u7b51\u4efb\u52a1\u7ba1\u7406\u5668: \u65e0\u6d3b\u52a8\u4efb\u52a1"), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)String.format(Locale.ROOT, "\u00a77\u5efa\u7b51\u4efb\u52a1\u7ba1\u7406\u5668: %d \u4e2a\u6d3b\u52a8\u4efb\u52a1", activeTasks.size())), false);
            int displayCount = Math.min(5, activeTasks.size());
            for (int i = 0; i < displayCount; ++i) {
                BuildingTaskManager.BuildingTaskStatus status = activeTasks.get(i);
                String line = String.format(Locale.ROOT, "  \u6a21\u677f:%s | \u8fdb\u5ea6:%.1f%% | \u653e\u7f6e:%d | \u5931\u8d25:%d | \u4efb\u52a1ID:%s", status.templateName, Float.valueOf(status.progress * 100.0f), status.placedBlocks, status.failedBlocks, status.taskId);
                source.m_288197_(() -> Component.m_237113_((String)line), false);
            }
            if (activeTasks.size() > displayCount) {
                source.m_288197_(() -> Component.m_237113_((String)String.format(Locale.ROOT, "  \u00a77... \u8fd8\u6709 %d \u4e2a\u4efb\u52a1", activeTasks.size() - displayCount)), false);
            }
        }
        return 1;
    }
}

