/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;

public class TransportData {
    private final List<TransportRoute> routes = new ArrayList<TransportRoute>();
    private int currentIndex = 0;

    public boolean addRoute(BlockPos sourcePos, BlockPos targetPos, Direction side, TransportMode mode) {
        double distance = Math.sqrt(sourcePos.m_123331_((Vec3i)targetPos));
        if (distance > 50.0) {
            return false;
        }
        this.routes.add(new TransportRoute(targetPos, null, mode));
        return true;
    }

    public void removeRoute(int index) {
        if (index >= 0 && index < this.routes.size()) {
            this.routes.remove(index);
            if (this.routes.isEmpty()) {
                this.currentIndex = 0;
            } else if (this.currentIndex >= this.routes.size()) {
                this.currentIndex = this.routes.size() - 1;
            } else if (this.currentIndex > index && this.currentIndex > 0) {
                --this.currentIndex;
            }
        }
    }

    public void moveRouteUp(int index) {
        if (index > 0 && index < this.routes.size()) {
            TransportRoute route = this.routes.remove(index);
            this.routes.add(index - 1, route);
            if (this.currentIndex == index) {
                this.currentIndex = index - 1;
            } else if (this.currentIndex == index - 1) {
                this.currentIndex = index;
            }
        }
    }

    public void moveRouteDown(int index) {
        if (index >= 0 && index < this.routes.size() - 1) {
            TransportRoute route = this.routes.remove(index);
            this.routes.add(index + 1, route);
            if (this.currentIndex == index) {
                this.currentIndex = index + 1;
            } else if (this.currentIndex == index + 1) {
                this.currentIndex = index;
            }
        }
    }

    public void changeMode(int index, TransportMode mode) {
        if (index >= 0 && index < this.routes.size()) {
            this.routes.get(index).setMode(mode);
        }
    }

    public void setFilter(int routeIndex, int filterIndex, ItemStack stack) {
        if (routeIndex >= 0 && routeIndex < this.routes.size()) {
            this.routes.get(routeIndex).setFilter(filterIndex, stack);
        }
    }

    public void setQuantity(int routeIndex, int quantity) {
        if (routeIndex >= 0 && routeIndex < this.routes.size()) {
            this.routes.get(routeIndex).setQuantity(quantity);
        }
    }

    public List<TransportRoute> getRoutes() {
        return this.routes;
    }

    public TransportRoute getCurrentRoute() {
        if (this.routes.isEmpty()) {
            return null;
        }
        if (this.currentIndex >= this.routes.size()) {
            this.currentIndex = 0;
        }
        return this.routes.get(this.currentIndex);
    }

    public void moveToNext() {
        if (!this.routes.isEmpty()) {
            this.currentIndex = (this.currentIndex + 1) % this.routes.size();
        }
    }

    public boolean isEmpty() {
        return this.routes.isEmpty();
    }

    public void clear() {
        this.routes.clear();
        this.currentIndex = 0;
    }

    public void validateAndUpdateRoutes(BlockPos newSourcePos) {
        this.routes.removeIf(route -> {
            double distance = Math.sqrt(newSourcePos.m_123331_((Vec3i)route.getTargetPos()));
            return distance > 50.0;
        });
        if (this.routes.isEmpty()) {
            this.currentIndex = 0;
        } else if (this.currentIndex >= this.routes.size()) {
            this.currentIndex = 0;
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag routesList = new ListTag();
        for (TransportRoute route : this.routes) {
            routesList.add((Object)route.serializeNBT());
        }
        tag.m_128365_("Routes", (Tag)routesList);
        tag.m_128405_("CurrentIndex", this.currentIndex);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.routes.clear();
        ListTag routesList = tag.m_128437_("Routes", 10);
        for (int i = 0; i < routesList.size(); ++i) {
            TransportRoute route = new TransportRoute();
            route.deserializeNBT(routesList.m_128728_(i));
            this.routes.add(route);
        }
        this.currentIndex = tag.m_128451_("CurrentIndex");
        if (this.currentIndex >= this.routes.size() || this.currentIndex < 0) {
            this.currentIndex = 0;
        }
    }

    public static class TransportRoute {
        private static final int FILTER_SIZE = 9;
        private static final Random RANDOM = new Random();
        private BlockPos targetPos;
        private Direction side;
        private TransportMode mode;
        private final ItemStack[] filters = new ItemStack[9];
        private int quantity = 0;

        public TransportRoute() {
            this.targetPos = BlockPos.f_121853_;
            this.side = Direction.DOWN;
            this.mode = TransportMode.DEPOSIT;
            for (int i = 0; i < 9; ++i) {
                this.filters[i] = ItemStack.f_41583_;
            }
        }

        public TransportRoute(BlockPos pos, Direction side, TransportMode mode) {
            this.targetPos = pos;
            this.side = side;
            this.mode = mode;
            for (int i = 0; i < 9; ++i) {
                this.filters[i] = ItemStack.f_41583_;
            }
        }

        public boolean execute(TransportWorkstationBlockEntity workstation, Level level) {
            boolean result;
            BlockEntity targetEntity = level.m_7702_(this.targetPos);
            if (targetEntity instanceof WarehouseControlBlockEntity) {
                WarehouseControlBlockEntity warehouse = (WarehouseControlBlockEntity)targetEntity;
                return switch (this.mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case TransportMode.DEPOSIT -> this.depositItemsToWarehouse(workstation, warehouse);
                    case TransportMode.WITHDRAW -> this.withdrawItemsFromWarehouse(warehouse, workstation);
                };
            }
            if (!(targetEntity instanceof Container)) {
                return false;
            }
            Container targetContainer = (Container)targetEntity;
            switch (this.mode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case DEPOSIT: {
                    boolean bl = this.depositItems((Container)workstation, targetContainer);
                    break;
                }
                case WITHDRAW: {
                    boolean bl = result = this.withdrawItems(targetContainer, (Container)workstation);
                }
            }
            if (!result) {
                // empty if block
            }
            return result;
        }

        private boolean depositItems(Container from, Container to) {
            boolean movedAny = false;
            int MAX_ITEMS_PER_WORK = 5;
            boolean allFiltersEmpty = true;
            for (ItemStack filter : this.filters) {
                if (filter.m_41619_()) continue;
                allFiltersEmpty = false;
                break;
            }
            ArrayList<ItemStack> availableFilters = new ArrayList<ItemStack>();
            if (allFiltersEmpty) {
                for (int i = 0; i < from.m_6643_(); ++i) {
                    ItemStack stack = from.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    boolean alreadyAdded = false;
                    for (ItemStack existing : availableFilters) {
                        if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)stack)) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    availableFilters.add(stack.m_41777_());
                }
            } else {
                for (ItemStack filter : this.filters) {
                    int currentCountInTarget;
                    if (filter.m_41619_() || !this.hasItemInContainer(from, filter) || this.quantity > 0 && (currentCountInTarget = this.countItemsInContainer(to, filter)) >= this.quantity) continue;
                    availableFilters.add(filter);
                }
            }
            if (availableFilters.isEmpty()) {
                return false;
            }
            int itemsMovedThisWork = 0;
            for (int i = 0; i < 5; ++i) {
                int currentCountInTarget;
                ItemStack selectedFilter = (ItemStack)availableFilters.get(RANDOM.nextInt(availableFilters.size()));
                if (!this.hasItemInContainer(from, selectedFilter)) {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                    continue;
                }
                if (this.quantity > 0 && (currentCountInTarget = this.countItemsInContainer(to, selectedFilter)) >= this.quantity) {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                    continue;
                }
                int moved = this.transferItems(from, to, selectedFilter, 1);
                if (moved <= 0) continue;
                movedAny = true;
                itemsMovedThisWork += moved;
            }
            return movedAny;
        }

        private boolean withdrawItems(Container from, Container to) {
            boolean movedAny = false;
            int MAX_ITEMS_PER_WORK = 5;
            boolean allFiltersEmpty = true;
            for (ItemStack filter : this.filters) {
                if (filter.m_41619_()) continue;
                allFiltersEmpty = false;
                break;
            }
            ArrayList<ItemStack> availableFilters = new ArrayList<ItemStack>();
            if (allFiltersEmpty) {
                for (int i = 0; i < from.m_6643_(); ++i) {
                    ItemStack stack = from.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    boolean alreadyAdded = false;
                    for (ItemStack existing : availableFilters) {
                        if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)stack)) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    availableFilters.add(stack.m_41777_());
                }
            } else {
                for (ItemStack filter : this.filters) {
                    int currentCount;
                    if (filter.m_41619_() || !this.hasItemInContainer(from, filter) || this.quantity > 0 && (currentCount = this.countItemsInContainer(to, filter)) >= this.quantity) continue;
                    availableFilters.add(filter);
                }
            }
            if (availableFilters.isEmpty()) {
                return false;
            }
            int itemsMovedThisWork = 0;
            for (int i = 0; i < 5; ++i) {
                int currentCount;
                ItemStack selectedFilter = (ItemStack)availableFilters.get(RANDOM.nextInt(availableFilters.size()));
                if (!this.hasItemInContainer(from, selectedFilter)) {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                    continue;
                }
                if (this.quantity > 0 && (currentCount = this.countItemsInContainer(to, selectedFilter)) >= this.quantity) {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                    continue;
                }
                int moved = this.transferItems(from, to, selectedFilter, 1);
                if (moved <= 0) continue;
                movedAny = true;
                itemsMovedThisWork += moved;
            }
            return movedAny;
        }

        private int countItemsInContainer(Container container, ItemStack filter) {
            int count = 0;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)filter)) continue;
                count += stack.m_41613_();
            }
            return count;
        }

        private boolean hasItemInContainer(Container container, ItemStack filter) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)filter)) continue;
                return true;
            }
            return false;
        }

        private int transferItems(Container from, Container to, ItemStack filter, int maxAmount) {
            int transferred = 0;
            for (int i = 0; i < from.m_6643_(); ++i) {
                ItemStack fromStack = from.m_8020_(i);
                if (fromStack.m_41619_() || !ItemStack.m_150942_((ItemStack)fromStack, (ItemStack)filter)) continue;
                int toTransfer = Math.min(fromStack.m_41613_(), maxAmount - transferred);
                ItemStack transferStack = fromStack.m_41777_();
                transferStack.m_41764_(toTransfer);
                for (int j = 0; j < to.m_6643_() && !transferStack.m_41619_(); ++j) {
                    if (!to.m_7013_(j, transferStack)) continue;
                    ItemStack targetStack = to.m_8020_(j);
                    if (targetStack.m_41619_()) {
                        to.m_6836_(j, transferStack.m_41777_());
                        transferred += transferStack.m_41613_();
                        fromStack.m_41774_(transferStack.m_41613_());
                        transferStack.m_41764_(0);
                        continue;
                    }
                    if (!ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)transferStack)) continue;
                    int space = targetStack.m_41741_() - targetStack.m_41613_();
                    int toAdd = Math.min(space, transferStack.m_41613_());
                    targetStack.m_41769_(toAdd);
                    transferred += toAdd;
                    fromStack.m_41774_(toAdd);
                    transferStack.m_41774_(toAdd);
                }
                if (fromStack.m_41619_()) {
                    from.m_6836_(i, ItemStack.f_41583_);
                }
                if (transferred >= maxAmount) break;
            }
            return transferred;
        }

        public BlockPos getTargetPos() {
            return this.targetPos;
        }

        public Direction getSide() {
            return this.side;
        }

        public void setSide(Direction side) {
            this.side = side;
        }

        public TransportMode getMode() {
            return this.mode;
        }

        public void setMode(TransportMode mode) {
            this.mode = mode;
        }

        public void toggleMode() {
            this.mode = this.mode == TransportMode.DEPOSIT ? TransportMode.WITHDRAW : TransportMode.DEPOSIT;
        }

        public List<ItemStack> getFilters() {
            ArrayList<ItemStack> filterList = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                filterList.add(this.filters[i]);
            }
            return filterList;
        }

        public ItemStack getFilter(int index) {
            if (index >= 0 && index < 9) {
                return this.filters[index];
            }
            return ItemStack.f_41583_;
        }

        public void setFilter(int index, ItemStack stack) {
            if (index >= 0 && index < 9) {
                this.filters[index] = stack.m_41777_();
            }
        }

        public int getQuantity() {
            return this.quantity;
        }

        public void setQuantity(int quantity) {
            this.quantity = Math.max(0, Math.min(quantity, 999));
        }

        public int getFilterSize() {
            return 9;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("TargetPos", this.targetPos.m_121878_());
            tag.m_128405_("Side", this.side != null ? this.side.ordinal() : -1);
            tag.m_128405_("Mode", this.mode.ordinal());
            tag.m_128405_("Quantity", this.quantity);
            ListTag filterList = new ListTag();
            for (int i = 0; i < 9; ++i) {
                if (this.filters[i].m_41619_()) continue;
                CompoundTag filterTag = new CompoundTag();
                filterTag.m_128405_("Slot", i);
                filterTag.m_128365_("Item", (Tag)this.filters[i].m_41739_(new CompoundTag()));
                filterList.add((Object)filterTag);
            }
            tag.m_128365_("Filters", (Tag)filterList);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.targetPos = BlockPos.m_122022_((long)tag.m_128454_("TargetPos"));
            int sideOrdinal = tag.m_128451_("Side");
            this.side = sideOrdinal >= 0 && sideOrdinal < Direction.values().length ? Direction.values()[sideOrdinal] : null;
            this.mode = TransportMode.values()[tag.m_128451_("Mode")];
            this.quantity = tag.m_128451_("Quantity");
            for (int i = 0; i < 9; ++i) {
                this.filters[i] = ItemStack.f_41583_;
            }
            ListTag filterList = tag.m_128437_("Filters", 10);
            for (int i = 0; i < filterList.size(); ++i) {
                CompoundTag filterTag = filterList.m_128728_(i);
                int slot = filterTag.m_128451_("Slot");
                if (slot < 0 || slot >= 9) continue;
                this.filters[slot] = ItemStack.m_41712_((CompoundTag)filterTag.m_128469_("Item"));
            }
        }

        private boolean depositItemsToWarehouse(TransportWorkstationBlockEntity workstation, WarehouseControlBlockEntity warehouse) {
            boolean movedAny = false;
            int MAX_ITEMS_PER_WORK = 5;
            boolean allFiltersEmpty = true;
            for (ItemStack filter : this.filters) {
                if (filter.m_41619_()) continue;
                allFiltersEmpty = false;
                break;
            }
            ArrayList<ItemStack> availableFilters = new ArrayList<ItemStack>();
            if (allFiltersEmpty) {
                for (int i = 0; i < workstation.m_6643_(); ++i) {
                    ItemStack stack = workstation.m_8020_(i);
                    if (stack.m_41619_() || this.quantity > 0 && warehouse.getItemCount(stack) >= this.quantity) continue;
                    boolean alreadyAdded = false;
                    for (ItemStack existing : availableFilters) {
                        if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)stack)) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    availableFilters.add(stack.m_41777_());
                }
            } else {
                for (ItemStack filter : this.filters) {
                    int currentCountInWarehouse;
                    if (filter.m_41619_() || !this.hasItemInContainer((Container)workstation, filter) || this.quantity > 0 && (currentCountInWarehouse = warehouse.getItemCount(filter)) >= this.quantity) continue;
                    availableFilters.add(filter);
                }
            }
            if (availableFilters.isEmpty()) {
                return false;
            }
            for (int i = 0; i < 5; ++i) {
                ItemStack selectedFilter = (ItemStack)availableFilters.get(RANDOM.nextInt(availableFilters.size()));
                ItemStack extracted = this.extractOneItem((Container)workstation, selectedFilter);
                if (!extracted.m_41619_()) {
                    ItemStack remaining = warehouse.tryAddItem(extracted);
                    if (remaining.m_41619_()) {
                        movedAny = true;
                    } else if (remaining.m_41613_() < extracted.m_41613_()) {
                        movedAny = true;
                        remaining = this.addItemToContainer((Container)workstation, remaining);
                    } else {
                        remaining = this.addItemToContainer((Container)workstation, remaining);
                        availableFilters.remove(selectedFilter);
                        if (availableFilters.isEmpty()) break;
                        --i;
                    }
                }
                if (this.quantity <= 0 || warehouse.getItemCount(selectedFilter) < this.quantity) continue;
                availableFilters.remove(selectedFilter);
                if (availableFilters.isEmpty()) break;
            }
            return movedAny;
        }

        private boolean withdrawItemsFromWarehouse(WarehouseControlBlockEntity warehouse, TransportWorkstationBlockEntity workstation) {
            boolean movedAny = false;
            int MAX_ITEMS_PER_WORK = 5;
            boolean allFiltersEmpty = true;
            for (ItemStack filter : this.filters) {
                if (filter.m_41619_()) continue;
                allFiltersEmpty = false;
                break;
            }
            ArrayList<Object> availableFilters = new ArrayList<Object>();
            if (allFiltersEmpty) {
                for (ItemStack type : warehouse.getAvailableItemTypes()) {
                    if (warehouse.getItemCount(type) <= 0 || this.quantity > 0 && this.countItemsInContainer((Container)workstation, type) >= this.quantity) continue;
                    availableFilters.add(type);
                }
            } else {
                for (ItemStack filter : this.filters) {
                    int currentCountInWorkstation;
                    if (filter.m_41619_() || warehouse.getItemCount(filter) <= 0 || this.quantity > 0 && (currentCountInWorkstation = this.countItemsInContainer((Container)workstation, filter)) >= this.quantity) continue;
                    availableFilters.add(filter);
                }
            }
            if (availableFilters.isEmpty()) {
                return false;
            }
            for (int i = 0; i < 5; ++i) {
                ItemStack selectedFilter = (ItemStack)availableFilters.get(RANDOM.nextInt(availableFilters.size()));
                ItemStack request = selectedFilter.m_41777_();
                request.m_41764_(1);
                ItemStack extracted = warehouse.tryExtractItem(request);
                if (!extracted.m_41619_()) {
                    ItemStack remaining = this.addItemToContainer((Container)workstation, extracted);
                    if (remaining.m_41619_()) {
                        movedAny = true;
                    } else if (remaining.m_41613_() < extracted.m_41613_()) {
                        movedAny = true;
                    }
                    if (!remaining.m_41619_()) {
                        warehouse.tryAddItem(remaining);
                        availableFilters.remove(selectedFilter);
                        if (availableFilters.isEmpty()) break;
                        --i;
                    }
                } else {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                }
                if (this.quantity <= 0 || this.countItemsInContainer((Container)workstation, selectedFilter) < this.quantity) continue;
                availableFilters.remove(selectedFilter);
                if (availableFilters.isEmpty()) break;
            }
            return movedAny;
        }

        private ItemStack extractOneItem(Container container, ItemStack filter) {
            for (int slot = 0; slot < container.m_6643_(); ++slot) {
                ItemStack stack = container.m_8020_(slot);
                if (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)filter)) continue;
                return container.m_7407_(slot, 1);
            }
            return ItemStack.f_41583_;
        }

        private ItemStack addItemToContainer(Container container, ItemStack itemToAdd) {
            ItemStack remaining = itemToAdd.m_41777_();
            for (int slot = 0; slot < container.m_6643_() && !remaining.m_41619_(); ++slot) {
                int space;
                int toAdd;
                if (!container.m_7013_(slot, remaining)) continue;
                ItemStack slotStack = container.m_8020_(slot);
                if (slotStack.m_41619_()) {
                    container.m_6836_(slot, remaining.m_41777_());
                    remaining.m_41764_(0);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remaining) || (toAdd = Math.min(space = slotStack.m_41741_() - slotStack.m_41613_(), remaining.m_41613_())) <= 0) continue;
                slotStack.m_41769_(toAdd);
                remaining.m_41774_(toAdd);
            }
            return remaining;
        }
    }

    public static enum TransportMode {
        DEPOSIT("transport.mode.deposit"),
        WITHDRAW("transport.mode.withdraw");

        private final String translationKey;

        private TransportMode(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public TransportMode toggle() {
            return this == DEPOSIT ? WITHDRAW : DEPOSIT;
        }
    }
}

